/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.inventory.server.api.model;

import com.inet.field.fieldtypes.FieldType;
import com.inet.field.fieldtypes.FieldTypeFactory;
import com.inet.field.fieldtypes.FieldTypeInteger;
import com.inet.field.fieldtypes.FieldTypeString;
import com.inet.fieldsettings.api.model.FieldSettingsType;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.AssetFieldLicense;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.AssetFieldLocation;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.AssetFieldName;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.AssetFieldSLA;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.AssetFieldType;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.AssetFieldUser;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.AssetFieldVendor;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.AssetField_Id;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.AssetField_Image;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.AssetField_Parent;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.abstracts.AssetField;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.abstracts.AssetFieldDefinition;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.abstracts.AssetField_Currency;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.abstracts.AssetField_DateTime;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.abstracts.AssetField_String;
import com.inet.helpdesk.plugins.inventory.server.api.search.SearchTagImportFlag;
import com.inet.helpdesk.plugins.inventory.server.ticket.ReaStepFieldAssetId;
import com.inet.helpdesk.plugins.inventory.server.ticket.TicketFieldAffectedAssets;
import com.inet.plugin.DynamicExtensionManager;
import com.inet.search.SearchDataType;
import com.inet.search.SearchTag;
import com.inet.search.tokenizers.GuidTokenizer;
import com.inet.search.tokenizers.SearchTokenizer;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public class AssetFields {
    public static final AssetField_Parent FIELD_PARENT = new AssetField_Parent("parent", 10);
    public static final AssetField<Integer> FIELD_INT_ID = new AssetField_Id("intid");
    public static final AssetField_Image FIELD_IMAGE = new AssetField_Image("image");
    public static final AssetFieldName FIELD_NAME = new AssetFieldName("name", null, 8, FieldSettingsType.TYPE_TEXT, 100);
    public static final AssetFieldType FIELD_TYPE = new AssetFieldType("type", 9);
    public static final AssetField_String FIELD_ASSET_NUMBER = new AssetField_String("assetnumber", null, 12, FieldSettingsType.TYPE_TEXT, 50);
    public static final AssetField_String FIELD_COSTCENTER = new AssetField_String("costcenter", null, 13, FieldSettingsType.TYPE_TEXT, 50);
    public static final AssetFieldLocation FIELD_LOCATION = new AssetFieldLocation("location", 14);
    public static final AssetField_String FIELD_ROOM = new AssetField_String("room", null, 15, FieldSettingsType.TYPE_TEXT, 50);
    public static final AssetField_String FIELD_COMPUTERNAME = new AssetField_String("computername", null, 16, FieldSettingsType.TYPE_TEXT, 255);
    public static final AssetField_String FIELD_SERIAL_NUMBER = new AssetField_String("serialnumber", null, 17, FieldSettingsType.TYPE_TEXT, 50);
    public static final AssetField_Currency FIELD_PRICE = new AssetField_Currency("price", null, 18);
    public static final AssetField_String FIELD_INVOICE_NUMBER = new AssetField_String("invoicenumber", null, 19, FieldSettingsType.TYPE_TEXT, 50);
    public static final AssetField_DateTime FIELD_PURCHASE_DATE = new AssetField_DateTime("purchasedate", null, 20, false);
    public static final AssetField_DateTime FIELD_WARRANTY = new AssetField_DateTime("warranty", null, 21, false);
    public static final AssetField<Integer> FIELD_IMPORTED = new AssetField<Integer>("imported", Integer.valueOf(0), FieldTypeFactory.custom()){

        public String getLabel() {
            return "imported";
        }

        @Nonnull
        public FieldType<Integer> createFieldType() {
            return new FieldTypeInteger(this.getKey(), () -> this.getLabel()){

                public SearchTag createSearchTag(Supplier<String> labelProvider, FieldTypeFactory factory) {
                    return new SearchTagImportFlag();
                }
            };
        }
    };
    public static final AssetField<String> FIELD_IMPORTED_FROM_COLUMN = new AssetField<String>("refid", null, FieldTypeFactory.custom()){

        public String getLabel() {
            return "refid";
        }

        @Nonnull
        public FieldType<String> createFieldType() {
            return new FieldTypeString(this.getKey(), this::getLabel){

                public SearchTag createSearchTag(Supplier<String> displayname, FieldTypeFactory factory) {
                    return new SearchTag(this.getKey(), SearchDataType.ID, true, (SearchTokenizer)new GuidTokenizer(), 10, () -> this.getLabel(), false);
                }
            };
        }
    };
    public static final AssetField<String> FIELD_IMPORT_NAME = new AssetField<String>("impname", null, FieldTypeFactory.custom()){

        public String getLabel() {
            return "impname";
        }

        @Nonnull
        public FieldType<String> createFieldType() {
            return new FieldTypeString(this.getKey(), () -> this.getLabel()){

                public SearchTag createSearchTag(Supplier<String> displayname, FieldTypeFactory factory) {
                    return new SearchTag(this.getKey(), SearchDataType.ID, true, (SearchTokenizer)new GuidTokenizer(), 10, () -> this.getLabel(), false);
                }
            };
        }
    };
    public static final AssetFieldUser FIELD_OWNER = new AssetFieldUser("owner", 11);
    public static final AssetFieldLicense FIELD_LICENSE = new AssetFieldLicense("license", 23);
    public static final AssetFieldSLA FIELD_SLA = new AssetFieldSLA("sla", 24);
    public static final AssetFieldVendor FIELD_VENDOR = new AssetFieldVendor("vendor", 25);
    public static final String FIELD_OPEN1 = "custom1";
    public static final String FIELD_OPEN2 = "custom2";
    public static final String FIELD_OPEN3 = "custom3";
    public static final String FIELD_OPEN4 = "custom4";
    public static final String FIELD_OPEN5 = "custom5";
    public static final String FIELD_OPEN6 = "custom6";
    public static final String FIELD_OPEN7 = "custom7";
    public static final String FIELD_OPEN8 = "custom8";
    public static final String FIELD_OPEN9 = "custom9";
    public static final AssetField_String FIELD_DESCRIPTION = new AssetField_String("description", null, 35, FieldSettingsType.TYPE_MULTILINE_TEXT, 10000);
    public static final TicketFieldAffectedAssets TICKET_FIELD_AFFECTED_ASSETS = new TicketFieldAffectedAssets();
    public static final ReaStepFieldAssetId FIELD_INVENTORY_ASSETID = new ReaStepFieldAssetId();

    public static List<AssetField<?>> getPredefinedAssetFields() {
        ArrayList fields = new ArrayList();
        fields.add(FIELD_NAME);
        fields.add(FIELD_TYPE);
        fields.add(FIELD_ASSET_NUMBER);
        fields.add(FIELD_COSTCENTER);
        fields.add(FIELD_LOCATION);
        fields.add(FIELD_ROOM);
        fields.add(FIELD_COMPUTERNAME);
        fields.add(FIELD_SERIAL_NUMBER);
        fields.add(FIELD_PRICE);
        fields.add(FIELD_INVOICE_NUMBER);
        fields.add(FIELD_PURCHASE_DATE);
        fields.add(FIELD_WARRANTY);
        fields.add(FIELD_OWNER);
        fields.add(FIELD_LICENSE);
        fields.add(FIELD_SLA);
        fields.add(FIELD_VENDOR);
        fields.add(FIELD_DESCRIPTION);
        fields.add(FIELD_PARENT);
        fields.add(FIELD_INT_ID);
        fields.add(FIELD_IMPORTED);
        fields.add(FIELD_IMPORTED_FROM_COLUMN);
        fields.add(FIELD_IMPORT_NAME);
        return fields;
    }

    public static List<AssetField<?>> getFieldsWithOwnColumn() {
        ArrayList fields = new ArrayList();
        fields.add(FIELD_NAME);
        fields.add(FIELD_TYPE);
        fields.add(FIELD_ASSET_NUMBER);
        fields.add(FIELD_COSTCENTER);
        fields.add(FIELD_LOCATION);
        fields.add(FIELD_ROOM);
        fields.add(FIELD_COMPUTERNAME);
        fields.add(FIELD_SERIAL_NUMBER);
        fields.add(FIELD_PRICE);
        fields.add(FIELD_INVOICE_NUMBER);
        fields.add(FIELD_PURCHASE_DATE);
        fields.add(FIELD_WARRANTY);
        fields.add(FIELD_OWNER);
        fields.add(FIELD_LICENSE);
        fields.add(FIELD_SLA);
        fields.add(FIELD_VENDOR);
        fields.add(AssetFields.getFieldFor(FIELD_OPEN1));
        fields.add(AssetFields.getFieldFor(FIELD_OPEN2));
        fields.add(AssetFields.getFieldFor(FIELD_OPEN3));
        fields.add(AssetFields.getFieldFor(FIELD_OPEN4));
        fields.add(AssetFields.getFieldFor(FIELD_OPEN5));
        fields.add(AssetFields.getFieldFor(FIELD_OPEN6));
        fields.add(AssetFields.getFieldFor(FIELD_OPEN7));
        fields.add(AssetFields.getFieldFor(FIELD_OPEN8));
        fields.add(AssetFields.getFieldFor(FIELD_OPEN9));
        fields.add(FIELD_DESCRIPTION);
        fields.add(FIELD_PARENT);
        fields.add(FIELD_INT_ID);
        fields.add(FIELD_IMPORTED);
        fields.add(FIELD_IMPORTED_FROM_COLUMN);
        fields.add(FIELD_IMPORT_NAME);
        return fields;
    }

    public static <T> AssetField<T> getFieldFor(String fieldKey) {
        return DynamicExtensionManager.getInstance().get(AssetField.class).stream().filter(f -> f.getKey().equals(fieldKey)).findFirst().orElse(null);
    }

    public static AssetFieldDefinition getFieldDefinitionFor(String fieldKey) {
        return DynamicExtensionManager.getInstance().get(AssetFieldDefinition.class).stream().filter(f -> f.getFieldKey().equals(fieldKey)).findFirst().orElse(null);
    }

    public static List<AssetFieldDefinition> getFieldsAvailableInAssetType(int typeId) {
        return DynamicExtensionManager.getInstance().get(AssetFieldDefinition.class).stream().filter(f -> f.isVisibleInType(typeId)).collect(Collectors.toList());
    }

    public static boolean isOpenField(String key) {
        return FIELD_OPEN1.equals(key) || FIELD_OPEN2.equals(key) || FIELD_OPEN3.equals(key) || FIELD_OPEN4.equals(key) || FIELD_OPEN5.equals(key) || FIELD_OPEN6.equals(key) || FIELD_OPEN7.equals(key) || FIELD_OPEN8.equals(key) || FIELD_OPEN9.equals(key);
    }
}

