/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.inventory.client.handler;

import com.inet.authentication.AccessForbiddenException;
import com.inet.helpdesk.plugins.inventory.client.data.AssetUser;
import com.inet.helpdesk.plugins.inventory.client.data.GetUsersRequest;
import com.inet.helpdesk.plugins.inventory.client.data.GetUsersResponse;
import com.inet.helpdesk.plugins.inventory.client.handler.AbstractInventoryHandler;
import com.inet.id.GUID;
import com.inet.lib.util.StringFunctions;
import com.inet.search.SearchResult;
import com.inet.search.SearchResultEntry;
import com.inet.search.command.SearchCondition;
import com.inet.search.command.SearchID;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserAccountType;
import com.inet.usersandgroups.api.user.UserManager;
import com.inet.usersandgroups.user.search.SearchTagActive;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.ArrayList;

public class GetUsersHandler
extends AbstractInventoryHandler<GetUsersRequest, GetUsersResponse> {
    private static final int MAX_ENTRIES = 5000;

    public String getMethodName() {
        return "inventory.getusers";
    }

    @Override
    public short getMethodType() {
        return 1;
    }

    @Override
    public GetUsersResponse handle(HttpServletRequest req, HttpServletResponse resp, GetUsersRequest payload) throws IOException {
        UserAccount currentUser = UserManager.getInstance().getCurrentUserAccount();
        if (currentUser == null) {
            throw new AccessForbiddenException();
        }
        boolean includeEmptyEntry = payload.isIncludeEmptyEntry();
        int chunkSize = payload.getChunkSize();
        int currentSize = payload.getCurrentSize();
        String filter = payload.getFilter();
        int requestNumber = payload.getRequestNumber();
        SearchID searchID = new SearchID((Object)(this.getMethodName() + "_" + req.getSession().getId()));
        ArrayList<AssetUser> users = new ArrayList<AssetUser>();
        ArrayList boostingExpressions = new ArrayList();
        ArrayList<SearchCondition> additionalExpressions = new ArrayList<SearchCondition>();
        additionalExpressions.add(new SearchCondition("active", SearchCondition.SearchTermOperator.Equals, (Object)SearchTagActive.valueAsString((boolean)true)));
        additionalExpressions.add(new SearchCondition("useraccounttype", SearchCondition.SearchTermOperator.Unequals, (Object)UserAccountType.Temp.name()));
        UserManager manager = UserManager.getInstance();
        SearchResult searchResult = manager.searchAsUser(filter, additionalExpressions, boostingExpressions, 10000, searchID);
        int count = 0;
        if (includeEmptyEntry && currentSize == 0 && StringFunctions.isEmpty((String)filter)) {
            ++count;
            users.add(new AssetUser(null, "", "", ""));
        }
        for (SearchResultEntry e : searchResult.getEntries()) {
            UserAccount userAccount;
            if (++count > currentSize && (userAccount = manager.getUserAccount((GUID)e.getId())) != null) {
                users.add(new AssetUser((GUID)e.getId(), userAccount.getDisplayName(), e.getFirstResultLine(), e.getSecondResultLine()));
            }
            if (users.size() < chunkSize) continue;
            break;
        }
        return new GetUsersResponse(requestNumber, users);
    }
}

