/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.inventory.client.handler;

import com.inet.annotations.JsonData;
import com.inet.field.SelectOption;
import com.inet.helpdesk.plugins.inventory.client.handler.AbstractInventoryHandler;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.sla.AssetSLA;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.sla.AssetSLAManager;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.usersandgroups.api.groups.UserGroupInfo;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;

public class GetSLAResource
extends AbstractInventoryHandler<GetSLAResourceRequest, GetSLAResourceResponse> {
    public String getMethodName() {
        return "inventory.getslaresource";
    }

    @Override
    public GetSLAResourceResponse handle(HttpServletRequest req, HttpServletResponse resp, GetSLAResourceRequest payload) throws IOException {
        List<Integer> slaIds = payload.getAssetIds();
        for (Integer slaId : slaIds) {
            UserGroupInfo resource;
            Integer resID;
            AssetSLA assetSLA = (AssetSLA)AssetSLAManager.getInstance().get(slaId);
            if (assetSLA == null || (resID = assetSLA.getResID()) == null || (resource = HDUsersAndGroups.getResource((int)resID)) == null || !resource.isActive()) continue;
            SelectOption option = new SelectOption(resource.getID().toString(), resource.getDisplayName(), HDUsersAndGroups.getResourceIconKey((UserGroupInfo)resource));
            return new GetSLAResourceResponse(option);
        }
        return null;
    }

    @JsonData
    public static class GetSLAResourceRequest {
        private List<Integer> slaIds;

        private GetSLAResourceRequest() {
        }

        public List<Integer> getAssetIds() {
            return this.slaIds;
        }
    }

    @JsonData
    public static class GetSLAResourceResponse {
        private SelectOption resourceOption;

        public GetSLAResourceResponse(SelectOption resourceOption) {
            this.resourceOption = resourceOption;
        }
    }
}

