/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.inventory.server.webapi.util;

import com.inet.helpdesk.plugins.inventory.client.InventoryAttachments;
import com.inet.helpdesk.plugins.inventory.server.api.AssetManager;
import com.inet.helpdesk.plugins.inventory.server.api.model.AssetFields;
import com.inet.helpdesk.plugins.inventory.server.api.model.AssetView;
import com.inet.helpdesk.plugins.inventory.server.api.model.HistoryStep;
import com.inet.helpdesk.plugins.inventory.server.api.model.MutableAssetData;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.abstracts.AssetField;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.abstracts.AssetFieldDefinition;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.abstracts.AssetFieldWithDefinition;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.type.AssetTypeManager;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.type.AssetTypeVO;
import com.inet.helpdesk.plugins.inventory.server.webapi.InventoryWebAPIExtension;
import com.inet.http.ClientMessageException;
import com.inet.http.upload.AttachmentDescription;
import com.inet.id.GUID;
import com.inet.lib.json.Json;
import com.inet.plugin.DynamicExtensionManager;
import com.inet.plugin.ServerPluginManager;
import com.inet.shared.http.upload.AttachmentType;
import com.inet.usersandgroups.api.user.UserManager;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.Part;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class InventoryWebAPIHelper {
    private static final Comparator<? super AssetFieldDefinition> SORT_COMPARATOR = (a, b) -> {
        int compare = Integer.compare(a.getPriority(), b.getPriority());
        if (compare == 0) {
            compare = String.CASE_INSENSITIVE_ORDER.compare(a.getLabel(), b.getLabel());
        }
        return compare;
    };

    @Nonnull
    public static List<AssetFieldDefinition> getAvailableAssetFields(@Nullable AssetTypeVO assetType) {
        if (assetType == null) {
            return new ArrayList<AssetFieldDefinition>();
        }
        List<AssetFieldDefinition> list = AssetFields.getFieldsAvailableInAssetType(assetType.getId());
        list.sort(SORT_COMPARATOR);
        return list;
    }

    public static List<AssetFieldDefinition> getAssetFieldDefintions() {
        List assetFields = DynamicExtensionManager.getInstance().get(AssetFieldDefinition.class);
        assetFields.sort(SORT_COMPARATOR);
        return assetFields;
    }

    @Nonnull
    public static MutableAssetData prepareAssetData(@Nonnull Map<String, Object> updateData, AssetTypeVO assetType) {
        MutableAssetData dataToChange = new MutableAssetData();
        if (assetType == null) {
            try {
                Object typeO = updateData.get("type");
                Objects.requireNonNull(typeO);
                int type = Integer.parseInt(typeO.toString());
                assetType = (AssetTypeVO)AssetTypeManager.getInstance().get(type);
                if (assetType == null) {
                    throw new ClientMessageException(InventoryWebAPIExtension.MSG.getMsg("asset.type.wrongFormat", new Object[]{typeO}));
                }
            }
            catch (NullPointerException e) {
                throw new ClientMessageException(InventoryWebAPIExtension.MSG.getMsg("asset.type.noFormat", new Object[0]));
            }
            catch (IllegalStateException | NumberFormatException e) {
                throw new ClientMessageException(InventoryWebAPIExtension.MSG.getMsg("asset.type.wrongFormat", new Object[]{updateData.get("type")}));
            }
        }
        List<AssetFieldDefinition> assetFields = InventoryWebAPIHelper.getAvailableAssetFields(assetType);
        for (AssetFieldDefinition definition : assetFields) {
            AssetField key = AssetFields.getFieldFor(definition.getFieldKey());
            if (key == null || !updateData.containsKey(key.getKey())) continue;
            Object object = updateData.get(key.getKey());
            String value = object == null ? null : (object instanceof String ? object.toString() : new Json().toJson(object));
            try {
                dataToChange.put(key, ((AssetFieldWithDefinition)definition).valueOf(value));
            }
            catch (Exception e) {
                throw new ClientMessageException(InventoryWebAPIExtension.MSG.getMsg("asset.update.classCast", new Object[]{key.getKey(), value, e.getMessage()}));
            }
        }
        Object object = updateData.get(AssetFields.FIELD_IMAGE.getKey());
        if (object != null) {
            dataToChange.put(AssetFields.FIELD_IMAGE, object.toString());
        }
        return dataToChange;
    }

    /*
     * Unable to fully structure code
     */
    public static List<AssetManager.AdditionalTask> checkAttachmentsUpdateRequest(HttpServletRequest request, Map<String, Object> updateData) {
        extensionTasks = new ArrayList<AssetManager.AdditionalTask>();
        if (!ServerPluginManager.getInstance().isPluginLoaded("attachments")) {
            return extensionTasks;
        }
        attachments = new ArrayList<AttachmentDescription>();
        object = updateData.get("attachments");
        if (object != null) {
            json = new Json();
            try {
                fromJson = json.toJson(object);
                responseJson = (List)json.fromJson(fromJson, List.class, new Type[]{AttachmentDescription.class});
                if (responseJson == null) ** GOTO lbl27
                attachments.addAll(responseJson);
            }
            catch (Exception e) {
                throw new ClientMessageException(InventoryWebAPIExtension.MSG.getMsg("asset.update.attachmentDescription", new Object[]{e.getMessage()}));
            }
        } else {
            try {
                parts = request.getParts();
                for (Part part : parts) {
                    if ("json".equals(part.getName()) || !part.getName().startsWith("attachment")) continue;
                    attachments.add(new AttachmentDescription(part.getSubmittedFileName(), System.currentTimeMillis(), AttachmentType.Unknown));
                }
            }
            catch (ServletException | IOException var5_7) {
                // empty catch block
            }
        }
lbl27:
        // 4 sources

        if (!attachments.isEmpty()) {
            extensionTasks.add((AssetManager.AdditionalTask)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)V, lambda$checkAttachmentsUpdateRequest$1(java.util.List jakarta.servlet.http.HttpServletRequest com.inet.helpdesk.plugins.inventory.server.api.model.AssetView java.util.function.Consumer ), (Lcom/inet/helpdesk/plugins/inventory/server/api/model/AssetView;Ljava/util/function/Consumer;)V)(attachments, (HttpServletRequest)request));
        }
        return extensionTasks;
    }

    private static /* synthetic */ void lambda$checkAttachmentsUpdateRequest$1(List attachments, HttpServletRequest request, AssetView updatedAsset, Consumer historyAdder) {
        InventoryAttachments.saveAttachment(updatedAsset, attachments, request);
        long currentTimeMillis = System.currentTimeMillis();
        GUID currentUserAccountID = UserManager.getInstance().getCurrentUserAccountID();
        for (AttachmentDescription att : attachments) {
            historyAdder.accept(new HistoryStep(updatedAsset.getIntID(), currentTimeMillis, currentUserAccountID, AssetManager.MSG.getMsg("attachment.history.add", new Object[]{att.getName()})));
        }
    }
}

