/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.inventory.server.taskplanner.series.asset;

import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.plugins.inventory.server.api.AssetManager;
import com.inet.helpdesk.plugins.inventory.server.api.model.AbstractAsset;
import com.inet.helpdesk.plugins.inventory.server.api.model.AssetFields;
import com.inet.helpdesk.plugins.inventory.server.api.model.AssetView;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.abstracts.AssetFieldDefinition;
import com.inet.http.servlet.ClientLocale;
import com.inet.id.GUID;
import com.inet.lib.util.Scope;
import com.inet.plugin.DynamicExtensionManager;
import com.inet.search.command.SearchCommand;
import com.inet.search.command.SearchCondition;
import com.inet.search.command.TextSearchCommandBuilder;
import com.inet.search.index.IndexSearchEngine;
import com.inet.taskplanner.server.api.action.PlaceholderResolver;
import com.inet.taskplanner.server.api.series.Series;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class AssetSeries
implements Series {
    @Nullable
    private final GUID taskId;
    @Nullable
    private final GUID seriesId;
    @Nullable
    private final String query;
    @Nonnull
    private final String lang;
    @Nonnull
    private Map<String, String> triggerProperties;

    public AssetSeries(@Nullable GUID taskId, @Nullable GUID seriesId, @Nullable String query, @Nonnull String lang) {
        this.taskId = taskId;
        this.seriesId = seriesId;
        this.query = query;
        this.lang = lang;
    }

    public void cleanUp(boolean wasPreview) throws Exception {
    }

    public void setTriggerProperties(@Nonnull Map<String, String> triggerProperties) {
        this.triggerProperties = triggerProperties;
    }

    public Iterator<Map<String, String>> iterator() {
        ArrayList assets = new ArrayList();
        Collection<GUID> ids = this.runSearch(this.getAssetManager());
        List<AssetView> views = this.getAssetManager().getAssets(ids, true);
        views.sort(Comparator.comparing(AbstractAsset::getName, Comparator.nullsLast(String.CASE_INSENSITIVE_ORDER)));
        List fieldDefinitions = DynamicExtensionManager.getInstance().get(AssetFieldDefinition.class);
        for (AssetView view : views) {
            if (view == null) {
                HDLogger.debug((Object)"Asset View was null");
                continue;
            }
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("asset.id", view.getId().toString());
            map.put("asset.name", view.getName());
            fieldDefinitions.forEach(def -> {
                String fieldKey = def.getFieldKey();
                if ("name".equals(fieldKey) || "id".equals(fieldKey)) {
                    return;
                }
                String displayValue = def.getDisplayValue(view);
                map.put("asset." + fieldKey, displayValue == null ? "" : displayValue);
            });
            assets.add(map);
        }
        return assets.iterator();
    }

    @Nonnull
    Collection<GUID> runSearch(@Nonnull AssetManager assetManager) {
        Set ids;
        String q = new PlaceholderResolver(this.query).withPlaceHolderCharacters("{", "}").addMetaData(this.triggerProperties).resolve();
        IndexSearchEngine searchEngine = assetManager.getSearchEngine();
        if (q == null || q.isBlank()) {
            ids = searchEngine.simpleSearch(new SearchCommand(AssetFields.FIELD_INT_ID.getKey(), SearchCondition.SearchTermOperator.GE, (Object)0));
        } else {
            Locale locale = Locale.forLanguageTag(this.lang);
            try (Scope scope = ClientLocale.scope((Locale)locale);){
                SearchCommand c = new TextSearchCommandBuilder(searchEngine, q).build(locale);
                ids = searchEngine.simpleSearch(c);
            }
        }
        return ids;
    }

    @Nonnull
    protected AssetManager getAssetManager() {
        return AssetManager.getInstance();
    }
}

