/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.inventory.server.maintenance.datacare;

import com.inet.classloader.I18nMessages;
import com.inet.helpdesk.core.data.ServerDataException;
import com.inet.helpdesk.plugins.inventory.server.api.AssetManager;
import com.inet.helpdesk.plugins.inventory.server.api.maintenance.AssetPreviewEntry;
import com.inet.helpdesk.plugins.inventory.server.api.model.AssetView;
import com.inet.helpdesk.plugins.inventory.server.api.search.SearchTagArchived;
import com.inet.helpdesk.plugins.maintenance.server.datacare.api.DataCarePreview;
import com.inet.helpdesk.plugins.maintenance.server.datacare.api.DataCareTask;
import com.inet.id.GUID;
import com.inet.search.command.SearchCommand;
import com.inet.search.command.SearchCondition;
import com.inet.search.command.SearchExpression;
import com.inet.search.index.IndexSearchEngine;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ArchivedDeviceDataCareTask
implements DataCareTask {
    public static final I18nMessages MSG = new I18nMessages("com.inet.helpdesk.plugins.inventory.server.maintenance.datacare.i18n.LanguageResources", ArchivedDeviceDataCareTask.class);

    @Nonnull
    public String getExtensionName() {
        return "datacare.archiveddevices";
    }

    public String getTitle() {
        return MSG.getMsg("datacare.archiveddevices.title", new Object[0]);
    }

    public String getDescription() {
        return MSG.getMsg("datacare.archiveddevices.description", new Object[0]);
    }

    public int getPriority() {
        return 121;
    }

    protected AssetManager getAssetManager() {
        return AssetManager.getInstance();
    }

    public DataCarePreview getPreview(HashMap<String, String> parameters) throws ServerDataException {
        AssetManager manager = this.getAssetManager();
        IndexSearchEngine searchEngine = manager.getSearchEngine();
        ArrayList archived = new ArrayList(searchEngine.simpleSearch(new SearchCommand(new SearchExpression[]{new SearchCondition("archived", SearchCondition.SearchTermOperator.Equals, (Object)SearchTagArchived.TRUE)})));
        int totalAssets = archived.size();
        ArrayList<AssetPreviewEntry> list = new ArrayList<AssetPreviewEntry>();
        while (list.size() < 6 && archived.size() > 0) {
            AssetView asset = manager.getAsset((GUID)archived.remove(0));
            if (asset == null) continue;
            list.add(AssetPreviewEntry.generateEntryFromAsset(asset));
        }
        DataCarePreview preview = new DataCarePreview();
        preview.setPreviewMsg(MSG.getMsg(totalAssets > 0 ? "datacare.archiveddevices.preview" : "datacare.archiveddevices.nopreview", new Object[]{totalAssets}));
        preview.setExamples(list);
        return preview;
    }

    @Nullable
    public GUID executeDelete(HashMap<String, String> parameters) {
        AssetManager manager = this.getAssetManager();
        IndexSearchEngine searchEngine = manager.getSearchEngine();
        Set archived = searchEngine.simpleSearch(new SearchCommand(new SearchExpression[]{new SearchCondition("archived", SearchCondition.SearchTermOperator.Equals, (Object)SearchTagArchived.TRUE)}));
        for (GUID g : archived) {
            manager.maintenance().physicallyDeleteDevice(g);
        }
        return null;
    }
}

