/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.inventory.server.plugin;

import com.inet.classloader.I18nMessages;
import com.inet.config.ConfigKey;
import com.inet.config.structure.model.ConfigPage;
import com.inet.config.structure.provider.ConfigStructureProvider;
import com.inet.field.fieldtypes.FieldTypeFactory;
import com.inet.file.CombinedFileDescription;
import com.inet.file.FileCombiner;
import com.inet.helpdesk.core.data.AdditionalFieldSetting;
import com.inet.helpdesk.core.data.ConnectionCreationListener;
import com.inet.helpdesk.core.data.ConnectionFactory;
import com.inet.helpdesk.core.ticketmanager.ExtensionArguments;
import com.inet.helpdesk.core.ticketmanager.TicketManagerVetoPower;
import com.inet.helpdesk.core.ticketmanager.extension.TicketActionExtensionFactory;
import com.inet.helpdesk.core.ticketmanager.fielddefinitions.AdditionalReaStepFieldDefinition;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionManager;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionVO;
import com.inet.helpdesk.core.ticketmanager.model.events.domain.TicketEventListener;
import com.inet.helpdesk.core.ticketmanager.model.reasteps.ReaStepField;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketField;
import com.inet.helpdesk.core.ticketmanager.ui.model.TicketFieldDefinition;
import com.inet.helpdesk.core.ticketmanager.ui.model.TicketPageExtension;
import com.inet.helpdesk.plugins.inventory.client.InventoryAngularApplicationServlet;
import com.inet.helpdesk.plugins.inventory.client.InventoryModule;
import com.inet.helpdesk.plugins.inventory.client.data.InventoryTreeGroupEntry;
import com.inet.helpdesk.plugins.inventory.client.event.InitInventoryDetails;
import com.inet.helpdesk.plugins.inventory.client.event.InitInventoryStructure;
import com.inet.helpdesk.plugins.inventory.client.event.InitInventoryTree;
import com.inet.helpdesk.plugins.inventory.client.event.LoadMoreStructureChildren;
import com.inet.helpdesk.plugins.inventory.client.event.LoadMoreTreeChildren;
import com.inet.helpdesk.plugins.inventory.client.event.TreeNodesChanged;
import com.inet.helpdesk.plugins.inventory.client.event.UpdateInventoryStructure;
import com.inet.helpdesk.plugins.inventory.client.event.UpdateInventoryTree;
import com.inet.helpdesk.plugins.inventory.client.event.ViewSettingsChangedEvent;
import com.inet.helpdesk.plugins.inventory.client.handler.AdditionalDetails;
import com.inet.helpdesk.plugins.inventory.client.handler.AssetIcon;
import com.inet.helpdesk.plugins.inventory.client.handler.DeleteAssets;
import com.inet.helpdesk.plugins.inventory.client.handler.DeleteAttachment;
import com.inet.helpdesk.plugins.inventory.client.handler.DeviceFieldValueIcon;
import com.inet.helpdesk.plugins.inventory.client.handler.GetAssetDetails;
import com.inet.helpdesk.plugins.inventory.client.handler.GetAssetFields;
import com.inet.helpdesk.plugins.inventory.client.handler.GetAssets;
import com.inet.helpdesk.plugins.inventory.client.handler.GetSLAResource;
import com.inet.helpdesk.plugins.inventory.client.handler.GetSelectOptions;
import com.inet.helpdesk.plugins.inventory.client.handler.GetUsersHandler;
import com.inet.helpdesk.plugins.inventory.client.handler.InitialData;
import com.inet.helpdesk.plugins.inventory.client.handler.InventoryViewSettings;
import com.inet.helpdesk.plugins.inventory.client.handler.LoadSuggestions;
import com.inet.helpdesk.plugins.inventory.client.handler.LoadTreeGroupingSettings;
import com.inet.helpdesk.plugins.inventory.client.handler.MoveAssets;
import com.inet.helpdesk.plugins.inventory.client.handler.PrepareNewAsset;
import com.inet.helpdesk.plugins.inventory.client.handler.SaveAsset;
import com.inet.helpdesk.plugins.inventory.client.handler.SaveTreeGroupingSettings;
import com.inet.helpdesk.plugins.inventory.client.handler.UndeleteAssets;
import com.inet.helpdesk.plugins.inventory.client.ticketpageextension.InventoryTicketPageExtension;
import com.inet.helpdesk.plugins.inventory.client.ticketpageextension.RegisterAffectedAssets;
import com.inet.helpdesk.plugins.inventory.client.ticketpageextension.UpdateAffectedAssets;
import com.inet.helpdesk.plugins.inventory.server.api.AssetFieldSettingsManager;
import com.inet.helpdesk.plugins.inventory.server.api.AssetListener;
import com.inet.helpdesk.plugins.inventory.server.api.AssetManager;
import com.inet.helpdesk.plugins.inventory.server.api.model.AssetFields;
import com.inet.helpdesk.plugins.inventory.server.api.model.MutableAssetData;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.AssetAdditionalFieldSetting;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.abstracts.AssetField;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.abstracts.AssetFieldDefinition;
import com.inet.helpdesk.plugins.inventory.server.config.AssetFieldsConfigStructureProvider;
import com.inet.helpdesk.plugins.inventory.server.config.InventoryConfigPage;
import com.inet.helpdesk.plugins.inventory.server.config.InventoryGenericFieldsStructureProvider;
import com.inet.helpdesk.plugins.inventory.server.eventlog.AssetEventLogDescription;
import com.inet.helpdesk.plugins.inventory.server.internal.AssetManagerImpl;
import com.inet.helpdesk.plugins.inventory.server.internal.UserDeletionInventoryMessageProvider;
import com.inet.helpdesk.plugins.inventory.server.maintenance.backup.InventoryFieldSettingsBackupTask;
import com.inet.helpdesk.plugins.inventory.server.maintenance.cache.InventoryCacheAction;
import com.inet.helpdesk.plugins.inventory.server.maintenance.cache.InventoryCacheExtension;
import com.inet.helpdesk.plugins.inventory.server.maintenance.datacare.ArchivedDeviceDataCareTask;
import com.inet.helpdesk.plugins.inventory.server.maintenance.datacare.AssetDeactivatedLocationCleanupExt;
import com.inet.helpdesk.plugins.inventory.server.maintenance.datacare.AssetUnreferencedLocationCleanupExt;
import com.inet.helpdesk.plugins.inventory.server.plugin.setup.DeviceWarrantySeriesMigrationSetupStep;
import com.inet.helpdesk.plugins.inventory.server.plugin.setup.InstallIconsStep;
import com.inet.helpdesk.plugins.inventory.server.plugin.setup.InstallReportsStep;
import com.inet.helpdesk.plugins.inventory.server.plugin.setup.InventoryDatabaseStep;
import com.inet.helpdesk.plugins.inventory.server.plugin.setup.MigrateInheritableFieldsStep;
import com.inet.helpdesk.plugins.inventory.server.reporting.InventoryDataSourceConfiguration;
import com.inet.helpdesk.plugins.inventory.server.reporting.InventoryReportingFunctions;
import com.inet.helpdesk.plugins.inventory.server.reporting.datasource.AssetAdhocDataSource;
import com.inet.helpdesk.plugins.inventory.server.reporting.dataview.DataView_Assets;
import com.inet.helpdesk.plugins.inventory.server.reporting.dataview.DataView_AssetsWithTickets;
import com.inet.helpdesk.plugins.inventory.server.reporting.dataview.DataView_Licenses;
import com.inet.helpdesk.plugins.inventory.server.reporting.dataview.DataView_Vendors;
import com.inet.helpdesk.plugins.inventory.server.taskplanner.action.addaffectedasset.AddAffectedAssetActionFactory;
import com.inet.helpdesk.plugins.inventory.server.taskplanner.i18n.InventoryTaskPlannerMsg;
import com.inet.helpdesk.plugins.inventory.server.taskplanner.series.asset.AssetSeriesFactory;
import com.inet.helpdesk.plugins.inventory.server.taskplanner.series.devicewarranty.DeviceWarrantyEndApproachingSeriesFactory;
import com.inet.helpdesk.plugins.inventory.server.taskplanner.trigger.LowHighInventoryTriggerFactory;
import com.inet.helpdesk.plugins.inventory.server.ticket.AdditionalReaStepFieldDefinitionAssetId;
import com.inet.helpdesk.plugins.inventory.server.ticket.ChangeAffectedAssetsExtension;
import com.inet.helpdesk.plugins.inventory.server.ticket.InventoryPlaceholderProvider;
import com.inet.helpdesk.plugins.inventory.server.ticket.TicketFieldDefinitionAffectedAssets;
import com.inet.helpdesk.plugins.inventory.server.webapi.InventoryWebAPIExtension;
import com.inet.helpdesk.plugins.maintenance.server.datacare.api.DataCareTask;
import com.inet.helpdesk.plugins.maintenance.server.datacare.api.MaintenanceDeactivatedLocationCleanupExtension;
import com.inet.helpdesk.plugins.maintenance.server.datacare.api.MaintenanceLocationCleanupExtension;
import com.inet.helpdesk.plugins.taskplanner.server.placeholder.PlaceholderProvider;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.http.PluginServlet;
import com.inet.http.websocket.WebSocketEvent;
import com.inet.id.GUID;
import com.inet.lib.json.Json;
import com.inet.logging.LogManager;
import com.inet.logging.Logger;
import com.inet.maintenance.api.backup.BackupTask;
import com.inet.maintenance.api.cache.MaintenanceCacheAction;
import com.inet.maintenance.api.cache.MaintenanceCacheExtension;
import com.inet.permissions.Permission;
import com.inet.permissions.SystemPermissionChecker;
import com.inet.permissions.SystemPermissionManager;
import com.inet.plugin.DynamicExtensionManager;
import com.inet.plugin.Executable;
import com.inet.plugin.HelpProviderContainer;
import com.inet.plugin.PluginInfo;
import com.inet.plugin.ServerPlugin;
import com.inet.plugin.ServerPluginManager;
import com.inet.plugin.ServerPluginManagerListener;
import com.inet.plugin.help.HelpProvider;
import com.inet.plugin.help.HelpProviderImpl;
import com.inet.plugin.veto.VetoPower;
import com.inet.plugin.veto.VetoType;
import com.inet.plugin.webapi.api.WebAPIExtension;
import com.inet.remote.gui.IModule;
import com.inet.remote.gui.angular.ServiceMethod;
import com.inet.report.adhoc.server.api.dataview.TemplateDataViewDefaults;
import com.inet.report.config.datasource.DataSourceConfiguration;
import com.inet.report.config.datasource.DataSourceConfigurationManager;
import com.inet.report.database.DataFactory;
import com.inet.report.formula.UserDefinedFunction;
import com.inet.setupwizard.api.SetupStep;
import com.inet.shared.statistics.eventlog.EventLogDescription;
import com.inet.taskplanner.server.api.TaskDefinition;
import com.inet.taskplanner.server.api.action.ResultActionDefinition;
import com.inet.taskplanner.server.api.action.ResultActionFactory;
import com.inet.taskplanner.server.api.series.SeriesDefinition;
import com.inet.taskplanner.server.api.series.SeriesFactory;
import com.inet.taskplanner.server.api.template.TaskTemplateDefinition;
import com.inet.taskplanner.server.api.template.TaskTemplateDefinitionImpl;
import com.inet.taskplanner.server.api.trigger.TriggerDefinition;
import com.inet.taskplanner.server.api.trigger.TriggerFactory;
import com.inet.theme.server.ThemeResource;
import com.inet.usersandgroups.api.UserField;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserEventAdapter;
import com.inet.usersandgroups.api.user.UserEventListener;
import com.inet.usersandgroups.api.user.UserManager;
import com.inet.usersandgroupsmanager.api.UserDeletionMessageProvider;
import java.net.URL;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nullable;

@PluginInfo(id="inventory", dependencies="remotegui;helpdesk;fieldsettings;reporting", optionalDependencies="attachments;maintenance;maintenance.helpdesk;help;setupwizard;helpdesksetupwizard;theme;ticketlist;statistics;taskplanner;taskplanner.helpdesk;webapi.core;usersandgroupsmanager;adhoc", internal="", packages="com.inet.helpdesk.plugins.inventory.server.api", group="applications;tickets", flags="", version="25.10.217", icon="com/inet/helpdesk/plugins/inventory/server/images/inventory_48.png")
public class InventoryServerPlugin
implements ServerPlugin {
    public static final String PLUGIN_ID = "inventory";
    public static final Logger LOGGER = LogManager.getLogger((String)"Inventory");
    public static final ConfigKey CONFIGKEY_GROUPING = new ConfigKey("inventory_config_grouping", "[]", InventoryTreeGroupEntry[].class);
    private static final String PERMISSION_CATEGORY_INVENTORY = "inventory";
    public static final Permission INVENTORY_READ;
    public static final Permission INVENTORY_READ_WRITE;
    public static final Permission INVENTORY_ALL;
    public static final I18nMessages CLIENT_MSG;
    public static final I18nMessages CONFIG_MSG;
    public static final UserField<InventoryViewSettings> USERFIELD_INVENTORY_VIEWSETTINGS;
    private AssetManagerImpl deviceManager;
    private static UserEventAdapter REMOVE_USERREFERENCES_ON_DELETE;

    public void registerExtension(final ServerPluginManager spm) {
        this.deviceManager = (AssetManagerImpl)AssetManager.getInstance();
        spm.register(AssetManager.class, (Object)this.deviceManager);
        spm.register(VetoPower.class, (Object)this.deviceManager.getVetoPower());
        spm.register(UserField.class, USERFIELD_INVENTORY_VIEWSETTINGS);
        spm.register(UserEventListener.class, (Object)REMOVE_USERREFERENCES_ON_DELETE);
        DynamicExtensionManager.getInstance().register(AssetField.class, (Object)AssetFields.FIELD_IMAGE);
        for (AssetField<?> field : AssetFields.getPredefinedAssetFields()) {
            DynamicExtensionManager.getInstance().register(AssetField.class, field);
            if (!(field instanceof AssetFieldDefinition)) continue;
            DynamicExtensionManager.getInstance().register(AssetFieldDefinition.class, (Object)((AssetFieldDefinition)((Object)field)));
        }
        DynamicExtensionManager.getInstance().register(TicketField.class, (Object)AssetFields.TICKET_FIELD_AFFECTED_ASSETS);
        spm.register(TicketFieldDefinition.class, (Object)new TicketFieldDefinitionAffectedAssets(99999));
        spm.register(ExtensionArguments.ExtArg.class, ChangeAffectedAssetsExtension.EXTARG_AFFECTED_ASSETS);
        spm.register(TicketActionExtensionFactory.class, (Object)new ChangeAffectedAssetsExtension());
        spm.register(ServerPluginManagerListener.class, (Object)new ServerPluginManagerListener(){

            public void vetoFinished(@Nullable VetoType type) {
                ActionManager actionManager;
                if (type == TicketManagerVetoPower.TYPE && (actionManager = ActionManager.getInstance()).get(-39) == null) {
                    try {
                        actionManager.add(new ActionVO(-39, "Betroffene Assets \u00e4ndern", -100, true, 0, 0, 0.0, false, 0, true), true);
                    }
                    catch (SQLException e) {
                        LOGGER.error((Throwable)e);
                    }
                }
            }
        });
        spm.register(ReaStepField.class, (Object)AssetFields.FIELD_INVENTORY_ASSETID);
        spm.register(AdditionalFieldSetting.class, (Object)new AssetAdditionalFieldSetting());
        spm.register(AdditionalReaStepFieldDefinition.class, (Object)new AdditionalReaStepFieldDefinitionAssetId());
        spm.register(ConfigStructureProvider.class, (Object)new InventoryGenericFieldsStructureProvider());
        spm.register(ConfigStructureProvider.class, (Object)new AssetFieldsConfigStructureProvider());
        spm.register(ConfigPage.class, (Object)new InventoryConfigPage());
        spm.register(UserDefinedFunction.class, (Object)new InventoryReportingFunctions());
        spm.register(DataFactory.class, (Object)new InventoryDataSourceConfiguration());
        FileCombiner.CombinedFile iconLib = new FileCombiner.CombinedFile("application/zip", new URL[0]);
        iconLib.add(this.getClass(), "/com/inet/helpdesk/plugins/inventory/server/images/assettypeicons.zip");
        spm.register(CombinedFileDescription.class, (Object)new CombinedFileDescription("remotegui", 201, "assettypeicons.zip", iconLib));
        spm.runIfPluginLoaded("maintenance", () -> new Executable(){

            public void execute() {
                InventoryCacheAction cacheAction = new InventoryCacheAction();
                spm.register(MaintenanceCacheAction.class, (Object)cacheAction);
                spm.register(MaintenanceCacheExtension.class, (Object)new InventoryCacheExtension(cacheAction));
                spm.register(BackupTask.class, (Object)new InventoryFieldSettingsBackupTask());
            }
        });
        spm.runIfPluginLoaded("helpdesksetupwizard", () -> new Executable(){

            public void execute() {
                spm.register(SetupStep.class, (Object)new InventoryDatabaseStep());
                spm.register(SetupStep.class, (Object)new InstallIconsStep());
                spm.register(SetupStep.class, (Object)new InstallReportsStep());
                spm.register(SetupStep.class, (Object)new MigrateInheritableFieldsStep());
            }
        });
        spm.register(ConnectionCreationListener.class, () -> AssetFieldSettingsManager.getInstance().init());
        spm.runIfPluginLoaded("remotegui", () -> new Executable(){

            public void execute() {
                spm.register(IModule.class, (Object)new InventoryModule());
                InventoryAngularApplicationServlet moduleHandler = new InventoryAngularApplicationServlet();
                spm.register(PluginServlet.class, (Object)moduleHandler);
                spm.register(ServiceMethod.class, (Object)new InitialData());
                spm.register(ServiceMethod.class, (Object)new LoadSuggestions());
                spm.register(ServiceMethod.class, (Object)new AssetIcon());
                spm.register(ServiceMethod.class, (Object)new LoadTreeGroupingSettings());
                spm.register(ServiceMethod.class, (Object)new SaveTreeGroupingSettings());
                spm.register(ServiceMethod.class, (Object)new PrepareNewAsset());
                spm.register(ServiceMethod.class, (Object)new GetSelectOptions());
                spm.register(ServiceMethod.class, (Object)new DeviceFieldValueIcon());
                spm.register(ServiceMethod.class, (Object)new GetUsersHandler());
                spm.register(ServiceMethod.class, (Object)new SaveAsset());
                spm.register(ServiceMethod.class, (Object)new DeleteAssets());
                spm.register(ServiceMethod.class, (Object)new UndeleteAssets());
                spm.register(ServiceMethod.class, (Object)new MoveAssets());
                spm.register(ServiceMethod.class, (Object)new AdditionalDetails());
                spm.register(ServiceMethod.class, (Object)new DeleteAttachment());
                spm.register(ServiceMethod.class, (Object)new GetAssets());
                spm.register(ServiceMethod.class, (Object)new GetAssetDetails());
                spm.register(ServiceMethod.class, (Object)new GetSLAResource());
                spm.register(ServiceMethod.class, (Object)new GetAssetFields());
                spm.register(WebSocketEvent.class, (Object)new InitInventoryTree());
                spm.register(WebSocketEvent.class, (Object)new UpdateInventoryTree());
                spm.register(WebSocketEvent.class, (Object)new TreeNodesChanged());
                spm.register(WebSocketEvent.class, (Object)new ViewSettingsChangedEvent());
                spm.register(WebSocketEvent.class, (Object)new LoadMoreTreeChildren());
                spm.register(WebSocketEvent.class, (Object)new InitInventoryStructure());
                spm.register(WebSocketEvent.class, (Object)new UpdateInventoryStructure());
                spm.register(WebSocketEvent.class, (Object)new LoadMoreStructureChildren());
                spm.register(WebSocketEvent.class, (Object)new InitInventoryDetails());
                FileCombiner.CombinedFile combinedFile = new FileCombiner.CombinedFile("application/x-javascript; charset=utf-8", new URL[0]);
                combinedFile.add(((Object)((Object)this)).getClass(), "/com/inet/helpdesk/plugins/inventory/client/js/genericfieldrenderer.js");
                spm.register(CombinedFileDescription.class, (Object)new CombinedFileDescription("remotegui", "configAppExtras.js", combinedFile));
                combinedFile = new FileCombiner.CombinedFile("text/html; charset=utf-8", new URL[0]);
                combinedFile.add(((Object)((Object)this)).getClass(), "/com/inet/helpdesk/plugins/inventory/client/js/print/printinventory.html");
                spm.register(CombinedFileDescription.class, (Object)new CombinedFileDescription("remotegui", 201, "printinventory.html", combinedFile));
                combinedFile = new FileCombiner.CombinedFile("text/html; charset=utf-8", new URL[0]);
                combinedFile.add(((Object)((Object)this)).getClass(), "/com/inet/helpdesk/plugins/inventory/client/html/inventory.editproperties.html");
                spm.register(CombinedFileDescription.class, (Object)new CombinedFileDescription("remotegui", 201, "inventory.editproperties.html", combinedFile));
                FileCombiner.CombinedFile combinedFileCSS = new FileCombiner.CombinedFile("text/css", new URL[0]);
                combinedFileCSS.add(((Object)((Object)this)).getClass(), "/com/inet/helpdesk/plugins/inventory/client/css/inventory.css");
                combinedFileCSS.add(((Object)((Object)this)).getClass(), "/com/inet/helpdesk/plugins/inventory/client/css/inventory-sprites.css");
                spm.register(CombinedFileDescription.class, (Object)new CombinedFileDescription("remotegui", 108, "defaulttheme.css", combinedFileCSS));
                combinedFile = new FileCombiner.CombinedFile("application/x-javascript; charset=utf-8", new URL[0]);
                combinedFile.add(((Object)((Object)this)).getClass(), "/com/inet/helpdesk/plugins/inventory/client/js/inventory.fieldgroup.filter.js");
                combinedFile.add(((Object)((Object)this)).getClass(), "/com/inet/helpdesk/plugins/inventory/client/js/inventorymodel.js");
                combinedFile.add(((Object)((Object)this)).getClass(), "/com/inet/helpdesk/plugins/inventory/client/js/inventoryfactory.js");
                combinedFile.add(((Object)((Object)this)).getClass(), "/com/inet/helpdesk/plugins/inventory/client/js/inventorycontroller.js");
                combinedFile.add(((Object)((Object)this)).getClass(), "/com/inet/helpdesk/plugins/inventory/client/js/inventory.treegrouping.directive.js");
                combinedFile.add(((Object)((Object)this)).getClass(), "/com/inet/helpdesk/plugins/inventory/client/js/treegroupingsettings.js");
                combinedFile.add(((Object)((Object)this)).getClass(), "/com/inet/helpdesk/plugins/inventory/client/js/resizeableColumn.js");
                combinedFile.add(((Object)((Object)this)).getClass(), "/com/inet/helpdesk/plugins/inventory/client/js/inventory.structuretoolbar.directive.js");
                combinedFile.add(((Object)((Object)this)).getClass(), "/com/inet/helpdesk/plugins/inventory/client/js/inventory.assetmenu.directive.js");
                combinedFile.add(((Object)((Object)this)).getClass(), "/com/inet/helpdesk/plugins/inventory/client/js/inventory.assetimage.directive.js");
                combinedFile.add(((Object)((Object)this)).getClass(), "/com/inet/helpdesk/plugins/inventory/client/js/inventory.assetimagehover.directive.js");
                combinedFile.add(((Object)((Object)this)).getClass(), "/com/inet/helpdesk/plugins/inventory/client/js/inventory.assetdetailsform.directive.js");
                combinedFile.add(((Object)((Object)this)).getClass(), "/com/inet/helpdesk/plugins/inventory/client/js/fieldrenderer/inventory.devicefieldrenderer.directive.js");
                combinedFile.add(((Object)((Object)this)).getClass(), "/com/inet/helpdesk/plugins/inventory/client/js/fieldrenderer/inventory.devicefieldrenderercurrency.directive.js");
                combinedFile.add(((Object)((Object)this)).getClass(), "/com/inet/helpdesk/plugins/inventory/client/js/fieldrenderer/inventory.devicefieldrendererdatetime.directive.js");
                combinedFile.add(((Object)((Object)this)).getClass(), "/com/inet/helpdesk/plugins/inventory/client/js/fieldrenderer/inventory.devicefieldrenderertime.directive.js");
                combinedFile.add(((Object)((Object)this)).getClass(), "/com/inet/helpdesk/plugins/inventory/client/js/fieldrenderer/inventory.devicefieldrendererselect.directive.js");
                combinedFile.add(((Object)((Object)this)).getClass(), "/com/inet/helpdesk/plugins/inventory/client/js/fieldrenderer/inventory.devicefieldrendereruser.directive.js");
                combinedFile.add(((Object)((Object)this)).getClass(), "/com/inet/helpdesk/plugins/inventory/client/js/fieldrenderer/inventory.devicefieldrendererlink.directive.js");
                combinedFile.add(((Object)((Object)this)).getClass(), "/com/inet/helpdesk/plugins/inventory/client/js/fieldrenderer/inventory.deviceimagerenderer.directive.js");
                combinedFile.add(((Object)((Object)this)).getClass(), "/com/inet/helpdesk/plugins/inventory/client/js/fieldrenderer/inventory.inventoryattachments.directive.js");
                combinedFile.add(((Object)((Object)this)).getClass(), "/com/inet/helpdesk/plugins/inventory/client/js/fieldrenderer/inventory.inventoryattachmentcontent.directive.js");
                combinedFile.add(((Object)((Object)this)).getClass(), "/com/inet/helpdesk/plugins/inventory/client/js/fieldrenderer/inventory.lazydetailfields.directive.js");
                combinedFile.add(((Object)((Object)this)).getClass(), "/com/inet/helpdesk/plugins/inventory/client/js/inventory.levelslider.directive.js");
                combinedFile.add(((Object)((Object)this)).getClass(), "/com/inet/helpdesk/plugins/inventory/client/js/inventory.structureview.directive.js");
                combinedFile.add(((Object)((Object)this)).getClass(), "/com/inet/helpdesk/plugins/inventory/client/js/inventory.listview.directive.js");
                combinedFile.add(((Object)((Object)this)).getClass(), "/com/inet/helpdesk/plugins/inventory/client/js/inventory.listviewrow.directive.js");
                combinedFile.add(((Object)((Object)this)).getClass(), "/com/inet/helpdesk/plugins/inventory/client/js/inventory.tileview.directive.js");
                combinedFile.add(((Object)((Object)this)).getClass(), "/com/inet/helpdesk/plugins/inventory/client/js/inventory.tilelane.directive.js");
                combinedFile.add(((Object)((Object)this)).getClass(), "/com/inet/helpdesk/plugins/inventory/client/js/inventory.tile.directive.js");
                combinedFile.add(((Object)((Object)this)).getClass(), "/com/inet/helpdesk/plugins/inventory/client/js/inventory.3dview.directive.js");
                combinedFile.add(((Object)((Object)this)).getClass(), "/com/inet/helpdesk/plugins/inventory/client/js/inventory.editproperties.controller.js");
                combinedFile.add(((Object)((Object)this)).getClass(), "/com/inet/helpdesk/plugins/inventory/client/js/inventory.editproperties.directive.js");
                combinedFile.add(((Object)((Object)this)).getClass(), "/com/inet/helpdesk/plugins/inventory/client/js/renderer3d/inventory.3drenderer.directive.js");
                combinedFile.add(((Object)((Object)this)).getClass(), "/com/inet/helpdesk/plugins/inventory/client/js/renderer3d/inventory.asset3d.directive.js");
                combinedFile.add(((Object)((Object)this)).getClass(), "/com/inet/helpdesk/plugins/inventory/client/js/renderer3d/inventory.default3dbox.directive.js");
                combinedFile.add(((Object)((Object)this)).getClass(), "/com/inet/helpdesk/plugins/inventory/client/js/renderer3d/inventory.invoicepaper.directive.js");
                combinedFile.add(((Object)((Object)this)).getClass(), "/com/inet/helpdesk/plugins/inventory/client/js/renderer3d/inventory.licensepaper.directive.js");
                combinedFile.add(((Object)((Object)this)).getClass(), "/com/inet/helpdesk/plugins/inventory/client/js/renderer3d/inventory.locationbox.directive.js");
                combinedFile.add(((Object)((Object)this)).getClass(), "/com/inet/helpdesk/plugins/inventory/client/js/renderer3d/inventory.roombox.directive.js");
                combinedFile.add(((Object)((Object)this)).getClass(), "/com/inet/helpdesk/plugins/inventory/client/js/renderer3d/inventory.slapaper.directive.js");
                combinedFile.add(((Object)((Object)this)).getClass(), "/com/inet/helpdesk/plugins/inventory/client/js/renderer3d/inventory.typehandheld.directive.js");
                combinedFile.add(((Object)((Object)this)).getClass(), "/com/inet/helpdesk/plugins/inventory/client/js/renderer3d/inventory.usertable.directive.js");
                combinedFile.add(((Object)((Object)this)).getClass(), "/com/inet/helpdesk/plugins/inventory/client/js/print/printinventory.js");
                combinedFile.addMessages(CLIENT_MSG);
                spm.register(CombinedFileDescription.class, (Object)new CombinedFileDescription("remotegui", 201, "inventory.js", combinedFile));
                combinedFile = new FileCombiner.CombinedFile("text/html; charset=utf-8", new URL[0]);
                combinedFile.add(((Object)((Object)this)).getClass(), "/com/inet/helpdesk/plugins/inventory/client/html/treegroupingsettings.html");
                spm.register(CombinedFileDescription.class, (Object)new CombinedFileDescription("remotegui", 201, "treegroupingsettings.html", combinedFile));
            }
        });
        spm.runIfPluginLoaded("theme", () -> new Executable(){

            public void execute() {
                spm.register(ThemeResource.class, (Object)new ThemeResource("remotegui", ((Object)((Object)this)).getClass().getResource("/com/inet/helpdesk/plugins/inventory/client/css/inventory.less")));
                spm.register(ThemeResource.class, (Object)new ThemeResource("remotegui", ((Object)((Object)this)).getClass().getResource("/com/inet/helpdesk/plugins/inventory/client/css/inventory-sprites.less")));
            }
        });
        spm.runIfPluginLoaded("ticketlist", () -> new Executable(){

            public void execute() {
                spm.register(TicketPageExtension.class, (Object)new InventoryTicketPageExtension());
                RegisterAffectedAssets registerAffectedAssets = new RegisterAffectedAssets();
                spm.register(ServiceMethod.class, (Object)registerAffectedAssets);
                spm.register(AssetListener.class, (Object)registerAffectedAssets);
                spm.register(TicketEventListener.class, (Object)registerAffectedAssets);
                spm.register(ServiceMethod.class, (Object)new UpdateAffectedAssets());
                FileCombiner.CombinedFile integrationJavaScript = new FileCombiner.CombinedFile("application/x-javascript; charset=utf-8", new URL[0]);
                integrationJavaScript.add(((Object)((Object)this)).getClass(), "/com/inet/helpdesk/plugins/inventory/client/js/inventory.fieldgroup.filter.js");
                integrationJavaScript.add(((Object)((Object)this)).getClass(), "/com/inet/helpdesk/plugins/inventory/client/js/inventorymodel.js");
                integrationJavaScript.add(((Object)((Object)this)).getClass(), "/com/inet/helpdesk/plugins/inventory/client/js/inventoryfactory.js");
                integrationJavaScript.add(((Object)((Object)this)).getClass(), "/com/inet/helpdesk/plugins/inventory/client/js/inventory.treegrouping.directive.js");
                integrationJavaScript.add(((Object)((Object)this)).getClass(), "/com/inet/helpdesk/plugins/inventory/client/js/inventory.assetimage.directive.js");
                integrationJavaScript.add(((Object)((Object)this)).getClass(), "/com/inet/helpdesk/plugins/inventory/client/js/inventory.assetimagehover.directive.js");
                integrationJavaScript.add(((Object)((Object)this)).getClass(), "/com/inet/helpdesk/plugins/inventory/client/js/inventory.assetdetailsform.directive.js");
                integrationJavaScript.add(((Object)((Object)this)).getClass(), "/com/inet/helpdesk/plugins/inventory/client/js/fieldrenderer/inventory.devicefieldrenderer.directive.js");
                integrationJavaScript.add(((Object)((Object)this)).getClass(), "/com/inet/helpdesk/plugins/inventory/client/js/fieldrenderer/inventory.devicefieldrenderercurrency.directive.js");
                integrationJavaScript.add(((Object)((Object)this)).getClass(), "/com/inet/helpdesk/plugins/inventory/client/js/fieldrenderer/inventory.devicefieldrendererdatetime.directive.js");
                integrationJavaScript.add(((Object)((Object)this)).getClass(), "/com/inet/helpdesk/plugins/inventory/client/js/fieldrenderer/inventory.devicefieldrenderertime.directive.js");
                integrationJavaScript.add(((Object)((Object)this)).getClass(), "/com/inet/helpdesk/plugins/inventory/client/js/fieldrenderer/inventory.devicefieldrendererselect.directive.js");
                integrationJavaScript.add(((Object)((Object)this)).getClass(), "/com/inet/helpdesk/plugins/inventory/client/js/fieldrenderer/inventory.devicefieldrendereruser.directive.js");
                integrationJavaScript.add(((Object)((Object)this)).getClass(), "/com/inet/helpdesk/plugins/inventory/client/js/fieldrenderer/inventory.devicefieldrendererlink.directive.js");
                integrationJavaScript.add(((Object)((Object)this)).getClass(), "/com/inet/helpdesk/plugins/inventory/client/js/fieldrenderer/inventory.deviceimagerenderer.directive.js");
                integrationJavaScript.add(((Object)((Object)this)).getClass(), "/com/inet/helpdesk/plugins/inventory/client/js/fieldrenderer/inventory.inventoryattachments.directive.js");
                integrationJavaScript.add(((Object)((Object)this)).getClass(), "/com/inet/helpdesk/plugins/inventory/client/js/fieldrenderer/inventory.inventoryattachmentcontent.directive.js");
                integrationJavaScript.add(((Object)((Object)this)).getClass(), "/com/inet/helpdesk/plugins/inventory/client/js/fieldrenderer/inventory.lazydetailfields.directive.js");
                integrationJavaScript.add(((Object)((Object)this)).getClass(), "/com/inet/helpdesk/plugins/inventory/client/ticketpageextension/inventoryticketpagefactory.js");
                integrationJavaScript.add(((Object)((Object)this)).getClass(), "/com/inet/helpdesk/plugins/inventory/client/ticketpageextension/inventoryextension.treenode.directive.js");
                integrationJavaScript.add(((Object)((Object)this)).getClass(), "/com/inet/helpdesk/plugins/inventory/client/ticketpageextension/inventoryextension.assetpreview.directive.js");
                integrationJavaScript.add(((Object)((Object)this)).getClass(), "/com/inet/helpdesk/plugins/inventory/client/ticketpageextension/inventoryextension.js");
                integrationJavaScript.add(((Object)((Object)this)).getClass(), "/com/inet/helpdesk/plugins/inventory/client/ticketpageextension/inventoryextension.detailscontroller.js");
                integrationJavaScript.addMessages(CLIENT_MSG);
                spm.register(CombinedFileDescription.class, (Object)new CombinedFileDescription("remotegui", 222, "helpdesk.ticket.extensions.js", integrationJavaScript));
                FileCombiner.CombinedFile combinedFile = new FileCombiner.CombinedFile("text/html; charset=utf-8", new URL[0]);
                combinedFile.add(((Object)((Object)this)).getClass(), "/com/inet/helpdesk/plugins/inventory/client/ticketpageextension/inventoryextension.assetdetails.html");
                spm.register(CombinedFileDescription.class, (Object)new CombinedFileDescription("remotegui", 201, "inventoryextension.assetdetails.html", combinedFile));
            }
        });
        spm.runIfPluginLoaded("statistics", () -> new Executable(){

            public void execute() {
                spm.register(EventLogDescription.class, (Object)new AssetEventLogDescription());
            }
        });
        spm.runIfPluginLoaded("taskplanner", () -> new Executable(){

            public void execute() {
                spm.register(TriggerFactory.class, (Object)new LowHighInventoryTriggerFactory());
                spm.register(SeriesFactory.class, (Object)new DeviceWarrantyEndApproachingSeriesFactory());
                spm.register(SeriesFactory.class, (Object)new AssetSeriesFactory());
                spm.register(SetupStep.class, (Object)new DeviceWarrantySeriesMigrationSetupStep());
                spm.runIfPluginLoaded("taskplanner.helpdesk", () -> new Executable(){

                    public void execute() {
                        spm.register(ResultActionFactory.class, (Object)new AddAffectedAssetActionFactory());
                    }
                });
                spm.runIfPluginLoaded("taskplanner.helpdesk", () -> new Executable(){

                    public void execute() {
                        DynamicExtensionManager.getInstance().register(PlaceholderProvider.class, (Object)new InventoryPlaceholderProvider());
                    }
                });
                InventoryServerPlugin.this.registerAssetCheckTemplate(spm);
            }
        });
        spm.runIfPluginLoaded("maintenance.helpdesk", () -> new Executable(){

            public void execute() {
                spm.register(DataCareTask.class, (Object)new ArchivedDeviceDataCareTask());
                spm.register(MaintenanceDeactivatedLocationCleanupExtension.class, (Object)new AssetDeactivatedLocationCleanupExt());
                spm.register(MaintenanceLocationCleanupExtension.class, (Object)new AssetUnreferencedLocationCleanupExt());
            }
        });
        spm.runIfPluginLoaded("webapi.core", () -> new Executable(){

            public void execute() {
                spm.register(WebAPIExtension.class, (Object)new InventoryWebAPIExtension());
            }
        });
        spm.runIfPluginLoaded("usersandgroupsmanager", () -> new Executable(){

            public void execute() {
                DynamicExtensionManager dem = DynamicExtensionManager.getInstance();
                dem.register(UserDeletionMessageProvider.class, (Object)new UserDeletionInventoryMessageProvider());
            }
        });
        spm.runIfPluginLoaded("adhoc", () -> new Executable(){

            public void execute() {
                spm.register(TemplateDataViewDefaults.class, (Object)new DataView_Assets());
                spm.register(TemplateDataViewDefaults.class, (Object)new DataView_Licenses());
                spm.register(TemplateDataViewDefaults.class, (Object)new DataView_Vendors());
                spm.register(TemplateDataViewDefaults.class, (Object)new DataView_AssetsWithTickets());
            }
        });
    }

    private void registerAssetCheckTemplate(ServerPluginManager spm) {
        TaskDefinition taskDesc = new TaskDefinition("_inventoryassetcheck");
        TriggerDefinition newTicketTrigger = new TriggerDefinition("taskplanner.helpdesk");
        newTicketTrigger.setProperty("FilterType", "subject");
        newTicketTrigger.setProperty("fflg.subject", "Asset-Check");
        taskDesc.addTrigger(newTicketTrigger);
        HashMap<String, String> seriesProps = new HashMap<String, String>();
        seriesProps.put("query", "Name:{ticket.custom1}");
        SeriesDefinition assetSeries = new SeriesDefinition("series.helpdesk.assets", seriesProps);
        taskDesc.setSeries(assetSeries);
        HashMap<String, String> actionProps = new HashMap<String, String>();
        actionProps.put("assetIdToAdd", "{asset.id}");
        actionProps.put("Ticket ID", "{Ticket ID}");
        ResultActionDefinition actionDefinition = new ResultActionDefinition("result.helpdesk.inventory.addaffectedasset", actionProps);
        taskDesc.addResultAction(actionDefinition);
        ArrayList keysToLocalize = new ArrayList();
        TaskTemplateDefinitionImpl taskTemplateDesc = new TaskTemplateDefinitionImpl("KEY_ASSET_CHECK_TEMPLATE", InventoryTaskPlannerMsg.MSG, "Template.AssetCheck", "Template.AssetCheck.desc", taskDesc, keysToLocalize){

            public boolean isAvailable() {
                UserAccount currentUserAccount = UserManager.getInstance().getCurrentUserAccount();
                return currentUserAccount != null && HDUsersAndGroups.isSupporter((UserAccount)currentUserAccount) && SystemPermissionChecker.checkAccess((Permission)INVENTORY_READ);
            }
        };
        spm.register(TaskTemplateDefinition.class, (Object)taskTemplateDesc);
    }

    public void init(final ServerPluginManager spm) {
        if (ServerPluginManager.getInstance().isPluginLoaded("fieldsettings")) {
            DataSourceConfiguration inventoryConfig = DataSourceConfigurationManager.getDataSourceConfiguration((String)"HelpDeskAssets", (int)4);
            if (inventoryConfig == null) {
                inventoryConfig = DataSourceConfigurationManager.createDataSourceConfiguration((String)"HelpDeskAssets", (int)4);
            }
            inventoryConfig.setDatabaseClassname(InventoryDataSourceConfiguration.class.getName());
            inventoryConfig.save();
            DataSourceConfiguration adhocDS = DataSourceConfigurationManager.getDataSourceConfiguration((String)"Assets - Adhoc", (int)4);
            if (adhocDS == null) {
                adhocDS = DataSourceConfigurationManager.createDataSourceConfiguration((String)"Assets - Adhoc", (int)4);
            }
            adhocDS.setDatabaseClassname(AssetAdhocDataSource.class.getName());
            adhocDS.save();
        }
        spm.runIfPluginLoaded("webapi.core", () -> new Executable(){

            public void execute() {
                InventoryWebAPIExtension.init(spm);
            }
        });
    }

    public void reset() {
    }

    public void restart() {
    }

    public void registerHelp(HelpProviderContainer container) {
        container.add((HelpProvider)new HelpProviderImpl("configuration", 9415, true, new Permission[]{Permission.CONFIGURATION, INVENTORY_READ}){}, new String[0]);
        container.add((HelpProvider)new HelpProviderImpl("ticketlist", 9925, new Permission[]{INVENTORY_READ}){}, new String[0]);
        container.add((HelpProvider)new HelpProviderImpl("inventory", 1324, false, new Permission[]{INVENTORY_READ}){}, new String[0]);
        container.add((HelpProvider)new HelpProviderImpl("maintenance", 9453, false, new Permission[]{Permission.CONFIGURATION}){}, new String[0]);
        container.add((HelpProvider)new HelpProviderImpl("webapi", 9454, false, new Permission[]{INVENTORY_READ, Permission.valueOfExistingOrCreate((String)"webapi.core")}){}, new String[]{"webapi.core"});
        container.add((HelpProvider)new HelpProviderImpl("taskplanner", 9163, true, new Permission[]{Permission.valueOfExistingOrCreate((String)"taskplanner")}){}, new String[]{"taskplanner"});
    }

    static {
        ArrayList<InventoryTreeGroupEntry> defaultGrouping = new ArrayList<InventoryTreeGroupEntry>();
        InventoryTreeGroupEntry itgUser = new InventoryTreeGroupEntry("Inhaber");
        itgUser.setGroupingKeys(List.of("owner"));
        defaultGrouping.add(itgUser);
        InventoryTreeGroupEntry itgDevice = new InventoryTreeGroupEntry("Asset-Typ");
        itgDevice.setGroupingKeys(List.of("type"));
        defaultGrouping.add(itgDevice);
        InventoryTreeGroupEntry itgNumber = new InventoryTreeGroupEntry("Assetnummer");
        itgNumber.setGroupingKeys(List.of("assetnumber"));
        defaultGrouping.add(itgNumber);
        InventoryTreeGroupEntry itgLocation = new InventoryTreeGroupEntry("Standort");
        itgLocation.setGroupingKeys(List.of("location", "room", "owner"));
        defaultGrouping.add(itgLocation);
        InventoryTreeGroupEntry itgField1 = new InventoryTreeGroupEntry("Benutzerdefiniertes Feld 1");
        itgField1.setGroupingKeys(List.of("custom1"));
        defaultGrouping.add(itgField1);
        CONFIGKEY_GROUPING.setDefault(new Json().toJson(defaultGrouping));
        Permission.createCategory((String)"inventory", (int)4000, InventoryServerPlugin.class);
        INVENTORY_READ = SystemPermissionManager.add((String)"inventoryRead", (String)"inventory", null, (int)4100, (boolean)false, InventoryServerPlugin.class);
        INVENTORY_READ_WRITE = SystemPermissionManager.add((String)"inventoryReadWrite", (String)"inventory", (String)INVENTORY_READ.getKey(), (int)4150, (boolean)false, InventoryServerPlugin.class);
        INVENTORY_ALL = SystemPermissionManager.add((String)"inventoryAll", (String)"inventory", (String)INVENTORY_READ.getKey(), (int)4160, (boolean)false, InventoryServerPlugin.class);
        CLIENT_MSG = new I18nMessages("com.inet.helpdesk.plugins.inventory.client.i18n.LanguageResources", InventoryServerPlugin.class);
        CONFIG_MSG = new I18nMessages("com.inet.helpdesk.plugins.inventory.server.config.i18n.ConfigStructure", InventoryServerPlugin.class);
        USERFIELD_INVENTORY_VIEWSETTINGS = new UserField<InventoryViewSettings>("inventoryviewsettings", FieldTypeFactory.auto().withoutSearchTag()){

            public boolean isValueChangeLoggable() {
                return false;
            }

            public InventoryViewSettings copyValue(InventoryViewSettings value) {
                if (value != null) {
                    return value.createCopy();
                }
                return null;
            }
        };
        REMOVE_USERREFERENCES_ON_DELETE = new UserEventAdapter(){

            public void userAccountBeforeDeleted(UserAccount userAccount) {
                AssetManager manager = AssetManager.getInstance();
                if (((AssetManagerImpl)manager).isInitialized()) {
                    HashSet<GUID> matchedAssetIDs = new HashSet<GUID>();
                    try (Connection c = ((ConnectionFactory)ServerPluginManager.getInstance().getSingleInstance(ConnectionFactory.class)).getConnection();
                         PreparedStatement stm = c.prepareStatement("SELECT GerUUID FROM tblGeraeteBestand WHERE UserID = ?");){
                        stm.setInt(1, HDUsersAndGroups.getUserID((UserAccount)userAccount));
                        try (ResultSet rs = stm.executeQuery();){
                            while (rs.next()) {
                                matchedAssetIDs.add(GUID.valueOf((String)rs.getString(1)));
                            }
                        }
                    }
                    catch (SQLException e) {
                        throw new IllegalStateException(e);
                    }
                    MutableAssetData dataToChange = MutableAssetData.ofSingle(AssetFields.FIELD_OWNER, null);
                    for (GUID assetID : matchedAssetIDs) {
                        manager.updateAsset(assetID, dataToChange);
                    }
                }
            }
        };
    }
}

