/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.inventory.server.maintenance.datacare;

import com.inet.error.PersistenceException;
import com.inet.helpdesk.core.data.ConnectionFactory;
import com.inet.helpdesk.core.ticketmanager.fields.location.LocationVO;
import com.inet.helpdesk.plugins.inventory.server.api.AssetManager;
import com.inet.helpdesk.plugins.inventory.server.api.model.AssetFields;
import com.inet.helpdesk.plugins.inventory.server.api.model.MutableAssetData;
import com.inet.helpdesk.plugins.maintenance.server.datacare.api.MaintenanceDeactivatedLocationCleanupExtension;
import com.inet.id.GUID;
import com.inet.plugin.ServerPluginManager;
import com.inet.search.command.OrSearchExpression;
import com.inet.search.command.SearchCommand;
import com.inet.search.command.SearchCondition;
import com.inet.search.command.SearchExpression;
import com.inet.usersandgroups.api.user.UserAccountScope;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.annotation.SuppressFBWarnings;

public class AssetDeactivatedLocationCleanupExt
implements MaintenanceDeactivatedLocationCleanupExtension {
    public int findWidgetsStillUsingLocation(List<LocationVO> deactivatedLocations) {
        return this.findAssetsUsingOneOfLocations(deactivatedLocations).size();
    }

    @SuppressFBWarnings(value={"SQL_INJECTION_JDBC"}, justification="no string can be injected into sql by parameters")
    public void cleanUpWidgetsStillUsingOneOfLocations(List<LocationVO> deactivatedLocations) {
        AssetManager manager = AssetManager.getInstance();
        @Nullable Integer defaultValue = (Integer)AssetFields.FIELD_LOCATION.getDefaultValue();
        Set<GUID> assetsUsingOneOfLocations = this.findAssetsUsingOneOfLocations(deactivatedLocations);
        try (UserAccountScope s = UserAccountScope.createPrivileged();){
            for (GUID assetID : assetsUsingOneOfLocations) {
                manager.updateAsset(assetID, MutableAssetData.ofSingle(AssetFields.FIELD_LOCATION, defaultValue));
            }
        }
        String whereIn = deactivatedLocations.stream().map(l -> String.valueOf(l.getId())).collect(Collectors.joining(","));
        try (Connection connection = ((ConnectionFactory)ServerPluginManager.getInstance().getSingleInstance(ConnectionFactory.class)).getConnection();
             PreparedStatement statement = connection.prepareStatement("UPDATE tblGeraeteBestand SET GebID = ? WHERE GebID IN (" + whereIn + ")");){
            if (defaultValue != null) {
                statement.setInt(1, defaultValue);
            } else {
                statement.setNull(1, 4);
            }
            int executeUpdate = statement.executeUpdate();
            if (executeUpdate > 0) {
                manager.maintenance().clearCache();
            }
        }
        catch (SQLException e) {
            throw new PersistenceException((Throwable)e);
        }
    }

    private Set<GUID> findAssetsUsingOneOfLocations(List<LocationVO> deactivatedLocations) {
        OrSearchExpression or = new OrSearchExpression();
        for (LocationVO locationVO : deactivatedLocations) {
            or.add((Object)new SearchCondition(AssetFields.FIELD_LOCATION.getKey(), SearchCondition.SearchTermOperator.Equals, (Object)locationVO.getId()));
        }
        SearchCommand searchCommand = new SearchCommand(new SearchExpression[]{or});
        Set users = AssetManager.getInstance().getSearchEngine().simpleSearch(searchCommand);
        return users;
    }
}

