/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.inventory.client.handler;

import com.inet.helpdesk.plugins.inventory.client.data.AssetDetails;
import com.inet.helpdesk.plugins.inventory.client.data.GetAssetDetailsRequest;
import com.inet.helpdesk.plugins.inventory.client.data.GetAssetDetailsResponse;
import com.inet.helpdesk.plugins.inventory.client.event.InitInventoryDetails;
import com.inet.helpdesk.plugins.inventory.client.handler.AbstractInventoryHandler;
import com.inet.helpdesk.plugins.inventory.server.api.AssetManager;
import com.inet.helpdesk.plugins.inventory.server.api.model.AssetView;
import com.inet.helpdesk.plugins.inventory.server.plugin.InventoryServerPlugin;
import com.inet.id.GUID;
import com.inet.permissions.AccessDeniedException;
import com.inet.permissions.Permission;
import com.inet.permissions.SystemPermissionChecker;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class GetAssetDetails
extends AbstractInventoryHandler<GetAssetDetailsRequest, GetAssetDetailsResponse> {
    public String getMethodName() {
        return "inventory.getassetdetails";
    }

    @Override
    public GetAssetDetailsResponse handle(HttpServletRequest req, HttpServletResponse resp, GetAssetDetailsRequest payload) throws IOException {
        if (!SystemPermissionChecker.checkAccess((Permission)InventoryServerPlugin.INVENTORY_READ)) {
            throw new AccessDeniedException(InventoryServerPlugin.INVENTORY_READ);
        }
        List<AssetDetails> details = new ArrayList<AssetDetails>();
        List<GUID> assetIds = payload.getAssetIds();
        if (assetIds != null) {
            details = assetIds.stream().map(id -> {
                AssetView asset = AssetManager.getInstance().getAsset((GUID)id);
                if (asset == null) {
                    return null;
                }
                return InitInventoryDetails.createAssetDetails(asset);
            }).filter(a -> a != null).collect(Collectors.toList());
        }
        return new GetAssetDetailsResponse(details);
    }
}

