/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.inventory.server.webapi.types;

import com.inet.helpdesk.plugins.inventory.server.api.model.field.type.AssetTypeManager;
import com.inet.helpdesk.plugins.inventory.server.webapi.data.InventoryAssetTypeEntry;
import com.inet.helpdesk.plugins.inventory.server.webapi.data.InventorySearchQuery;
import com.inet.plugin.webapi.api.handler.RequestHandlerBase;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@Tag(name="Inventory", description="Operations for managing inventory assets")
public class InventoryTypesHandler
extends RequestHandlerBase<InventorySearchQuery, List<InventoryAssetTypeEntry>> {
    public InventoryTypesHandler() {
        super(new String[]{"types"});
    }

    public String getHelpPageKey() {
        return "webapi.inventory.types";
    }

    @Operation(summary="Get all asset types", description="Retrieves a list of all available asset types in the inventory system", responses={@ApiResponse(responseCode="200", description="List of asset types retrieved successfully", content={@Content(array=@ArraySchema(schema=@Schema(implementation=InventoryAssetTypeEntry.class)))}), @ApiResponse(responseCode="401", description="User not authorized to access asset types")})
    public List<InventoryAssetTypeEntry> handle(@Nonnull HttpServletRequest request, @Nonnull HttpServletResponse response, @Nullable InventorySearchQuery inputObject, @Nonnull List<String> pathTokens, boolean previewModeEnabled) throws IOException {
        AssetTypeManager typeManager = AssetTypeManager.getInstance();
        List assetTypes = typeManager.getAll(true);
        return assetTypes.stream().map(t -> InventoryAssetTypeEntry.from(t)).collect(Collectors.toList());
    }
}

