/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.inventory.server.webapi;

import com.inet.classloader.I18nMessages;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.abstracts.AssetFieldDefinition;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.abstracts.AssetFieldWithFieldGroup;
import com.inet.helpdesk.plugins.inventory.server.plugin.InventoryServerPlugin;
import com.inet.helpdesk.plugins.inventory.server.webapi.asset.InventoryAssetHandler;
import com.inet.helpdesk.plugins.inventory.server.webapi.asset.InventoryCreateAssetHandler;
import com.inet.helpdesk.plugins.inventory.server.webapi.fields.InventoryFieldsHandler;
import com.inet.helpdesk.plugins.inventory.server.webapi.group.InventoryFieldWithGroupHandler;
import com.inet.helpdesk.plugins.inventory.server.webapi.search.InventorySearchHandler;
import com.inet.helpdesk.plugins.inventory.server.webapi.tree.InventoryTreeHandler;
import com.inet.helpdesk.plugins.inventory.server.webapi.types.InventoryTypesHandler;
import com.inet.helpdesk.plugins.inventory.server.webapi.util.InventoryWebAPIHelper;
import com.inet.permissions.Permission;
import com.inet.plugin.ServerPluginManager;
import com.inet.plugin.webapi.api.WebAPIExtension;
import com.inet.plugin.webapi.api.handler.RequestHandler;
import com.inet.plugin.webapi.api.handler.RequestHandlerBase;
import io.swagger.v3.oas.annotations.OpenAPIDefinition;
import io.swagger.v3.oas.annotations.info.Info;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import java.net.URL;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@OpenAPIDefinition(info=@Info(title="Inventory API", description="API for managing inventory assets, including CRUD operations, search, and tree structure management", version="1.0"), security={@SecurityRequirement(name="inventory_auth")})
@Tag(name="Inventory", description="Operations for managing inventory assets")
public class InventoryWebAPIExtension
extends WebAPIExtension {
    public static final String INVENTORY = "inventory";
    public static final I18nMessages MSG = new I18nMessages("com.inet.helpdesk.plugins.inventory.server.webapi.i18n.Language", InventoryWebAPIExtension.class);

    public InventoryWebAPIExtension() {
        this.setGenericRequestHandler((RequestHandler)new InventoryAssetHandler());
        this.registerRequestHandler((RequestHandlerBase)new InventoryCreateAssetHandler());
        this.registerRequestHandler(new InventorySearchHandler());
        this.registerRequestHandler(new InventoryTreeHandler());
        this.registerRequestHandler(new InventoryTypesHandler());
        this.registerRequestHandler(new InventoryFieldsHandler());
    }

    @Nonnull
    public String getExtensionName() {
        return INVENTORY;
    }

    @Nullable
    public Permission getRequiredPermission(@Nullable HttpServletRequest request, @Nullable List<String> pathTokens) {
        return InventoryServerPlugin.INVENTORY_READ;
    }

    public String extensionDisplayName() {
        return MSG.getMsg("webapi.extension.name", new Object[0]);
    }

    public String extensionDescription() {
        return MSG.getMsg("webapi.extension.description", new Object[0]);
    }

    public String getHelpPageKey() {
        return "webapi.inventory";
    }

    public URL getIconURL() {
        return InventoryServerPlugin.class.getResource("/com/inet/helpdesk/plugins/inventory/server/images/inventory_48.png");
    }

    public static void init(ServerPluginManager spm) {
        try {
            WebAPIExtension extension = (WebAPIExtension)spm.getSingleInstanceByName(WebAPIExtension.class, INVENTORY, false);
            List fieldWithGroup = InventoryWebAPIHelper.getAssetFieldDefintions().stream().filter(f -> f instanceof AssetFieldWithFieldGroup).collect(Collectors.toList());
            for (AssetFieldDefinition field : fieldWithGroup) {
                extension.registerRequestHandler((RequestHandlerBase)new InventoryFieldWithGroupHandler(field));
            }
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }
}

