/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.inventory.server.webapi.group;

import com.inet.field.SelectOption;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.abstracts.AssetFieldDefinition;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.abstracts.AssetFieldWithFieldGroup;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.abstracts.AssetField_Select;
import com.inet.helpdesk.plugins.inventory.server.webapi.data.InventoryFieldWithGroupDetailResponse;
import com.inet.lib.json.Json;
import com.inet.plugin.webapi.api.handler.RequestHandler;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;
import javax.annotation.Nullable;

@Tag(name="Inventory", description="Operations for managing inventory assets")
public class InventoryFieldWithGroupDetailsHandler
extends RequestHandler.WithCurrentPathToken<Void, InventoryFieldWithGroupDetailResponse, String> {
    private AssetFieldWithFieldGroup field;
    private String fieldKey;

    public InventoryFieldWithGroupDetailsHandler(AssetFieldDefinition field) {
        super(new String[]{field.getFieldKey()});
        if (!(field instanceof AssetFieldWithFieldGroup)) {
            throw new IllegalArgumentException("Types do not match. Programming error");
        }
        this.field = (AssetFieldWithFieldGroup)((Object)field);
        this.fieldKey = field.getFieldKey();
    }

    public String typeFor(String token) {
        return token;
    }

    public String getHelpPageKey() {
        return "webapi.inventory.group." + this.fieldKey + ".details";
    }

    @Operation(summary="Get field group details", description="Retrieves detailed information about a specific field group option including its additional fields", responses={@ApiResponse(responseCode="200", description="Field group details retrieved successfully", content={@Content(schema=@Schema(implementation=InventoryFieldWithGroupDetailResponse.class))}), @ApiResponse(responseCode="400", description="Invalid field group token or field does not support additional details"), @ApiResponse(responseCode="401", description="User not authorized to access field group details"), @ApiResponse(responseCode="404", description="Field group not found")})
    public InventoryFieldWithGroupDetailResponse handle(HttpServletRequest request, HttpServletResponse response, @Nullable Void inputObject, @Nullable String tokenObject, boolean previewModeEnabled) throws IOException {
        String selectOption = new Json().toJson((Object)new SelectOption(tokenObject, tokenObject));
        List<AssetFieldWithFieldGroup.AdditionalDetailField> additionalFields = this.field.getAdditionalFields(selectOption);
        if (additionalFields == null) {
            return null;
        }
        SelectOption fieldSelection = null;
        if (this.field instanceof AssetField_Select) {
            AssetField_Select select = (AssetField_Select)((Object)this.field);
            fieldSelection = select.getSelectOptions(true).stream().filter(f -> tokenObject != null && tokenObject.equals(f.getValue())).findFirst().orElse(null);
        }
        return InventoryFieldWithGroupDetailResponse.from(tokenObject, fieldSelection, additionalFields);
    }
}

