/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.inventory.server.taskplanner.action.addaffectedasset;

import com.inet.helpdesk.plugins.inventory.server.taskplanner.action.addaffectedasset.AddAffectedAssetAction;
import com.inet.helpdesk.plugins.inventory.server.taskplanner.i18n.InventoryTaskPlannerMsg;
import com.inet.helpdesk.plugins.taskplanner.HelpDeskTaskPlannerServerPlugin;
import com.inet.helpdesk.plugins.taskplanner.server.HDPlaceholders;
import com.inet.id.GUID;
import com.inet.lib.util.StringFunctions;
import com.inet.taskplanner.server.api.action.ResultActionDefinition;
import com.inet.taskplanner.server.api.action.ResultActionFactory;
import com.inet.taskplanner.server.api.action.ResultActionInfo;
import com.inet.taskplanner.server.api.common.SummaryEntry;
import com.inet.taskplanner.server.api.common.SummaryInfo;
import com.inet.taskplanner.server.api.error.ValidationException;
import com.inet.taskplanner.server.api.field.LabelField;
import com.inet.taskplanner.server.api.field.TextField;
import com.inet.taskplanner.server.api.result.ResultFlavor;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class AddAffectedAssetActionFactory
extends ResultActionFactory<AddAffectedAssetAction> {
    public static final String EXTENSION_NAME = "result.helpdesk.inventory.addaffectedasset";
    public static final String PROPERTY_ASSET_ID = "assetIdToAdd";

    public AddAffectedAssetActionFactory() {
        super(EXTENSION_NAME);
    }

    public List<ResultFlavor> getSupportedFlavors(ResultActionDefinition definition) {
        return Arrays.asList(ResultFlavor.NONE);
    }

    public ResultActionInfo getInformation(@Nullable GUID taskID) {
        String name = InventoryTaskPlannerMsg.MSG.getMsg("AddAffectedAssetAction.name", new Object[0]);
        String description = InventoryTaskPlannerMsg.MSG.getMsg("AddAffectedAssetAction.description", new Object[0]);
        URL iconURL = ((Object)((Object)this)).getClass().getResource("/com/inet/helpdesk/plugins/inventory/server/images/inventory_32.svg");
        String helpKey = "taskplanner.action.inventory.add-affected-asset";
        ArrayList<Object> fields = new ArrayList<Object>();
        String assetExplanation = InventoryTaskPlannerMsg.MSG.getMsg("AddAffectedAssetAction.assetId.help", new Object[0]);
        LabelField label = new LabelField("assetIdToAdd.help", "", assetExplanation);
        fields.add(label);
        String assetIdLabel = InventoryTaskPlannerMsg.MSG.getMsg("AddAffectedAssetAction.assetId.label", new Object[0]);
        TextField assetId = new TextField(PROPERTY_ASSET_ID, assetIdLabel);
        assetId.setValue("{asset.id}");
        fields.add(assetId);
        TextField ticketId = new TextField("Ticket ID", HelpDeskTaskPlannerServerPlugin.MSG.getMsg("TicketIDLabel", new Object[0]));
        ticketId.setValue("{Ticket ID}");
        HDPlaceholders.setPlaceholderDynamicallyForTextFieldInAction((GUID)taskID, (TextField)ticketId);
        fields.add(ticketId);
        return new ResultActionInfo(this.getExtensionName(), name, description, iconURL, helpKey, fields);
    }

    protected void validate(@Nonnull ResultActionDefinition definition, @Nullable GUID taskID) throws ValidationException {
        String assetId = definition.getProperty(PROPERTY_ASSET_ID);
        if (StringFunctions.isEmpty((String)assetId) && !this.hasPlaceholderSet(assetId, taskID)) {
            throw new ValidationException(new String[]{InventoryTaskPlannerMsg.MSG.getMsg("AddAffectedAssetAction.error.assetIdMissing", new Object[0])});
        }
        String ticketIds = definition.getProperty("Ticket ID");
        if (StringFunctions.isEmpty((String)ticketIds)) {
            throw new ValidationException(new String[]{InventoryTaskPlannerMsg.MSG.getMsg("AddAffectedAssetAction.error.ticketIdMissing", new Object[0])});
        }
    }

    protected AddAffectedAssetAction createInstanceFrom(ResultActionDefinition definition, GUID taskID) {
        String assetId = definition.getProperty(PROPERTY_ASSET_ID);
        String ticketIds = definition.getProperty("Ticket ID");
        return new AddAffectedAssetAction(ticketIds, assetId, taskID);
    }

    public SummaryInfo getSummary(@Nonnull ResultActionDefinition definition) {
        ArrayList<SummaryEntry> entries = new ArrayList<SummaryEntry>();
        String assetId = definition.getProperty(PROPERTY_ASSET_ID);
        String ticketId = definition.getProperty("Ticket ID");
        entries.add(new SummaryEntry(InventoryTaskPlannerMsg.MSG.getMsg("AddAffectedAssetAction.summary", new Object[]{assetId == null ? "" : assetId}), "Ticket #" + ticketId));
        return new SummaryInfo(entries);
    }
}

