/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.inventory.server.maintenance.backup;

import com.inet.fieldsettings.api.AbstractFieldSettingsManager;
import com.inet.fieldsettings.api.model.GenericFieldSetting;
import com.inet.fieldsettings.user.UserFieldSettingsManager;
import com.inet.helpdesk.plugins.inventory.server.api.AssetFieldSettingsManager;
import com.inet.helpdesk.plugins.inventory.server.api.AssetManager;
import com.inet.lib.json.Json;
import com.inet.logging.LogManager;
import com.inet.maintenance.api.backup.BackupContentInformation;
import com.inet.maintenance.api.backup.BackupRunningStatus;
import com.inet.maintenance.api.backup.BackupTask;
import com.inet.maintenance.api.backup.ProgressUpdater;
import com.inet.shared.utils.Version;
import com.inet.usersandgroups.api.user.UserAccountScope;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.net.URL;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class InventoryFieldSettingsBackupTask
implements BackupTask {
    public String getKey() {
        return "inventoryfieldsettingsbackup";
    }

    public String getTitle() {
        return AssetManager.MSG.getMsg("maintenance.backuptask.title", new Object[0]);
    }

    public String getDescription() {
        return AssetManager.MSG.getMsg("maintenance.backuptask.description", new Object[0]);
    }

    public URL getIconURL() {
        return InventoryFieldSettingsBackupTask.class.getResource("/com/inet/helpdesk/plugins/inventory/server/images/config_category_fields.png");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Path taskPath, BackupRunningStatus runningStatus, BackupContentInformation contentInformation, ProgressUpdater progressUpdater) throws Throwable {
        AssetFieldSettingsManager manager = AssetFieldSettingsManager.getInstance();
        List settings = manager.getSettings();
        ArrayList<String> details = new ArrayList<String>();
        details.add(AssetManager.MSG.getMsg("maintenance.backuptask.details.total", new Object[]{settings.size()}));
        details.add(UserFieldSettingsManager.USER_TRANSLATIONS.getMsg("backuptask.userfields.details.customFields", new Object[]{settings.stream().filter(GenericFieldSetting::isCustom).count()}));
        contentInformation.putTaskDetails(this.getKey(), details);
        int count = 0;
        try (FileOutputStream out = new FileOutputStream(taskPath.resolve("assetfieldsettings.zip").toFile());
             ZipOutputStream zip = new ZipOutputStream(out);){
            for (GenericFieldSetting setting : settings) {
                Map map = setting.toMap((AbstractFieldSettingsManager)manager);
                try {
                    ZipEntry zipEntry = new ZipEntry(setting.getKey());
                    zip.putNextEntry(zipEntry);
                    new Json().toJson((Object)map, (OutputStream)zip);
                }
                finally {
                    zip.closeEntry();
                }
                progressUpdater.updateProgress(++count * 100 / settings.size());
            }
        }
    }

    public void restore(Path taskPath, BackupRunningStatus runningStatus, ProgressUpdater progressUpdater, Version backupVersion) throws Throwable {
        AssetFieldSettingsManager manager = AssetFieldSettingsManager.getInstance();
        try (UserAccountScope p = UserAccountScope.createPrivileged();){
            manager.doBatchModification(() -> {
                try (FileInputStream in = new FileInputStream(taskPath.resolve("assetfieldsettings.zip").toFile());
                     ZipInputStream zip = new ZipInputStream(in);){
                    ZipEntry zipEntry;
                    while ((zipEntry = zip.getNextEntry()) != null) {
                        try {
                            String key = zipEntry.getName();
                            Map map = (Map)new Json().fromJson((InputStream)zip, Map.class);
                            if (manager.getSetting(key) == null) {
                                manager.addNewCustomField(key, map);
                                continue;
                            }
                            String customBackup = (String)map.get("fieldsettingsIsCustom");
                            boolean customServer = manager.getSetting(key).isCustom();
                            if (customBackup == null || !customServer && Boolean.valueOf(customBackup).booleanValue()) {
                                LogManager.getLogger((String)"Maintenance").warn((Object)String.format("[Backup] Cannot restore asset field setting %s, because in the backup file custom=%s, but here custom=%s. This cannot be changed and properties cannot be converted.  ", key, customBackup, String.valueOf(customServer)));
                                continue;
                            }
                            manager.updateSetting(key, map);
                        }
                        finally {
                            zip.closeEntry();
                        }
                    }
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            });
        }
    }

    public boolean isVersionSupportedForRestore(Version backupVersion) {
        return backupVersion.isHigherOrEquals(new Version("23.10"));
    }
}

