/*
 * Decompiled with CFR 0.152.
 */
package com.inet.slf4j;

import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.Marker;
import org.slf4j.helpers.MessageFormatter;

public class InetSLF4JLogger
implements Logger {
    private final com.inet.logging.Logger logger;
    private static final ThreadLocal<Object> isCalling = new ThreadLocal();

    InetSLF4JLogger(@Nonnull com.inet.logging.Logger logger) {
        this.logger = logger;
    }

    private void toDebug(Throwable th, String msg, Object ... arg1) {
        if (!this.logger.isDebug()) {
            return;
        }
        this.logger.debug(InetSLF4JLogger.getMessage(msg, arg1), (Object)th);
    }

    private void toError(Throwable th, String msg, Object ... arg1) {
        if (!this.logger.isError()) {
            return;
        }
        this.logger.error(InetSLF4JLogger.getMessage(msg, arg1), th);
    }

    private void toInfo(Throwable th, String msg, Object ... arg1) {
        if (!this.logger.isInfo()) {
            return;
        }
        this.logger.info(InetSLF4JLogger.getMessage(msg, arg1), (Object)th);
    }

    private void toTrace(Throwable th, String msg, Object ... arg1) {
        if (isCalling.get() != null || !this.logger.isDebug()) {
            return;
        }
        this.logger.debug(InetSLF4JLogger.getMessage(msg, arg1), (Object)th);
    }

    private void toWarn(Throwable th, String msg, Object ... arg1) {
        if (!this.logger.isWarning()) {
            return;
        }
        this.logger.warn(InetSLF4JLogger.getMessage(msg, arg1), (Object)th);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getMessage(String msg, Object ... arg1) {
        String result;
        String string = result = msg != null ? msg : "null";
        if (arg1 != null && arg1.length > 0) {
            try {
                isCalling.set(Boolean.TRUE);
                result = MessageFormatter.arrayFormat((String)result, (Object[])arg1, null).getMessage();
            }
            catch (Exception exception) {
            }
            finally {
                isCalling.set(null);
            }
        }
        return result;
    }

    public void debug(String msg) {
        this.toDebug(null, msg, new Object[0]);
    }

    public void debug(String msg, Object arg1) {
        this.toDebug(null, msg, arg1);
    }

    public void debug(String msg, Object ... arg1) {
        this.toDebug(null, msg, arg1);
    }

    public void debug(String msg, Throwable th) {
        this.toDebug(th, msg, new Object[0]);
    }

    public void debug(Marker arg0, String msg) {
        this.toDebug(null, msg, new Object[0]);
    }

    public void debug(String msg, Object arg1, Object arg2) {
        this.toDebug(null, msg, arg1, arg2);
    }

    public void debug(Marker arg0, String msg, Object arg2) {
        this.toDebug(null, msg, arg2);
    }

    public void debug(Marker arg0, String msg, Object ... arg2) {
        this.toDebug(null, msg, arg2);
    }

    public void debug(Marker arg0, String msg, Throwable th) {
        this.toDebug(th, msg, new Object[0]);
    }

    public void debug(Marker arg0, String msg, Object arg2, Object arg3) {
        this.toDebug(null, msg, arg2, arg3);
    }

    public void error(String msg) {
        this.toError(null, msg, new Object[0]);
    }

    public void error(String msg, Object arg1) {
        this.toError(null, msg, arg1);
    }

    public void error(String msg, Object ... arg1) {
        this.toError(null, msg, arg1);
    }

    public void error(String msg, Throwable th) {
        this.toError(th, msg, new Object[0]);
    }

    public void error(Marker arg0, String msg) {
        this.toError(null, msg, new Object[0]);
    }

    public void error(String msg, Object arg1, Object arg2) {
        this.toError(null, msg, arg1, arg2);
    }

    public void error(Marker arg0, String msg, Object arg2) {
        this.toError(null, msg, arg2);
    }

    public void error(Marker arg0, String msg, Object ... arg2) {
        this.toError(null, msg, arg2);
    }

    public void error(Marker arg0, String msg, Throwable th) {
        this.toError(th, msg, new Object[0]);
    }

    public void error(Marker arg0, String msg, Object arg2, Object arg3) {
        this.toError(null, msg, arg2, arg3);
    }

    public String getName() {
        return InetSLF4JLogger.class.getName();
    }

    public void info(String msg) {
        this.toInfo(null, msg, new Object[0]);
    }

    public void info(String msg, Object arg1) {
        this.toInfo(null, msg, arg1);
    }

    public void info(String msg, Object ... arg1) {
        this.toInfo(null, msg, arg1);
    }

    public void info(String msg, Throwable th) {
        this.toInfo(th, msg, new Object[0]);
    }

    public void info(Marker arg0, String msg) {
        this.toInfo(null, msg, new Object[0]);
    }

    public void info(String msg, Object arg1, Object arg2) {
        this.toInfo(null, msg, arg1, arg2);
    }

    public void info(Marker arg0, String msg, Object arg2) {
        this.toInfo(null, msg, arg2);
    }

    public void info(Marker arg0, String msg, Object ... arg2) {
        this.toInfo(null, msg, arg2);
    }

    public void info(Marker arg0, String msg, Throwable th) {
        this.toInfo(th, msg, new Object[0]);
    }

    public void info(Marker arg0, String msg, Object arg2, Object arg3) {
        this.toInfo(null, msg, arg2, arg3);
    }

    public boolean isDebugEnabled() {
        return this.logger.isDebug();
    }

    public boolean isDebugEnabled(Marker arg0) {
        return this.logger.isDebug();
    }

    public boolean isErrorEnabled() {
        return this.logger.isError();
    }

    public boolean isErrorEnabled(Marker arg0) {
        return this.logger.isError();
    }

    public boolean isInfoEnabled() {
        return this.logger.isInfo();
    }

    public boolean isInfoEnabled(Marker arg0) {
        return this.logger.isInfo();
    }

    public boolean isTraceEnabled() {
        return this.logger.isDebug();
    }

    public boolean isTraceEnabled(Marker arg0) {
        return this.logger.isDebug();
    }

    public boolean isWarnEnabled() {
        return this.logger.isWarning();
    }

    public boolean isWarnEnabled(Marker arg0) {
        return this.logger.isWarning();
    }

    public void trace(String msg) {
        this.toTrace(null, msg, new Object[0]);
    }

    public void trace(String msg, Object arg1) {
        this.toTrace(null, msg, arg1);
    }

    public void trace(String msg, Object ... arg1) {
        this.toTrace(null, msg, arg1);
    }

    public void trace(String msg, Throwable th) {
        this.toTrace(th, msg, new Object[0]);
    }

    public void trace(Marker arg0, String msg) {
        this.toTrace(null, msg, new Object[0]);
    }

    public void trace(String msg, Object arg1, Object arg2) {
        this.toTrace(null, msg, arg1, arg2);
    }

    public void trace(Marker arg0, String msg, Object arg2) {
        this.toTrace(null, msg, arg2);
    }

    public void trace(Marker arg0, String msg, Object ... arg2) {
        this.toTrace(null, msg, arg2);
    }

    public void trace(Marker arg0, String msg, Throwable th) {
        this.toTrace(th, msg, new Object[0]);
    }

    public void trace(Marker arg0, String msg, Object arg2, Object arg3) {
        this.toTrace(null, msg, arg2, arg3);
    }

    public void warn(String msg) {
        this.toWarn(null, msg, new Object[0]);
    }

    public void warn(String msg, Object arg1) {
        this.toWarn(null, msg, arg1);
    }

    public void warn(String msg, Object ... arg1) {
        this.toWarn(null, msg, arg1);
    }

    public void warn(String msg, Throwable th) {
        this.toWarn(th, msg, new Object[0]);
    }

    public void warn(Marker arg0, String msg) {
        this.toWarn(null, msg, new Object[0]);
    }

    public void warn(String msg, Object arg1, Object arg2) {
        this.toWarn(null, msg, arg1, arg2);
    }

    public void warn(Marker arg0, String msg, Object arg2) {
        this.toWarn(null, msg, arg2);
    }

    public void warn(Marker arg0, String msg, Object ... arg2) {
        this.toWarn(null, msg, arg2);
    }

    public void warn(Marker arg0, String msg, Throwable th) {
        this.toWarn(th, msg, new Object[0]);
    }

    public void warn(Marker arg0, String msg, Object arg2, Object arg3) {
        this.toWarn(null, msg, arg2, arg3);
    }
}

