/*
 * Decompiled with CFR 0.152.
 */
package com.inet.usersandgroups.api.ui.fields.user;

import com.inet.annotations.JsonData;
import com.inet.authentication.AuthenticationDescription;
import com.inet.authentication.AuthenticationProvider;
import com.inet.authentication.SystemAuthenticationProvider;
import com.inet.authentication.base.LoginManager;
import com.inet.http.servlet.SessionStore;
import com.inet.lib.json.Json;
import com.inet.lib.util.StringFunctions;
import com.inet.permissions.SystemPermissionChecker;
import com.inet.plugin.DynamicExtensionManager;
import com.inet.usersandgroups.UsersAndGroups;
import com.inet.usersandgroups.api.ui.fields.UserUpdateData;
import com.inet.usersandgroups.api.ui.fields.user.CoreUserFieldDefinition;
import com.inet.usersandgroups.api.ui.fields.user.LoginDescription;
import com.inet.usersandgroups.api.ui.fields.user.LoginSettingsDescription;
import com.inet.usersandgroups.api.ui.fields.user.UserFieldDefinition;
import com.inet.usersandgroups.api.ui.fields.values.FieldValue;
import com.inet.usersandgroups.api.user.LoginSettings;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserAccountType;
import jakarta.servlet.http.HttpSession;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class LoginsUserFieldDefinition
extends UserFieldDefinition<LoginSettingsDescription>
implements CoreUserFieldDefinition {
    private static final String SESSION_KEY = "addedLoginSettings";

    public LoginsUserFieldDefinition(String groupKey, String fieldKey, int prio) {
        super(groupKey, fieldKey, "fieldtype_logins", prio);
    }

    @Override
    public FieldValue getFieldValue(@Nullable UserAccount userAccount) {
        Object object;
        Object object222;
        Object object3;
        List<AuthenticationProvider> list;
        ArrayList<AuthenticationDescription> arrayList;
        List<Object> list2 = new ArrayList();
        if (userAccount != null) {
            list2 = userAccount.getLoginSettings();
        }
        if (!(arrayList = new ArrayList<AuthenticationDescription>(LoginManager.getAllAuthenticationDescriptions())).stream().anyMatch(authenticationDescription -> authenticationDescription.getName().equals("master"))) {
            list = DynamicExtensionManager.getInstance().get(AuthenticationProvider.class);
            object3 = list.stream().filter(authenticationProvider -> "master".equals(authenticationProvider.name())).map(authenticationProvider -> authenticationProvider.getAuthenticationDescription(new HashMap<String, String>(), false, false)).filter(authenticationDescription -> authenticationDescription != null).collect(Collectors.toList());
            arrayList.addAll((Collection<AuthenticationDescription>)object3);
        }
        list = new ArrayList<AuthenticationProvider>();
        for (Object object222 : list2) {
            object = ((LoginSettings)object222).getLoginSource();
            if (LoginManager.isTokenLoginSource((String)object)) continue;
            boolean bl = this.isDeletable(list2, (LoginSettings)object222, userAccount);
            String string = ((LoginSettings)object222).getLoginID();
            String string2 = ((LoginSettings)object222).getDisplayName();
            Object object5 = object;
            AuthenticationDescription object6 = null;
            for (AuthenticationDescription authenticationDescription2 : arrayList) {
                if ("system".equals(object)) {
                    if (!(authenticationDescription2.getProvider() instanceof SystemAuthenticationProvider)) continue;
                    object6 = authenticationDescription2;
                    break;
                }
                if (!authenticationDescription2.getName().equals(object)) continue;
                object6 = authenticationDescription2;
                object5 = authenticationDescription2.getProvider().name();
                break;
            }
            if (object6 == null) continue;
            String string3 = object6.getName();
            String string4 = object6.getDisplayName();
            String string5 = object6.getColor();
            list.add((AuthenticationProvider)((Object)new LoginDescription((String)object5, string3, string4, string5, string, string2, bl)));
        }
        object3 = null;
        if (SystemPermissionChecker.checkAccess(UsersAndGroups.PERMISSION_USERS_AND_GROUPS_MANAGER_ADMIN)) {
            object222 = LoginManager.getAllAuthenticationDescriptions();
            object = object222.iterator();
            while (object.hasNext()) {
                AuthenticationDescription authenticationDescription2 = (AuthenticationDescription)object.next();
                if (!(authenticationDescription2.getProvider() instanceof SystemAuthenticationProvider)) continue;
                object3 = authenticationDescription2.getDisplayName();
                break;
            }
        }
        object222 = new LoginSettingsDescription(list, (String)object3);
        object = new LoginsFieldValue(new Json().toJson(object222), userAccount == null || userAccount.getAccountType() == UserAccountType.Standard);
        ((FieldValue)object).setVisibleInPreview(!list.isEmpty());
        return object;
    }

    protected boolean isDeletable(List<LoginSettings> loginSettings, LoginSettings login, UserAccount userAccount) {
        return true;
    }

    @Override
    public LoginSettingsDescription convertFromString(String value) {
        if (StringFunctions.isEmpty(value)) {
            return new LoginSettingsDescription(new ArrayList<LoginDescription>(), null);
        }
        return new Json().fromJson(value, LoginSettingsDescription.class);
    }

    @Override
    public void save(UserAccount userAccount, UserUpdateData userUpdateData, Object value) {
        HttpSession httpSession = SessionStore.getHttpSession();
        HashMap hashMap = (HashMap)httpSession.getAttribute(SESSION_KEY);
        List<Object> list = userAccount != null ? userAccount.getLoginSettings() : Collections.emptyList();
        LoginSettingsDescription loginSettingsDescription = (LoginSettingsDescription)value;
        List<LoginDescription> list2 = loginSettingsDescription.getLogins();
        for (LoginDescription object : list2) {
            LoginSettings loginSettings;
            if (hashMap == null || (loginSettings = (LoginSettings)hashMap.get(object.getUid())) == null) continue;
            userUpdateData.addAddedLoginSettings(loginSettings);
        }
        for (LoginSettings loginSettings : list) {
            if (this.a(list2, loginSettings) || LoginManager.isTokenLoginSource(loginSettings.getLoginSource())) continue;
            userUpdateData.addRemovedLoginSettings(loginSettings);
        }
    }

    private boolean a(List<LoginDescription> list, LoginSettings loginSettings) {
        for (LoginDescription loginDescription : list) {
            if (!Objects.equals(loginDescription.getLogintype(), loginSettings.getLoginSource()) && !Objects.equals(loginDescription.getProvider(), loginSettings.getLoginSource()) || !Objects.equals(loginDescription.getLoginID(), loginSettings.getLoginID())) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getLabel() {
        return null;
    }

    public static void putLoginInSession(@Nonnull String uid, @Nonnull LoginSettings login) {
        Objects.requireNonNull(uid);
        Objects.requireNonNull(login);
        HttpSession httpSession = SessionStore.getHttpSession();
        HashMap<String, LoginSettings> hashMap = (HashMap<String, LoginSettings>)httpSession.getAttribute(SESSION_KEY);
        if (hashMap == null) {
            hashMap = new HashMap<String, LoginSettings>();
            httpSession.setAttribute(SESSION_KEY, hashMap);
        }
        hashMap.put(uid, login);
    }

    @JsonData
    private static class LoginsFieldValue
    extends FieldValue {
        private boolean editable;

        public LoginsFieldValue(String value, boolean editable) {
            super(value);
            this.editable = editable;
        }
    }
}

