/*
 * Decompiled with CFR 0.152.
 */
package com.inet.usersandgroups.api.ui.fields.user;

import com.inet.http.servlet.ClientLocale;
import com.inet.logging.LogManager;
import com.inet.usersandgroups.api.UserField;
import com.inet.usersandgroups.api.ui.fields.user.DoubleUserFieldDefinition;
import com.inet.usersandgroups.api.ui.fields.values.CurrencyFieldValue;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import java.util.Currency;
import java.util.Locale;
import javax.annotation.Nonnull;

public abstract class CurrencyUserFieldDefinition
extends DoubleUserFieldDefinition {
    public CurrencyUserFieldDefinition(String groupKey, UserField<Double> field, int prio) {
        super(groupKey, field, "fieldtype_currency", prio);
    }

    @Override
    public CurrencyFieldValue getFieldValue(UserAccount userAccount) {
        Double d2 = userAccount != null ? (Double)userAccount.getValue(UserManager.getRecoveryEnabledInstance().getField(this.getFieldKey())) : (Double)this.getDefaultValue();
        Locale locale = new Locale(ClientLocale.getThreadLocale().getLanguage(), Locale.getDefault().getCountry());
        CurrencyFieldValue currencyFieldValue = new CurrencyFieldValue(d2, CurrencyUserFieldDefinition.getCurrency().getSymbol(locale));
        currencyFieldValue.setVisibleInPreview(d2 != null);
        currencyFieldValue.setEnabled(this.isEnabled());
        return currencyFieldValue;
    }

    @Nonnull
    public static Currency getCurrency() {
        Locale locale = Locale.getDefault();
        Currency currency = null;
        try {
            currency = Currency.getInstance(locale);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            LogManager.getApplicationLogger().debug("Cannot load correct currency for locale " + locale.toString());
        }
        if (currency == null) {
            return Currency.getInstance(Locale.US);
        }
        return currency;
    }
}

