/*
 * Decompiled with CFR 0.152.
 */
package com.inet.shared.utils;

import com.inet.annotations.InternalApi;
import com.inet.http.security.TrustAllTrustManager;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import javax.net.SocketFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;

@InternalApi
public class TrustAllSSLSocketFactory
extends SSLSocketFactory {
    private final SSLSocketFactory a;

    public TrustAllSSLSocketFactory() throws NoSuchAlgorithmException, KeyManagementException {
        SSLContext sSLContext = SSLContext.getInstance("TLS");
        sSLContext.init(null, this.getTrustManagers(), null);
        this.a = sSLContext.getSocketFactory();
    }

    public static SocketFactory getDefault() {
        try {
            return new TrustAllSSLSocketFactory();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    protected TrustManager[] getTrustManagers() {
        return new TrustManager[]{new TrustAllTrustManager()};
    }

    @Override
    public Socket createSocket(Socket s, String host, int port, boolean autoClose) throws IOException {
        return this.a.createSocket(s, host, port, autoClose);
    }

    @Override
    public String[] getDefaultCipherSuites() {
        return this.a.getDefaultCipherSuites();
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return this.a.getSupportedCipherSuites();
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
        return this.a.createSocket(host, port);
    }

    @Override
    public Socket createSocket(InetAddress host, int port) throws IOException {
        return this.a.createSocket(host, port);
    }

    @Override
    public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException, UnknownHostException {
        return this.a.createSocket(host, port, localHost, localPort);
    }

    @Override
    public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
        return this.a.createSocket(address, port, localAddress, localPort);
    }

    @Override
    public Socket createSocket() throws IOException {
        return this.a.createSocket();
    }
}

