/*
 * Decompiled with CFR 0.152.
 */
package com.inet.plugin.fs;

import com.inet.annotations.InternalApi;
import com.inet.lib.util.IOFunctions;
import com.inet.plugin.fs.ArchiveFile;
import com.inet.plugin.fs.ResourceFile;
import com.inet.plugin.fs.UrlArchiveFile;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.zip.ZipException;
import javax.annotation.Nonnull;
import javax.annotation.SuppressFBWarnings;

@InternalApi
public class FileResourceFile
implements ResourceFile {
    private final File a;

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="Caller must check it")
    public FileResourceFile(String pathname) {
        this(new File(pathname));
    }

    public FileResourceFile(File file) {
        this.a = file;
    }

    public File getFile() {
        return this.a;
    }

    @Override
    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="Caller must check it")
    public FileResourceFile createChild(@Nonnull String child) {
        return new FileResourceFile(new File(this.a, child));
    }

    @Override
    public String getName() {
        return this.a.getName();
    }

    @Override
    public boolean isDirectory() {
        return this.a.isDirectory();
    }

    @Override
    public boolean exists() {
        return this.a.exists();
    }

    @Override
    public String getAbsolutePath() {
        return this.a.getAbsolutePath();
    }

    @Override
    public ResourceFile[] listFiles() {
        File[] fileArray = this.a.listFiles();
        if (fileArray == null) {
            return null;
        }
        ResourceFile[] resourceFileArray = new ResourceFile[fileArray.length];
        for (int i2 = 0; i2 < resourceFileArray.length; ++i2) {
            resourceFileArray[i2] = new FileResourceFile(fileArray[i2]);
        }
        return resourceFileArray;
    }

    @Override
    public ArchiveFile createArchiveFile() throws ZipException, IOException {
        return new UrlArchiveFile(this.getURL());
    }

    @Override
    public String getPath() {
        return this.a.getPath();
    }

    @Override
    public long lastModified() {
        return this.a.lastModified();
    }

    public String toString() {
        return this.a.toString();
    }

    @Override
    @Nonnull
    public URL getURL() throws MalformedURLException {
        return IOFunctions.getFileURL(this.a);
    }

    @Override
    @Nonnull
    public InputStream getInputStream() throws FileNotFoundException {
        return new FileInputStream(this.a);
    }

    @Override
    public long length() {
        return this.a.length();
    }
}

