/*
 * Decompiled with CFR 0.152.
 */
package com.inet.plugin;

import com.inet.annotations.InternalApi;
import com.inet.error.ErrorCode;
import com.inet.error.ErrorCodeToHelpKey;
import com.inet.lib.util.DebugUtils;
import com.inet.logging.LogManager;
import com.inet.plugin.DynamicExtensionManager;
import com.inet.plugin.help.HelpProvider;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;

@InternalApi
public class HelpProviderContainer {
    private final List<HelpProvider> a;
    private final Set<String> b;

    protected HelpProviderContainer(Set<String> plugins, List<HelpProvider> helpContainer) {
        this.b = plugins;
        this.a = helpContainer == null ? new ArrayList() : helpContainer;
    }

    public void add(HelpProvider help, String ... requiredPlugins) {
        for (String string : requiredPlugins) {
            if (this.b.contains(string)) continue;
            return;
        }
        if (DebugUtils.DEBUG) {
            for (HelpProvider helpProvider : this.a) {
                if (helpProvider.getPriority() != help.getPriority()) continue;
                LogManager.getLogger("Help").error("WARNING HelpProviderContainer identical help priority " + helpProvider.getHelpPackage() + " vs " + help.getHelpPackage() + " for priority " + help.getPriority());
            }
        }
        this.a.add(help);
    }

    public void addErrorCodeMapping(int errorCode, @Nonnull String helpKey) {
        DynamicExtensionManager.getInstance().register(ErrorCodeToHelpKey.class, new ErrorCodeToHelpKey(errorCode, helpKey));
    }

    public void addErrorCodeMapping(@Nonnull ErrorCode errorCode, @Nonnull String helpKey) {
        DynamicExtensionManager.getInstance().register(ErrorCodeToHelpKey.class, new ErrorCodeToHelpKey(errorCode, helpKey));
    }

    List<HelpProvider> a() {
        return this.a;
    }
}

