/*
 * Decompiled with CFR 0.152.
 */
package com.inet.persistence.file;

import com.inet.lib.io.FastBufferedOutputStream;
import com.inet.lib.io.FastByteArrayOutputStream;
import com.inet.lib.io.UTF8StreamWriter;
import com.inet.logging.EventLog;
import com.inet.logging.EventLogFileArchiver;
import com.inet.logging.LogManager;
import com.inet.persistence.EventLogPersistence;
import com.inet.persistence.MaintenanceMode;
import com.inet.persistence.spi.PersistenceHelper;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Iterator;
import javax.annotation.Nullable;

class a
extends EventLogFileArchiver
implements EventLogPersistence {
    private final File a;
    private UTF8StreamWriter b;
    private final StringBuilder c = new StringBuilder();

    a(File file) {
        this.a = file;
    }

    @Override
    protected File getFile() {
        return this.a;
    }

    @Override
    protected int getMaxLogSize() {
        return Math.max(1, super.getMaxLogSize() / 10);
    }

    @Override
    public void close() {
        UTF8StreamWriter uTF8StreamWriter = this.b;
        this.b = null;
        try {
            if (uTF8StreamWriter != null) {
                uTF8StreamWriter.close();
            }
        }
        catch (Exception exception) {
            LogManager.getConfigLogger().error(exception);
        }
    }

    @Override
    public void delete() {
        this.close();
        this.getFile().delete();
    }

    @Override
    public void write(@Nullable EventLog.EventData eventData) {
        try {
            this.c.setLength(0);
            PersistenceHelper.appendTo(this.c, eventData);
            this.c.append('\n');
            UTF8StreamWriter uTF8StreamWriter = this.a();
            uTF8StreamWriter.append(this.c);
            uTF8StreamWriter.flush();
            this.archivIfNeeded();
        }
        catch (Throwable throwable) {
            LogManager.getConfigLogger().error(throwable);
        }
    }

    private UTF8StreamWriter a() throws IOException {
        if (this.b == null) {
            switch (MaintenanceMode.getState()) {
                case SHUTDOWN: 
                case IN_PROGRESS: {
                    return new UTF8StreamWriter(new FastByteArrayOutputStream());
                }
            }
            File file = this.getFile();
            file.getParentFile().mkdirs();
            FileOutputStream fileOutputStream = new FileOutputStream(file, true);
            if (file.length() == 0L) {
                this.writeNewFileHeader(fileOutputStream);
            }
            this.b = new UTF8StreamWriter(new FastBufferedOutputStream(fileOutputStream));
        }
        return this.b;
    }

    @Override
    public Iterator<String[]> getEvents(int columnCount) {
        try {
            return com.inet.persistence.file.a.getEvents(new FileInputStream(this.a), columnCount);
        }
        catch (FileNotFoundException fileNotFoundException) {
            LogManager.getLogger("Statistics").debug(fileNotFoundException);
            return Collections.emptyIterator();
        }
    }

    @Override
    public InputStream getContent(int columnCount) {
        try {
            return new FileInputStream(this.a);
        }
        catch (IOException iOException) {
            return null;
        }
    }
}

