/*
 * Decompiled with CFR 0.152.
 */
package com.inet.persistence;

import com.inet.annotations.InternalApi;
import com.inet.annotations.JsonData;
import com.inet.logging.LogManager;
import com.inet.persistence.MaintenanceModeListener;
import com.inet.persistence.Persistence;
import com.inet.persistence.PersistenceListener;
import com.inet.plugin.ServerPluginManager;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ForkJoinPool;
import javax.annotation.Nonnull;

@JsonData
@InternalApi
public enum MaintenanceMode {
    NONE,
    PREPARE,
    SHUTDOWN,
    IN_PROGRESS;

    private static MaintenanceMode state;
    private static List<MaintenanceModeListener> listeners;
    private static a NOTIFY;

    public static void addListener(@Nonnull MaintenanceModeListener listener) {
        listeners.add(listener);
    }

    @Nonnull
    private static MaintenanceModeListener[] getListener() {
        Object[] objectArray = listeners.toArray(new MaintenanceModeListener[0]);
        Arrays.sort(objectArray);
        return objectArray;
    }

    public static void start() {
        MaintenanceMode.sendAndNotify(PREPARE);
        MaintenanceMode.sendAndNotify(SHUTDOWN);
        MaintenanceMode.sendAndNotify(IN_PROGRESS);
    }

    public static void finish() {
        MaintenanceMode.sendAndNotify(NONE);
    }

    @Nonnull
    public static MaintenanceMode getState() {
        return state;
    }

    private static void sendAndNotify(@Nonnull MaintenanceMode state) {
        if (ServerPluginManager.getInstance().getState() == ServerPluginManager.ServerPluginManagerState.INIT) {
            Persistence.getInstance().sendEvent(state);
        }
        NOTIFY.a(state);
    }

    static {
        state = NONE;
        listeners = new CopyOnWriteArrayList<MaintenanceModeListener>();
        NOTIFY = new a();
        ForkJoinPool.commonPool().execute(() -> {
            try {
                for (int i2 = 0; i2 < 100 && ServerPluginManager.getInstance().getCorePluginId() == null; ++i2) {
                    Thread.sleep(100L);
                }
                Persistence.getInstance().registerListener(NOTIFY);
            }
            catch (Throwable throwable) {
                LogManager.getConfigLogger().error(throwable);
            }
        });
    }

    private static class a
    implements PersistenceListener<MaintenanceMode> {
        private a() {
        }

        public void a(@Nonnull MaintenanceMode maintenanceMode) {
            state = maintenanceMode;
            MaintenanceModeListener[] maintenanceModeListenerArray = MaintenanceMode.getListener();
            switch (maintenanceMode) {
                case PREPARE: {
                    for (MaintenanceModeListener maintenanceModeListener : maintenanceModeListenerArray) {
                        maintenanceModeListener.prepare();
                    }
                    break;
                }
                case SHUTDOWN: {
                    for (MaintenanceModeListener maintenanceModeListener : maintenanceModeListenerArray) {
                        maintenanceModeListener.shutdown();
                    }
                    break;
                }
                case IN_PROGRESS: {
                    break;
                }
                case NONE: {
                    for (MaintenanceModeListener maintenanceModeListener : maintenanceModeListenerArray) {
                        maintenanceModeListener.finish();
                    }
                    break;
                }
            }
        }

        @Override
        public /* synthetic */ void eventReceived(@Nonnull Object object) {
            this.a((MaintenanceMode)((Object)object));
        }
    }
}

