/*
 * Decompiled with CFR 0.152.
 */
package com.inet.lib.json;

import com.inet.annotations.InternalApi;
import java.io.Reader;
import javax.annotation.Nonnull;

@InternalApi
public class FastStringReader
extends Reader {
    private final String a;
    private final int b;
    private int c;

    public FastStringReader(@Nonnull String str) {
        this.a = str;
        this.b = str.length();
    }

    @Override
    public int read(char[] cbuf, int off, int len) {
        if (this.b <= this.c) {
            return -1;
        }
        int n2 = Math.min(this.b - this.c, len);
        this.a.getChars(this.c, this.c + n2, cbuf, off);
        this.c += n2;
        return n2;
    }

    @Override
    public int read() {
        if (this.b <= this.c) {
            ++this.c;
            return -1;
        }
        return this.a.charAt(this.c++);
    }

    @Override
    public void close() {
        this.c = this.b;
    }

    public void back() {
        if (this.c <= 0) {
            throw new IndexOutOfBoundsException();
        }
        --this.c;
    }

    public int getIndexPosition() {
        return this.c;
    }

    public void setIndexPosition(int idx) {
        if (idx < 0) {
            throw new IndexOutOfBoundsException();
        }
        this.c = idx;
    }
}

