/*
 * Decompiled with CFR 0.152.
 */
package com.inet.lib.json;

import com.inet.annotations.InternalApi;
import com.inet.annotations.JsonData;
import com.inet.lib.json.DeclaredField;
import com.inet.lib.json.JsonException;
import com.inet.lib.json.JsonParameterizedType;
import com.inet.lib.json.JsonSubTypeResolver;
import com.inet.lib.util.DebugUtils;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@InternalApi
public class ClassWrapper {
    private static final Map<Type, ClassWrapper> a = new ConcurrentHashMap<Type, ClassWrapper>();
    private static final Type @Nonnull [] b = new Type[0];
    public static final int JSON_NON_QUOTE = 1;
    public static final int JSON_QUOTE = 2;
    public static final int JSON_COLLECTION = 3;
    public static final int JSON_MAP = 4;
    public static final int JSON_ARRAY = 5;
    public static final int JSON_ENUM = 6;
    public static final int JSON_OBJECT = 7;
    public static final int JSON_DATE = 8;
    public static final int JSON_BOOLEAN = 9;
    public static final int JSON_BYTE = 10;
    public static final int JSON_SHORT = 11;
    public static final int JSON_INTEGER = 12;
    public static final int JSON_LONG = 13;
    public static final int JSON_FLOAT = 14;
    public static final int JSON_DOUBLE = 15;
    public static final int JSON_CHAR = 16;
    public static final int JSON_BYTES = 17;
    private final Class<?> c;
    private final Type d;
    private final Map<String, Field> e = new ConcurrentHashMap<String, Field>();
    private Constructor<?> f;
    private Constructor<?> g;
    private int h;
    private Method i;
    private JsonSubTypeResolver<?> j;
    private DeclaredField[] k;
    private int l;
    private Type[] m;

    private ClassWrapper(Type type) {
        this.c = this.a(type);
        this.d = type;
    }

    @Nonnull
    public static ClassWrapper getWrapper(@Nonnull Type type, @Nullable Type parentType) {
        ClassWrapper classWrapper = a.get(type);
        if (classWrapper == null) {
            if (parentType != null && type instanceof ParameterizedType) {
                ParameterizedType parameterizedType = (ParameterizedType)type;
                boolean bl = false;
                Type[] typeArray = parameterizedType.getActualTypeArguments();
                for (int i2 = 0; i2 < typeArray.length; ++i2) {
                    Type type2 = typeArray[i2];
                    if (type2 instanceof TypeVariable) {
                        ClassWrapper classWrapper2;
                        TypeVariable typeVariable = (TypeVariable)type2;
                        typeVariable.getName();
                        Class clazz = (Class)typeVariable.getGenericDeclaration();
                        ArrayList<ClassWrapper> arrayList = new ArrayList<ClassWrapper>();
                        Class<?> clazz2 = parentType;
                        do {
                            classWrapper2 = ClassWrapper.getWrapper(parentType, null);
                            arrayList.add(classWrapper2);
                        } while ((clazz2 = classWrapper2.c.getSuperclass()) != null && clazz2 != clazz);
                        for (int i3 = arrayList.size() - 1; i3 >= 0; --i3) {
                            ClassWrapper classWrapper3 = (ClassWrapper)arrayList.get(i3);
                            Type[] typeArray2 = classWrapper3.getTypeArguments();
                            if (typeArray2.length <= i2) continue;
                            typeArray[i2] = typeArray2[i2];
                            bl = true;
                            break;
                        }
                    }
                    if (!bl) continue;
                    type = new JsonParameterizedType(parameterizedType.getRawType(), typeArray);
                }
            }
            classWrapper = type != Void.class ? new ClassWrapper(type) : new ClassWrapper(type){

                @Override
                @Nonnull
                Object b() throws JsonException {
                    return null;
                }
            };
            a.put(type, classWrapper);
        }
        return classWrapper;
    }

    @Nonnull
    public Class<?> getClazz() {
        return this.c;
    }

    @Nullable
    Field a(final @Nonnull String string) {
        Field field = this.e.get(string);
        if (field != null) {
            return field;
        }
        for (DeclaredField declaredField : this.getDeclaredFields()) {
            Field field2 = declaredField.getField();
            this.e.put(declaredField.getName(), field2);
        }
        field = this.e.get(string);
        if (field != null) {
            return field;
        }
        return AccessController.doPrivileged(new PrivilegedAction<Field>(){

            public Field a() {
                for (Class<?> clazz = ClassWrapper.this.c; clazz != null; clazz = clazz.getSuperclass()) {
                    try {
                        Field field = clazz.getDeclaredField(string);
                        field.setAccessible(true);
                        ClassWrapper.this.e.put(string, field);
                        return field;
                    }
                    catch (NoSuchFieldException noSuchFieldException) {
                        continue;
                    }
                }
                return null;
            }

            @Override
            public /* synthetic */ Object run() {
                return this.a();
            }
        });
    }

    private void d() throws JsonException {
        if (this.c == Character.class || this.c == Character.TYPE) {
            this.h = 2;
        } else if (this.c == String.class) {
            this.h = 3;
        } else if (Enum.class.isAssignableFrom(this.c)) {
            this.h = 4;
        } else {
            try {
                this.i = this.c.getMethod("valueOf", String.class);
                this.h = (this.i.getModifiers() & 8) > 0 ? 1 : 3;
            }
            catch (Exception exception) {
                this.h = 3;
            }
        }
    }

    boolean a() {
        if (this.h == 0) {
            this.d();
        }
        return this.h == 1;
    }

    @Nullable
    Object a(String string, boolean bl) throws JsonException {
        switch (this.h) {
            default: {
                this.d();
                return this.a(string, bl);
            }
            case 1: {
                try {
                    return this.i.invoke(null, string);
                }
                catch (Exception exception) {
                    throw (JsonException)new JsonException("Value '" + string + "' can't convert to type: " + String.valueOf(this.c)).initCause(exception);
                }
            }
            case 2: {
                return Character.valueOf(string.charAt(0));
            }
            case 3: {
                if (bl) {
                    return string;
                }
                switch (string) {
                    case "false": {
                        return Boolean.FALSE;
                    }
                    case "true": {
                        return Boolean.TRUE;
                    }
                }
                try {
                    return Integer.valueOf(string);
                }
                catch (NumberFormatException numberFormatException) {
                    try {
                        return Long.valueOf(string);
                    }
                    catch (NumberFormatException numberFormatException2) {
                        try {
                            return Double.valueOf(string);
                        }
                        catch (NumberFormatException numberFormatException3) {
                            throw new JsonException("Value '" + string + "' can't convert to type: " + String.valueOf(this.c));
                        }
                    }
                }
            }
            case 4: 
        }
        return Enum.valueOf(this.c, string);
    }

    @Nonnull
    Object b() throws JsonException {
        try {
            if (this.f == null) {
                try {
                    return AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                        @Override
                        public Object run() throws Exception {
                            Constructor<?> constructor = ClassWrapper.this.c.getDeclaredConstructor(new Class[0]);
                            constructor.setAccessible(true);
                            Object obj = constructor.newInstance(new Object[0]);
                            ClassWrapper.this.f = constructor;
                            return obj;
                        }
                    });
                }
                catch (Exception exception) {
                    if (this.c.isAssignableFrom(ArrayList.class)) {
                        this.f = ArrayList.class.getConstructor(new Class[0]);
                    }
                    if (this.c.isAssignableFrom(Set.class)) {
                        this.f = HashSet.class.getConstructor(new Class[0]);
                    }
                    if (this.c.isAssignableFrom(Map.class)) {
                        this.f = HashMap.class.getConstructor(new Class[0]);
                    }
                    throw exception;
                }
            }
            return this.f.newInstance(new Object[0]);
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw JsonException.create(privilegedActionException.getCause());
        }
        catch (Exception exception) {
            throw JsonException.create(exception);
        }
    }

    @Nonnull
    Object a(final int n2) throws JsonException {
        try {
            if (this.g == null) {
                try {
                    return AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                        @Override
                        public Object run() throws Exception {
                            Constructor<?> constructor = ClassWrapper.this.c.getDeclaredConstructor(Integer.TYPE);
                            constructor.setAccessible(true);
                            Object obj = constructor.newInstance(n2);
                            ClassWrapper.this.g = constructor;
                            return obj;
                        }
                    });
                }
                catch (Exception exception) {
                    if (this.c.isAssignableFrom(ArrayList.class)) {
                        this.g = ArrayList.class.getConstructor(Integer.TYPE);
                    } else if (this.c.isAssignableFrom(Set.class)) {
                        this.g = HashSet.class.getConstructor(Integer.TYPE);
                    } else if (this.c.isAssignableFrom(Map.class)) {
                        this.g = HashMap.class.getConstructor(Integer.TYPE);
                    } else {
                        throw exception;
                    }
                    this.g.setAccessible(true);
                }
            }
            return this.g.newInstance(n2);
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw JsonException.create(privilegedActionException.getCause());
        }
        catch (Exception exception) {
            throw JsonException.create(exception);
        }
    }

    @Nonnull
    private Class<?> a(@Nonnull Type type) {
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            return (Class)parameterizedType.getRawType();
        }
        if (type instanceof GenericArrayType) {
            GenericArrayType genericArrayType = (GenericArrayType)type;
            type = genericArrayType.getGenericComponentType();
            return Array.newInstance(this.a(type), 0).getClass();
        }
        return (Class)type;
    }

    @Nonnull
    public DeclaredField[] getDeclaredFields() {
        if (this.k == null) {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    DeclaredField[] declaredFieldArray;
                    String string = ClassWrapper.this.c.getName();
                    if (DebugUtils.DEBUG && string.startsWith("com.inet.") && ClassWrapper.this.c.getDeclaredAnnotation(JsonData.class) == null) {
                        throw new JsonException(String.valueOf(ClassWrapper.this.c) + " has no JsonData annotation");
                    }
                    Field[] fieldArray = null;
                    try {
                        Method method = ClassWrapper.this.c.getMethod("getDeclaredFields", new Class[0]);
                        fieldArray = (Field[])method.invoke(null, new Object[0]);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    if (fieldArray == null) {
                        fieldArray = ClassWrapper.this.c.getDeclaredFields();
                    }
                    for (int i2 = 0; i2 < fieldArray.length; ++i2) {
                        boolean bl;
                        block12: {
                            Field field = fieldArray[i2];
                            boolean bl2 = bl = (field.getModifiers() & 0x88) > 0;
                            if (!bl) {
                                try {
                                    field.setAccessible(true);
                                }
                                catch (RuntimeException runtimeException) {
                                    bl = true;
                                    if (!DebugUtils.DEBUG) break block12;
                                    throw runtimeException;
                                }
                            }
                        }
                        if (!bl) continue;
                        Field[] fieldArray2 = Arrays.copyOf(fieldArray, fieldArray.length - 1);
                        System.arraycopy(fieldArray, i2 + 1, fieldArray2, i2, fieldArray2.length - i2);
                        fieldArray = fieldArray2;
                        --i2;
                    }
                    DeclaredField[] declaredFieldArray2 = new DeclaredField[fieldArray.length];
                    for (int i3 = 0; i3 < fieldArray.length; ++i3) {
                        Field field = fieldArray[i3];
                        declaredFieldArray2[i3] = new DeclaredField(field);
                    }
                    Class<?> clazz = ClassWrapper.this.c.getSuperclass();
                    if (clazz != null && (declaredFieldArray = ClassWrapper.getWrapper(clazz, null).getDeclaredFields()).length > 0) {
                        int n2 = declaredFieldArray.length;
                        declaredFieldArray = Arrays.copyOf(declaredFieldArray, n2 + declaredFieldArray2.length);
                        System.arraycopy(declaredFieldArray2, 0, declaredFieldArray, n2, declaredFieldArray2.length);
                        declaredFieldArray2 = declaredFieldArray;
                    }
                    if (DebugUtils.DEBUG && fieldArray.length > 0) {
                        HashSet<String> hashSet = new HashSet<String>();
                        for (Field field : fieldArray) {
                            if (hashSet.add(field.getName())) continue;
                            throw new JsonException(String.valueOf(ClassWrapper.this.c) + " has a duplicate field: " + field.getName());
                        }
                    }
                    ClassWrapper.this.k = declaredFieldArray2;
                    return null;
                }
            });
        }
        return this.k;
    }

    public int getJsonType() {
        if (this.l == 0) {
            this.l = Boolean.class == this.c || Boolean.TYPE == this.c ? 9 : (Byte.class == this.c || Byte.TYPE == this.c ? 10 : (Short.class == this.c || Short.TYPE == this.c ? 11 : (Integer.class == this.c || Integer.TYPE == this.c ? 12 : (Long.class == this.c || Long.TYPE == this.c ? 13 : (Float.class == this.c || Float.TYPE == this.c ? 14 : (Double.class == this.c || Double.TYPE == this.c ? 15 : (Number.class.isAssignableFrom(this.c) ? 1 : (Collection.class.isAssignableFrom(this.c) ? 3 : (Map.class.isAssignableFrom(this.c) ? 4 : (String.class == this.c ? 2 : (Character.class == this.c || Character.TYPE == this.c ? 16 : (byte[].class == this.c ? 17 : (this.c.isArray() ? 5 : (Enum.class.isAssignableFrom(this.c) ? 6 : (Date.class == this.c ? 8 : (this.a() ? 2 : (CharSequence.class.isAssignableFrom(this.c) ? 2 : 7)))))))))))))))));
        }
        return this.l;
    }

    public @Nonnull Type @Nullable [] getTypeArguments() {
        if (this.m == null) {
            Type[] typeArray;
            if (this.d instanceof ParameterizedType) {
                typeArray = ((ParameterizedType)this.d).getActualTypeArguments();
                try {
                    for (Type type : typeArray) {
                        ClassWrapper.getWrapper(type, null);
                    }
                }
                catch (Exception exception) {
                    typeArray = b;
                }
            } else {
                Type type = this.c.getGenericSuperclass();
                if (type != null) {
                    ClassWrapper classWrapper = ClassWrapper.getWrapper(type, null);
                    typeArray = classWrapper.getTypeArguments();
                    if (typeArray == null) {
                        typeArray = b;
                    }
                } else {
                    typeArray = b;
                }
            }
            this.m = typeArray;
        }
        if (this.m.length == 0) {
            return null;
        }
        return this.m;
    }

    boolean c() {
        return this.j != null;
    }

    void a(@Nullable JsonSubTypeResolver<?> jsonSubTypeResolver) {
        this.j = jsonSubTypeResolver;
    }

    @Nonnull
    Type a(Map<String, Object> map, HashMap<String, Object> hashMap) throws JsonException {
        Class<?> clazz = this.j.getTypeFor(map, hashMap);
        return clazz == null ? Void.class : clazz;
    }
}

