/*
 * Decompiled with CFR 0.152.
 */
package com.inet.http.websocket;

import com.inet.annotations.InternalApi;
import com.inet.authentication.base.LoginManager;
import com.inet.http.ExpandableServletRequestListener;
import com.inet.http.PluginServlet;
import com.inet.http.servlet.ClientLocale;
import com.inet.http.servlet.ClientTimezone;
import com.inet.http.servlet.NopHttpServletResponse;
import com.inet.http.servlet.SessionStore;
import com.inet.http.websocket.PingWebSocketEvent;
import com.inet.http.websocket.WebSocketEvent;
import com.inet.http.websocket.WebSocketEventData;
import com.inet.http.websocket.WebSocketEventDataList;
import com.inet.http.websocket.WebSocketEventHandler;
import com.inet.http.websocket.WebsocketConnection;
import com.inet.lib.io.UTF8StreamReader;
import com.inet.lib.json.EncodedWriter;
import com.inet.lib.json.Json;
import com.inet.lib.util.LocaleUtils;
import com.inet.lib.util.StringFunctions;
import com.inet.logging.LogManager;
import com.inet.logging.Logger;
import com.inet.plugin.DynamicExtensionManager;
import com.inet.plugin.ServerPluginManager;
import com.inet.shared.servlet.ProxyHttpServletRequest;
import com.inet.shared.servlet.ServletUtils;
import com.inet.thread.SessionLocal;
import jakarta.servlet.Filter;
import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequestEvent;
import jakarta.servlet.ServletRequestListener;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Objects;
import java.util.TimeZone;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.SuppressFBWarnings;

@InternalApi
public class WebSocketServlet
implements PluginServlet,
ServletRequestListener {
    public static final String REMOTE_ADDR = "RemoteAddr";
    public static final String WS_CONNECTION_BASE_URL = "WSConnectionBaseURL";
    public static final String USER_AGENT = "user-agent";
    public static final String CURRENT_LOCALE = "currentlocale";
    public static final Logger LOGGER = LogManager.getLogger("Webserver");
    private static final long SERVER_STARTTIME = System.currentTimeMillis();
    public static final WebSocketServlet INSTANCE;
    protected WebSocketEventHandler eventHandler;
    private int a = -1;

    WebSocketServlet(WebSocketEventHandler eventHandler) {
        this.eventHandler = eventHandler;
    }

    public void register(ServerPluginManager spm) {
        DynamicExtensionManager.getInstance().register(Filter.class, ExpandableServletRequestListener.BLOCK_FILTER);
        spm.register(PluginServlet.class, this);
        spm.register(ServletRequestListener.class, this);
        spm.register(WebSocketEvent.class, new PingWebSocketEvent());
    }

    @Override
    public void init(ServletConfig config) throws ServletException {
    }

    @SuppressFBWarnings(value={"TRUST_BOUNDARY_VIOLATION"}, justification="data was validated for saving")
    public void requestInitialized(ServletRequestEvent event) {
        String string;
        String string2;
        HttpServletRequest httpServletRequest = (HttpServletRequest)event.getServletRequest();
        if (this.a < 0) {
            this.a = ServletUtils.getContextPathLength(httpServletRequest);
        }
        if (!(string2 = httpServletRequest.getRequestURI().substring(this.a)).startsWith(this.getPathSpec()) && !string2.startsWith("/public" + this.getPathSpec())) {
            return;
        }
        HttpSession httpSession = httpServletRequest.getSession();
        String string3 = httpServletRequest.getParameter(CURRENT_LOCALE);
        Locale locale = null;
        if (string3 != null && !string3.isEmpty()) {
            locale = LocaleUtils.valueOf(string3);
        }
        if (locale != null) {
            ClientLocale.setThreadLocale(locale);
        } else {
            ClientLocale.setThreadLocale(httpServletRequest);
        }
        httpSession.setAttribute(Locale.class.getName(), (Object)ClientLocale.getThreadLocale());
        if (httpServletRequest.getHeader("timezone") != null || !StringFunctions.isEmpty(httpServletRequest.getParameter("timezone"))) {
            ClientTimezone.setTimeZone(httpServletRequest);
            httpSession.setAttribute(TimeZone.class.getName(), (Object)ClientTimezone.getTimeZone());
        }
        if ((string = httpServletRequest.getHeader("X-Forwarded-For")) == null) {
            string = httpServletRequest.getRemoteAddr();
        }
        httpSession.setAttribute(REMOTE_ADDR, (Object)string);
        httpSession.setAttribute(USER_AGENT, (Object)httpServletRequest.getHeader(USER_AGENT));
        ProxyHttpServletRequest proxyHttpServletRequest = ProxyHttpServletRequest.wrapRequestIfNeeded(httpServletRequest);
        String string4 = String.valueOf(ProxyHttpServletRequest.getHttpServerPort((HttpServletRequest)proxyHttpServletRequest)) + proxyHttpServletRequest.getContextPath() + "/";
        httpSession.setAttribute(WS_CONNECTION_BASE_URL, (Object)string4);
        LoginManager.initHttpRequest(httpServletRequest, new NopHttpServletResponse());
    }

    public void requestDestroyed(ServletRequestEvent event) {
        SessionStore.reset();
        SessionLocal.allRemoveThreadFromSession();
    }

    @Override
    @Nonnull
    public String getPathSpec() {
        return this.eventHandler.getPath();
    }

    @Override
    public void destroy() {
    }

    @Override
    @SuppressFBWarnings(value={"TRUST_BOUNDARY_VIOLATION"}, justification="data was validated for saving")
    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        ClientLocale.setThreadLocale(request);
        ClientTimezone.setTimeZone(request);
        request.getSession().setAttribute(Locale.class.getName(), (Object)ClientLocale.getThreadLocale());
        request.getSession().setAttribute(TimeZone.class.getName(), (Object)ClientTimezone.getTimeZone());
        response.setHeader("X-Server-Start", String.valueOf(SERVER_STARTTIME));
        String string = request.getPathInfo();
        if (string != null) {
            String[] stringArray;
            if (string.indexOf(47) == 0) {
                string = string.substring(1);
            }
            if ((stringArray = string.split("/")).length == 2) {
                String string2 = stringArray[0];
                String string3 = stringArray[1];
                WebsocketConnection websocketConnection = this.eventHandler.getConnection(string2);
                switch (string3) {
                    case "polling_getevents": {
                        this.a(request, response, websocketConnection);
                        return;
                    }
                    case "polling_sendevent": {
                        if (websocketConnection == null) {
                            websocketConnection = new WebsocketConnection(request.getSession(true), string2);
                            this.eventHandler.connectionOpened(string2, websocketConnection);
                        }
                        this.eventHandler.handleEvent(new UTF8StreamReader((InputStream)request.getInputStream()), websocketConnection);
                        this.a(request, response, websocketConnection);
                        return;
                    }
                }
                String string4 = "<html><head><title>No handler for event '" + string3 + "'</title></head>\n<body><h1>500 No handler for event '" + string3 + "'</h1></body></html>";
                try {
                    response.setContentType("text/html");
                    response.setStatus(500);
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
                response.getOutputStream().write(string4.getBytes(StandardCharsets.UTF_8));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, @Nullable WebsocketConnection websocketConnection) throws IOException {
        Object object;
        ArrayList<WebSocketEventData> arrayList;
        httpServletResponse.setContentType("application/binary-json");
        ArrayList<WebSocketEventData> arrayList2 = new ArrayList<WebSocketEventData>();
        ArrayList<WebSocketEventData> arrayList3 = arrayList = websocketConnection != null ? websocketConnection.a() : null;
        if (websocketConnection != null && arrayList != null && !arrayList.isEmpty() && this.a(websocketConnection, httpServletRequest)) {
            object = arrayList;
            synchronized (object) {
                arrayList2.addAll(arrayList);
                arrayList.clear();
            }
        }
        object = new EncodedWriter((OutputStream)httpServletResponse.getOutputStream());
        new Json().toJson((Object)new WebSocketEventDataList(arrayList2), (Appendable)object);
    }

    private boolean a(WebsocketConnection websocketConnection, HttpServletRequest httpServletRequest) {
        if (websocketConnection == null) {
            return false;
        }
        return Objects.equals(websocketConnection.getActiveHttpSession(), httpServletRequest.getSession(false));
    }

    static {
        WebSocketEventHandler webSocketEventHandler = WebSocketEventHandler.getInstance();
        INSTANCE = new WebSocketServlet(webSocketEventHandler);
    }
}

