/*
 * Decompiled with CFR 0.152.
 */
package com.inet.config;

import com.inet.annotations.InternalApi;
import com.inet.config.ConfigurationManager;
import com.inet.lib.core.OS;
import com.inet.lib.util.NetworkFunctions;
import com.inet.lib.util.PreferencesUtils;
import com.inet.persistence.Persistence;
import java.security.AccessController;

@InternalApi
public class ConfigurationUtils {
    public static final String PREF_NODE_PATH = "/com/inet/report/config/cc";

    private ConfigurationUtils() {
    }

    static String a(int n2, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(ConfigurationManager.getScopeName(n2));
        stringBuffer.append("::");
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    public static void stop() {
        ConfigurationManager.a();
    }

    public static int getDefaultConfigScope(String configName) {
        boolean bl = false;
        if (OS.isWindows()) {
            try {
                String string = AccessController.doPrivileged(() -> System.getProperty("user.name")).toUpperCase();
                if (string.endsWith("$") && string.startsWith(NetworkFunctions.getLocalHostName().toUpperCase())) {
                    bl = true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!bl && Persistence.isFilePersistence()) {
            try {
                if (PreferencesUtils.isUserWriteable(PREF_NODE_PATH) && PreferencesUtils.userRoot().node(PREF_NODE_PATH).nodeExists(configName)) {
                    return 2;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (PreferencesUtils.isSystemWriteable(PREF_NODE_PATH)) {
            return 1;
        }
        if (!bl) {
            try {
                if (PreferencesUtils.isUserWriteable(PREF_NODE_PATH)) {
                    return 2;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return 4;
    }
}

