/*
 * Decompiled with CFR 0.152.
 */
package com.inet.config;

import com.inet.annotations.InternalApi;
import com.inet.annotations.JsonData;
import com.inet.config.ConfigKey;
import com.inet.config.ConfigValue;
import com.inet.config.ConfigurationManager;
import com.inet.config.LicenseInfo;
import com.inet.config.LicenseInfoHolder;
import com.inet.config.LicenseManager;
import com.inet.config.internal.LicenseTokenTimerTask;
import com.inet.config.internal.PrivateCloudLicenseTimerTask;
import com.inet.config.structure.core.CoreSystemStructureProvider;
import com.inet.id.GUID;
import com.inet.lib.io.FastByteArrayOutputStream;
import com.inet.lib.json.Json;
import com.inet.lib.util.IOFunctions;
import com.inet.lib.util.NetworkFunctions;
import com.inet.lib.util.StringFunctions;
import com.inet.lib.util.TimeServer;
import com.inet.logging.LogManager;
import com.inet.notification.Notification;
import com.inet.notification.NotificationGenerator;
import com.inet.notification.NotificationManager;
import com.inet.notification.PermissionNotificationGenerator;
import com.inet.notification.TimedGenerator;
import com.inet.notification.Times;
import com.inet.persistence.Persistence;
import com.inet.plugin.ApplicationDescription;
import com.inet.plugin.ServerPluginManager;
import com.inet.shared.utils.Version;
import com.inet.thread.timer.DefaultTimer;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.URL;
import java.net.URLConnection;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.interfaces.RSAKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.SuppressFBWarnings;
import javax.crypto.Cipher;

@InternalApi
public final class ConfigKeyParser {
    private static final ReentrantLock a = new ReentrantLock();
    private static final byte[] b = new byte[]{48, -126, 2, 117, 2, 1, 0, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 1, 5, 0, 4, -126, 2, 95, 48, -126, 2, 91, 2, 1, 0, 2, -127, -127, 0, -76, -25, 28, 113, -54, -13, 26, 110, -84, -111, -115, 119, 57, 83, -64, 61, -72, -17, 79, 25, 34, -45, 86, -105, 88, -31, 110, 36, 60, -51, 60, -124, 72, -22, 48, -94, 65, -18, 31, -42, 84, 111, 22, -17, -20, -37, 68, 87, -124, 105, -65, 61, 74, 43, -8, -55, -121, -107, 102, 9, 64, -5, -54, -73, 72, -71, -55, 33, -16, -24, 99, 5, 30, -119, 35, -67, 80, -125, -14, -3, 22, -75, 115, 30, 17, 13, 102, -117, -125, -27, -5, 38, 69, -62, 7, 61, 83, 72, -74, -101, 33, -125, 87, -94, 47, -4, 34, 83, -66, 34, -57, 5, -56, 119, 109, -73, 38, -63, -102, -51, -104, 91, 6, -91, 62, 73, -115, -119, 2, 3, 1, 0, 1, 2, -127, -128, 74, 74, -121, 17, -20, 72, -67, -40, 41, -94, 116, -72, 59, -96, -69, 88, 29, -76, -103, -123, 55, 26, 23, 123, 124, 18, -56, 10, -75, -75, -117, 94, -64, 26, -4, -14, 5, -91, 103, 9, -68, 15, 11, 26, 104, -24, -5, 61, -3, -80, -9, -54, -111, -59, 81, 28, 98, 67, -26, 109, 114, 116, 117, 32, -16, -71, 66, 103, 88, 47, -73, -25, -65, -4, 30, 28, 71, -117, -24, -5, 69, -92, -93, -9, -82, -8, 103, -13, 117, -94, -98, 40, 30, 123, 47, 4, 22, -94, -98, -69, 85, 30, -90, -117, 73, -114, -4, -2, -122, 72, -50, 64, 63, -100, 108, 58, -36, -73, -112, -85, 92, -82, 46, 113, -109, 4, 11, -95, 2, 65, 0, -1, 28, -86, 124, -29, -9, 63, 45, 31, -59, -115, 17, 9, 85, -8, -103, 57, 46, -84, -77, 126, 101, -37, 45, 24, -47, -41, -29, 44, 108, 86, -97, -36, -56, 65, 45, 93, -112, 77, -2, -75, 122, -23, -118, 74, 39, 17, -98, -39, -16, 106, -114, 10, 70, 49, 72, -21, -56, -86, 49, -126, 89, -48, 85, 2, 65, 0, -75, -120, 80, -12, -49, -118, -10, -81, -42, 101, -76, -41, 45, -18, -4, 110, -13, 59, -79, 90, -87, 6, 123, 114, -121, -75, 88, 104, 43, 120, -122, -35, -124, -66, 98, -21, 87, 97, -48, -91, 4, -70, 49, 46, -96, -113, -46, 39, -39, -41, -89, -101, 101, 81, -73, -25, -49, -30, 63, -41, -51, -100, -20, 101, 2, 64, 71, 5, 110, -3, 39, -27, -36, 67, -82, -75, -85, -87, 19, -123, 72, -103, 55, -113, 35, -21, 48, -124, 32, -71, 116, 80, 111, 30, -62, 110, 66, -53, 108, -122, -97, -122, -122, -90, -74, -33, -13, 28, 13, -54, 63, 12, -109, 94, 58, -28, 48, 117, -20, -84, 79, -22, 50, 34, 2, 39, -104, 87, 114, -91, 2, 64, 9, -86, -62, -76, -26, -64, 125, -74, -117, 114, 75, 25, 18, 103, 33, -90, 62, -23, -76, -34, 33, 22, 41, 72, -58, 21, 80, 41, -21, -10, -75, 39, -30, -61, -56, -68, -61, -96, 127, -35, -23, -52, -120, -123, -11, 34, -13, -116, 15, -69, -66, 63, 54, 60, 13, -47, 24, 110, -15, -5, 106, 5, -85, 73, 2, 64, 20, -22, 92, -73, -90, 23, 79, -59, 78, -48, 102, -37, -82, -18, -56, -31, 121, -62, 45, -39, -109, -121, -47, 33, -37, -30, 2, 1, 0, -44, -86, 48, 42, 9, 59, -101, -60, -3, 112, 47, 14, 122, -30, 9, -17, 86, 53, 1, -126, -67, -46, 97, -102, -10, 117, 15, -15, 57, 55, 15, -54, 12, -123, 29};
    private static final String ERROR = new String(new byte[]{101, 114, 114, 111, 114});
    private static final String INVALID = new String(new byte[]{73, 110, 118, 97, 108, 105, 100, 32, 107, 101, 121, 58, 32});
    private static final String EXPIRES = new String(new byte[]{101, 120, 112, 105, 114, 101, 115});
    private static final String EXPIRES_MSG = new String(new byte[]{84, 104, 101, 32, 108, 105, 99, 101, 110, 115, 101, 32, 104, 97, 115, 32, 101, 120, 112, 105, 114, 101, 100, 32, 111, 110, 32});
    private static final String VERSION = new String(new byte[]{118, 101, 114, 115, 105, 111, 110});
    private static final String VERSION_MSG = new String(new byte[]{76, 105, 99, 101, 110, 115, 101, 32, 102, 111, 114, 32, 111, 108, 100, 32, 118, 101, 114, 115, 105, 111, 110, 58, 32});
    private static final String IP = new String(new byte[]{105, 112});
    private static final String NO_IP_MSG = new String(new byte[]{78, 111, 32, 73, 80, 118, 52, 32, 97, 100, 100, 114, 101, 115, 115, 32, 102, 111, 117, 110, 100, 32, 102, 111, 114, 32, 116, 104, 105, 115, 32, 115, 121, 115, 116, 101, 109, 32, 100, 117, 114, 105, 110, 103, 32, 108, 105, 99, 101, 110, 115, 101, 32, 99, 104, 101, 99, 107, 46});
    private static final String WRONG_IP_MSG = new String(new byte[]{84, 104, 101, 32, 117, 115, 101, 100, 32, 108, 105, 99, 101, 110, 115, 101, 32, 105, 115, 32, 110, 111, 116, 32, 118, 97, 108, 105, 100, 32, 102, 111, 114, 32, 116, 104, 101, 32, 97, 118, 97, 105, 108, 97, 98, 108, 101, 32, 73, 80, 32, 97, 100, 100, 114, 101, 115, 115, 40, 101, 115, 41, 46, 32, 73, 116, 32, 105, 115, 32, 102, 111, 114, 32, 97, 100, 100, 114, 101, 115, 115, 58, 32});
    private static final String APP_MSG = new String(new byte[]{76, 105, 99, 101, 110, 115, 101, 32, 102, 111, 114, 32, 97, 110, 111, 116, 104, 101, 114, 32, 97, 112, 112, 108, 105, 99, 97, 116, 105, 111, 110, 58, 32});
    private static final String DOMAIN = new String(new byte[]{100, 111, 109, 97, 105, 110});
    private static final String FQDN = new String(new byte[]{102, 113, 100, 110});
    private static final String CLOUDHOST = new String(new byte[]{99, 108, 111, 117, 100, 104, 111, 115, 116});
    private static final String NODE_COUNT = new String(new byte[]{110, 111, 100, 101, 99, 111, 117, 110, 116});
    private static final String WRONG_DOMAIN = new String(new byte[]{84, 104, 101, 32, 117, 115, 101, 100, 32, 108, 105, 99, 101, 110, 115, 101, 32, 105, 115, 32, 110, 111, 116, 32, 118, 97, 108, 105, 100, 32, 102, 111, 114, 32, 116, 104, 101, 32, 97, 118, 97, 105, 108, 97, 98, 108, 101, 32, 100, 111, 109, 97, 105, 110, 46, 32, 73, 116, 32, 105, 115, 32, 102, 111, 114, 32, 116, 104, 101, 32, 100, 111, 109, 97, 105, 110, 58, 32});
    private static final String WRONG_DOMAIN2 = new String(new byte[]{87, 104, 105, 99, 104, 32, 100, 111, 101, 115, 32, 110, 111, 116, 32, 109, 97, 116, 99, 104, 32, 97, 110, 121, 32, 111, 102, 32, 116, 104, 101, 32, 102, 111, 108, 108, 111, 119, 105, 110, 103, 32, 104, 111, 115, 116, 110, 97, 109, 101, 115, 58, 32});
    private static String c;
    private static List<LicenseInfo> d;
    private static LicenseInfoHolder e;
    private static long f;
    private static HashMap<String, String> g;
    private static boolean h;
    private static NotificationGenerator i;
    private static final ConfigValue<String> j;
    private static final ConfigValue<Map<String, String>> k;
    private static final ConfigValue<String> l;

    @SuppressFBWarnings(value={"HARD_CODE_KEY"}, justification="This is a well known public key")
    public final Map<String, String> decodeLicenseToken(String base64Key) {
        Object object;
        Object object2;
        Exception exception;
        HashMap hashMap;
        block19: {
            hashMap = null;
            exception = null;
            try {
                Provider[] providerArray;
                object2 = Base64.getMimeDecoder().decode(base64Key);
                if (((byte[])object2).length == 0) {
                    hashMap = new HashMap();
                    hashMap.put(ERROR, () -> INVALID + base64Key);
                    break block19;
                }
                object = KeyFactory.getInstance("RSA");
                for (Provider provider : providerArray = Security.getProviders("Cipher.RSA")) {
                    Object object3;
                    try {
                        if (provider.getClass().getName().startsWith("org.bouncycastle.")) continue;
                        PrivateKey privateKey = ((KeyFactory)object).generatePrivate(new PKCS8EncodedKeySpec(b));
                        object3 = Cipher.getInstance(privateKey.getAlgorithm(), provider);
                        ((Cipher)object3).init(2, privateKey);
                        int n2 = ((RSAKey)((Object)privateKey)).getModulus().bitLength() / 8;
                        FastByteArrayOutputStream fastByteArrayOutputStream = new FastByteArrayOutputStream(128);
                        for (int i2 = 0; i2 < ((byte[])object2).length; i2 += n2) {
                            byte[] byArray = ((Cipher)object3).doFinal((byte[])object2, i2, Math.min(((byte[])object2).length - i2, n2));
                            fastByteArrayOutputStream.write(byArray);
                        }
                        hashMap = new Json().fromJson(fastByteArrayOutputStream.toByteArray(), HashMap.class);
                        Object v = hashMap.get(ERROR);
                        if (v instanceof String) {
                            hashMap.put(ERROR, () -> (String)v);
                        }
                        break;
                    }
                    catch (Exception exception2) {
                        if (hashMap != null) {
                            object3 = (Supplier)hashMap.get(ERROR);
                            String string = object3 == null ? INVALID + StringFunctions.getUserFriendlyErrorMessage(exception2) : (String)object3.get() + "\n" + StringFunctions.getUserFriendlyErrorMessage(exception2);
                            hashMap.put(ERROR, () -> string);
                        }
                        if (exception == null) {
                            exception = exception2;
                            continue;
                        }
                        exception.addSuppressed(exception2);
                    }
                }
            }
            catch (Exception exception3) {
                exception = exception3;
            }
        }
        if (hashMap == null) {
            hashMap = new HashMap();
            if (exception != null) {
                if (base64Key.length() >= 30 && base64Key.charAt(6) == '-' && base64Key.charAt(11) == '-' && base64Key.charAt(18) == '-' && base64Key.charAt(25) == '-') {
                    object2 = VERSION_MSG + Character.digit(base64Key.charAt(19), 16);
                } else if (base64Key.length() < 30 && base64Key.indexOf(45) != base64Key.lastIndexOf(45)) {
                    try {
                        Integer.parseInt(base64Key.substring(0, base64Key.indexOf(45)));
                        Integer.parseInt(base64Key.substring(base64Key.indexOf(45) + 1, base64Key.lastIndexOf(45)));
                        Integer.parseInt(base64Key.substring(base64Key.lastIndexOf(45) + 1));
                        object2 = VERSION_MSG + "7.6";
                    }
                    catch (Throwable throwable) {
                        object2 = INVALID + StringFunctions.getUserFriendlyErrorMessage(exception);
                    }
                } else {
                    object2 = INVALID + StringFunctions.getUserFriendlyErrorMessage(exception);
                }
            } else {
                object2 = "No security provider available.";
            }
            object = object2;
            hashMap.put(ERROR, () -> ConfigKeyParser.l((String)object));
        }
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final List<Map<String, String>> a(String string) {
        byte[] byArray = b;
        synchronized (b) {
            Object object;
            ApplicationDescription applicationDescription = null;
            ArrayList<Map<String, String>> arrayList = new ArrayList<Map<String, String>>();
            StringTokenizer stringTokenizer = new StringTokenizer(string.trim(), ",");
            while (stringTokenizer.hasMoreTokens()) {
                object = stringTokenizer.nextToken().trim();
                Map<String, String> map = this.decodeLicenseToken((String)object);
                if (!map.containsKey(ERROR)) {
                    ConfigKeyParser.a(map);
                    ConfigKeyParser.b(map);
                    ConfigKeyParser.c(map);
                    ConfigKeyParser.d(map);
                    this.e(map);
                    if (applicationDescription == null) {
                        applicationDescription = ApplicationDescription.get();
                    }
                    ConfigKeyParser.a(map, applicationDescription);
                    ConfigKeyParser.b(map, applicationDescription);
                }
                map.put("key", (String)object);
                arrayList.add(map);
            }
            object = Collections.unmodifiableList(arrayList);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return object;
        }
    }

    public static void reset() {
        if (a.tryLock()) {
            ConfigKeyParser.a();
        } else {
            ForkJoinPool.commonPool().execute(() -> {
                a.lock();
                ConfigKeyParser.a();
            });
        }
    }

    private static void a() {
        e = null;
        f = 0L;
        a.unlock();
        if (ServerPluginManager.getInstance().getState() == ServerPluginManager.ServerPluginManagerState.INIT) {
            LicenseManager.getInstance().a();
        }
    }

    private static boolean b() {
        return f + 86400000L > System.currentTimeMillis() && i == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    @Nonnull
    final List<LicenseInfo> b(String string) {
        if (string == null) {
            string = "";
        }
        Object object = b;
        synchronized (b) {
            List<LicenseInfo> list;
            if (Objects.equals(c, string) && ConfigKeyParser.b()) {
                list = d;
                if (list != null) {
                    // ** MonitorExit[var3_2] (shouldn't be in output)
                    return list;
                }
            } else {
                c = string;
                d = null;
            }
            List<Map<String, String>> list2 = this.a(string);
            // ** MonitorExit[var3_2] (shouldn't be in output)
            object = null;
            list = new ArrayList<LicenseInfo>();
            for (Map<String, String> map : list2) {
                if (object == null) {
                    object = ApplicationDescription.get();
                }
                map = Collections.unmodifiableMap(map);
                list.add(object.validate(map));
            }
            Object object2 = b;
            synchronized (b) {
                list = Collections.unmodifiableList(list);
                if (Objects.equals(c, string)) {
                    d = list;
                }
                // ** MonitorExit[var5_6] (shouldn't be in output)
                return list;
            }
        }
    }

    public LicenseInfoHolder getLicenseInfo(@Nullable String licenseKeys) {
        List<LicenseInfo> list = new ConfigKeyParser().b(licenseKeys);
        return new LicenseInfoHolder(list, null);
    }

    @Nonnull
    private static LicenseInfoHolder c() {
        LicenseInfoHolder licenseInfoHolder;
        if (!ConfigKeyParser.b()) {
            e = null;
            if (i != null) {
                NotificationManager.getInstance().unregisterGenerator(i.getId());
                i = null;
            }
        }
        if ((licenseInfoHolder = e) != null) {
            return licenseInfoHolder;
        }
        a.lock();
        try {
            List<LicenseInfo> list = new ConfigKeyParser().b(j.get());
            e = licenseInfoHolder = new LicenseInfoHolder(list, ConfigurationManager.getInstance().getCurrent());
            f = System.currentTimeMillis();
        }
        finally {
            a.unlock();
        }
        PrivateCloudLicenseTimerTask.firstLicenseWasParsed();
        ExpiredNotificationGenerator.handle(licenseInfoHolder.getCurrent().getAttributes().get(EXPIRES));
        return licenseInfoHolder;
    }

    @Nonnull
    public static LicenseInfo getCurrent() {
        return ConfigKeyParser.c().getCurrent();
    }

    public static boolean hasValidLicenseFor(String feature) {
        return ConfigKeyParser.c().hasValidLicenseFor(feature);
    }

    @Nonnull
    public static List<LicenseInfo> getAll() {
        return ConfigKeyParser.c().getAll();
    }

    private static final void a(Map map) {
        String string = (String)map.get(EXPIRES);
        if (string != null) {
            long l2 = TimeServer.currentTimeMillis();
            if (Date.valueOf(string).before(new java.util.Date(l2 - 86400000L))) {
                map.put(ERROR, () -> EXPIRES_MSG + string);
            }
        }
    }

    private static final void a(Map map, ApplicationDescription applicationDescription) {
        String string = (String)map.get(VERSION);
        if (string != null && applicationDescription.getVersion().getMajor() > new Version(string).getMajor()) {
            map.put(ERROR, () -> VERSION_MSG + string);
        }
    }

    private static final void b(Map map) {
        String string = (String)map.get(IP);
        if (string != null) {
            try {
                InetAddress[] inetAddressArray = ConfigurationManager.getInstance().getAvailableIPAddresses();
                if (inetAddressArray.length == 0) {
                    map.put(ERROR, () -> NO_IP_MSG);
                    return;
                }
                InetAddress inetAddress = InetAddress.getByName(string);
                for (InetAddress inetAddress2 : inetAddressArray) {
                    if (!inetAddress.equals(inetAddress2)) continue;
                    return;
                }
                map.put(ERROR, () -> WRONG_IP_MSG + string);
            }
            catch (Exception exception) {
                LogManager.getConfigLogger().error(exception);
                map.put(ERROR, () -> StringFunctions.getUserFriendlyErrorMessage(exception));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final void c(Map map) {
        String string = (String)map.get(DOMAIN);
        if (string != null) {
            void var4_16;
            void var4_9;
            String string22;
            String[] stringArray;
            Object object3;
            Object object = object3 = (string = string.toLowerCase()).startsWith(".") ? string : "." + string;
            if (g == null) {
                g = new HashMap();
            }
            InetAddress[] inetAddressArray = g.values().iterator();
            while (inetAddressArray.hasNext()) {
                String object2 = inetAddressArray.next();
                if (!object2.endsWith((String)object3) && !object2.equals(string)) continue;
                return;
            }
            for (InetAddress inetAddress : inetAddressArray = ConfigurationManager.getInstance().getAvailableIPAddresses()) {
                String string3 = NetworkFunctions.getCanonicalHostName(inetAddress).toLowerCase();
                g.put(string3, string3);
                if (!string3.endsWith((String)object3) && !string3.equals(string)) continue;
                return;
            }
            String string4 = "";
            HashMap<String, String> hashMap = new HashMap<String, String>();
            int n2 = 0;
            for (String string5 : CoreSystemStructureProvider.HOST_SERVICES) {
                try {
                    String string6 = g.get(string5);
                    if (string6 == null) {
                        string6 = ConfigKeyParser.d(string5).toLowerCase();
                        g.put(string5, string6);
                        hashMap.put(string5, string6);
                    }
                    if (string6.endsWith((String)object3) || string6.equals(string)) {
                        return;
                    }
                    n2 = 1;
                }
                catch (Throwable throwable) {
                    void var4_7;
                    String string7 = (String)var4_7 + "\n - " + StringFunctions.getUserFriendlyErrorMessage(throwable);
                }
            }
            for (String string22 : stringArray = new String[]{"https://icanhazip.com/"}) {
                try {
                    String string8 = g.get(string22);
                    if (string8 == null) {
                        string8 = ConfigKeyParser.d(string22);
                        hashMap.put(string8, string8);
                        string8 = NetworkFunctions.getCanonicalHostName(string8).toLowerCase();
                        g.put(string22, string8);
                        hashMap.put(string22, string8);
                    }
                    if (string8.endsWith((String)object3) || string8.equals(string)) {
                        return;
                    }
                    n2 = 1;
                }
                catch (Throwable throwable) {
                    String string9 = (String)var4_9 + "\n - " + StringFunctions.getUserFriendlyErrorMessage(throwable);
                }
            }
            for (String string10 : NetworkFunctions.getDnsServers()) {
                string10 = string10.toLowerCase();
                g.put(string10, string10);
                if (!string10.endsWith((String)object3) && !string10.equals(string)) continue;
                return;
            }
            try {
                String string11 = InetAddress.getByName(string).getHostAddress();
                for (String string12 : hashMap.values()) {
                    if (!string12.equals(string11)) continue;
                    g.put(string, string);
                    return;
                }
                for (String string13 : hashMap.values()) {
                    string22 = InetAddress.getByName(string13).getHostAddress();
                    if (!string22.equals(string11)) continue;
                    g.put(string, string);
                    return;
                }
            }
            catch (Throwable throwable) {
                String string14 = (String)var4_9 + "\n - " + StringFunctions.getUserFriendlyErrorMessage(throwable);
            }
            String string15 = l.get();
            if (!string15.trim().isEmpty()) {
                void var4_12;
                try {
                    URL uRL = new URL(string15);
                    String string16 = PrivateCloudLicenseTimerTask.externalUrlAssignable(uRL);
                    if (string16 == null) {
                        string22 = uRL.getHost().toLowerCase();
                        g.put(string22, string22);
                        if (string22.endsWith((String)object3) || string22.equals(string)) {
                            return;
                        }
                    } else {
                        String string17 = (String)var4_12 + "\n - " + string16;
                    }
                }
                catch (Throwable throwable) {
                    String string18 = (String)var4_12 + "\n - " + StringFunctions.getUserFriendlyErrorMessage(throwable);
                }
            }
            if (n2 == 0 && i == null) {
                void var9_40 = var4_16;
                PermissionNotificationGenerator permissionNotificationGenerator = new PermissionNotificationGenerator((String)var9_40){
                    private String b = Long.toString(System.currentTimeMillis());
                    final /* synthetic */ String a;
                    {
                        this.a = string;
                    }

                    @Override
                    public GUID getId() {
                        return GUID.valueOf("eivpw49tiz6xh3l6snnp4noau");
                    }

                    @Override
                    public String getPeriodKey() {
                        return this.b;
                    }

                    @Override
                    public Notification createNotification() {
                        return new Notification(NotificationManager.I18N.getMsg("license.msg.title", new Object[0]), NotificationManager.I18N.getMsg("license.msg.network", this.a));
                    }
                };
                NotificationManager.getInstance().registerGenerator(permissionNotificationGenerator);
                i = permissionNotificationGenerator;
            }
            LogManager.getConfigLogger().debug(var4_16);
            String string19 = WRONG_DOMAIN + string + "\n" + WRONG_DOMAIN2 + new HashSet<String>(g.values()).toString();
            map.put(ERROR, () -> string9);
        }
    }

    @Nonnull
    public static Set<String> getKnownFQDNs() {
        Cloneable cloneable;
        if (g == null || !h) {
            h = true;
            cloneable = new HashMap();
            ((HashMap)cloneable).put(DOMAIN, ".");
            ConfigKeyParser.c((Map)((Object)cloneable));
        }
        cloneable = new HashSet();
        for (String string : g.values()) {
            if (ConfigKeyParser.c(string)) continue;
            ((HashSet)cloneable).add(string);
        }
        return cloneable;
    }

    private static boolean c(String string) {
        String[] stringArray = string.split("\\.");
        if (stringArray.length != 4) {
            return false;
        }
        for (String string2 : stringArray) {
            if (string2.length() > 3) {
                return false;
            }
            try {
                Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void d(Map map) {
        block30: {
            Object object;
            String string;
            Object object2;
            block28: {
                block29: {
                    block26: {
                        block27: {
                            long l2;
                            String string2;
                            block24: {
                                block25: {
                                    block22: {
                                        block23: {
                                            Map<String, String> map2;
                                            block20: {
                                                block21: {
                                                    block18: {
                                                        block19: {
                                                            String string3;
                                                            block16: {
                                                                block17: {
                                                                    block14: {
                                                                        block15: {
                                                                            object2 = null;
                                                                            string = (String)map.get(FQDN);
                                                                            object = (String)map.get(NODE_COUNT);
                                                                            if (string != null && object != null) break block14;
                                                                            if (object2 == null) break block15;
                                                                            String string4 = object2;
                                                                            map.put(ERROR, () -> string4);
                                                                            long l3 = ServerPluginManager.getInstance().getState() == ServerPluginManager.ServerPluginManagerState.INIT ? 0L : 10000L;
                                                                            DefaultTimer.getInstance().schedule(new LicenseTokenTimerTask(string), l3, 60000L);
                                                                        }
                                                                        return;
                                                                    }
                                                                    string3 = k.get().get(string);
                                                                    if (string3 != null) break block16;
                                                                    object2 = "Hostname '" + string + "' of the license was not validated. Is the server with the hostname '" + string + "' accessible over the internet via HTTP?";
                                                                    if (object2 == null) break block17;
                                                                    Object object3 = object2;
                                                                    map.put(ERROR, () -> ConfigKeyParser.g((String)object3));
                                                                    long l4 = ServerPluginManager.getInstance().getState() == ServerPluginManager.ServerPluginManagerState.INIT ? 0L : 10000L;
                                                                    DefaultTimer.getInstance().schedule(new LicenseTokenTimerTask(string), l4, 60000L);
                                                                }
                                                                return;
                                                            }
                                                            map2 = new ConfigKeyParser().decodeLicenseToken(string3);
                                                            if (!map2.containsKey(ERROR)) break block18;
                                                            object2 = map2.get(ERROR);
                                                            if (object2 == null) break block19;
                                                            Object object4 = object2;
                                                            map.put(ERROR, () -> ConfigKeyParser.g((String)object4));
                                                            long l5 = ServerPluginManager.getInstance().getState() == ServerPluginManager.ServerPluginManagerState.INIT ? 0L : 10000L;
                                                            DefaultTimer.getInstance().schedule(new LicenseTokenTimerTask(string), l5, 60000L);
                                                        }
                                                        return;
                                                    }
                                                    String string5 = map2.get("tokenhost");
                                                    if (string.equals(string5)) break block20;
                                                    object2 = "The hostname " + string + " of the license does not match the hostname '" + string5 + "' of the validation token. Is the server with the hostname '" + string + "' accessible over the internet via HTTP?";
                                                    if (object2 == null) break block21;
                                                    Object object5 = object2;
                                                    map.put(ERROR, () -> ConfigKeyParser.g((String)object5));
                                                    long l6 = ServerPluginManager.getInstance().getState() == ServerPluginManager.ServerPluginManagerState.INIT ? 0L : 10000L;
                                                    DefaultTimer.getInstance().schedule(new LicenseTokenTimerTask(string), l6, 60000L);
                                                }
                                                return;
                                            }
                                            string2 = map2.get(EXPIRES);
                                            if (string2 != null) break block22;
                                            object2 = "The validation token is invalid. Is the server with the hostname '" + string + "' accessible over the internet via HTTP?";
                                            if (object2 == null) break block23;
                                            Object object6 = object2;
                                            map.put(ERROR, () -> ConfigKeyParser.g((String)object6));
                                            long l7 = ServerPluginManager.getInstance().getState() == ServerPluginManager.ServerPluginManagerState.INIT ? 0L : 10000L;
                                            DefaultTimer.getInstance().schedule(new LicenseTokenTimerTask(string), l7, 60000L);
                                        }
                                        return;
                                    }
                                    l2 = TimeServer.currentTimeMillis();
                                    if (!Date.valueOf(string2).before(new java.util.Date(l2 - 86400000L))) break block24;
                                    object2 = "The validation token is expired. Is the server with the hostname '" + string + "' accessible over the internet via HTTP?";
                                    if (object2 == null) break block25;
                                    Object object7 = object2;
                                    map.put(ERROR, () -> ConfigKeyParser.g((String)object7));
                                    long l8 = ServerPluginManager.getInstance().getState() == ServerPluginManager.ServerPluginManagerState.INIT ? 0L : 10000L;
                                    DefaultTimer.getInstance().schedule(new LicenseTokenTimerTask(string), l8, 60000L);
                                }
                                return;
                            }
                            if (Date.valueOf(string2).before(new java.util.Date(l2 - 1728000000L))) {
                                DefaultTimer.getInstance().schedule(new LicenseTokenTimerTask(string), 10000L, 60000L);
                            }
                            if (ServerPluginManager.getInstance().getCorePluginId() != null) break block26;
                            object2 = "Persistence is not ready.";
                            if (object2 == null) break block27;
                            Object object8 = object2;
                            map.put(ERROR, () -> ConfigKeyParser.g((String)object8));
                            long l9 = ServerPluginManager.getInstance().getState() == ServerPluginManager.ServerPluginManagerState.INIT ? 0L : 10000L;
                            DefaultTimer.getInstance().schedule(new LicenseTokenTimerTask(string), l9, 60000L);
                        }
                        return;
                    }
                    try {
                        int n2 = Persistence.getInstance().getNodeCount();
                        if (Integer.parseInt((String)object) >= n2) break block28;
                        map.put(ERROR, () -> ConfigKeyParser.b(n2, (String)object));
                        if (object2 == null) break block29;
                        Object object9 = object2;
                        map.put(ERROR, () -> ConfigKeyParser.g((String)object9));
                    }
                    catch (Throwable throwable) {
                        try {
                            object2 = StringFunctions.getUserFriendlyErrorMessage(throwable);
                            if (object2 == null) break block30;
                            String string6 = object2;
                            map.put(ERROR, () -> string4);
                        }
                        catch (Throwable throwable2) {
                            if (object2 != null) {
                                String string7 = object2;
                                map.put(ERROR, () -> string4);
                                long l10 = ServerPluginManager.getInstance().getState() == ServerPluginManager.ServerPluginManagerState.INIT ? 0L : 10000L;
                                DefaultTimer.getInstance().schedule(new LicenseTokenTimerTask(string), l10, 60000L);
                            }
                            throw throwable2;
                        }
                        long l11 = ServerPluginManager.getInstance().getState() == ServerPluginManager.ServerPluginManagerState.INIT ? 0L : 10000L;
                        DefaultTimer.getInstance().schedule(new LicenseTokenTimerTask(string), l11, 60000L);
                    }
                    long l12 = ServerPluginManager.getInstance().getState() == ServerPluginManager.ServerPluginManagerState.INIT ? 0L : 10000L;
                    DefaultTimer.getInstance().schedule(new LicenseTokenTimerTask(string), l12, 60000L);
                }
                return;
            }
            if (object2 != null) {
                object = object2;
                map.put(ERROR, () -> ConfigKeyParser.g((String)object));
                long l13 = ServerPluginManager.getInstance().getState() == ServerPluginManager.ServerPluginManagerState.INIT ? 0L : 10000L;
                DefaultTimer.getInstance().schedule(new LicenseTokenTimerTask(string), l13, 60000L);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void e(Map map) {
        Object object = null;
        String string = (String)map.get(CLOUDHOST);
        URL uRL = null;
        try {
            String string2 = (String)map.get(NODE_COUNT);
            if (string == null || string2 == null) {
                return;
            }
            String string3 = l.get();
            if (string3.trim().isEmpty()) {
                object = "The externally visible URL is not set. The license for '" + string + "' cannot be validated.\nYou must set the 'Externally visible URL' and the server must be reachable through this URL to validate the license.";
                return;
            }
            uRL = new URL(string3);
            if (!string.equalsIgnoreCase(uRL.getHost())) {
                object = "The externally visible URL '" + String.valueOf(uRL) + "' does not match host of license: '" + string + "'\nYou must set the 'Externally visible URL' and the server must be reachable through this URL to validate the license.";
                return;
            }
            object = PrivateCloudLicenseTimerTask.externalUrlAssignable(uRL);
            if (object != null) {
                return;
            }
            int n2 = Persistence.getInstance().getNodeCount();
            if (Integer.parseInt(string2) < n2) {
                map.put(ERROR, () -> "The number of active cluster nodes (" + n2 + ") has exceeded the number of licensed nodes (" + string2 + ").");
                return;
            }
        }
        catch (Throwable throwable) {
            object = StringFunctions.getUserFriendlyErrorMessage(throwable);
        }
        finally {
            if (object != null) {
                String string4 = object;
                map.put(ERROR, () -> string4);
            }
        }
    }

    @Nonnull
    @SuppressFBWarnings(value={"URLCONNECTION_SSRF_FD"}, justification="Caller must check it")
    private static String d(String string) throws IOException {
        URLConnection uRLConnection = new URL(string).openConnection();
        uRLConnection.setRequestProperty("Connection", "close");
        uRLConnection.setConnectTimeout(5000);
        uRLConnection.setReadTimeout(10000);
        try (InputStream inputStream = uRLConnection.getInputStream();){
            String string2 = IOFunctions.readAsciiString(inputStream).trim();
            return string2;
        }
    }

    private static final void b(Map map, ApplicationDescription applicationDescription) {
        String string = (String)map.get("app");
        if (string != null) {
            if (string.equals(applicationDescription.getApplicationName())) {
                return;
            }
        } else {
            if (map.containsKey("features")) {
                return;
            }
            string = "";
        }
        String string2 = APP_MSG + string;
        map.put(ERROR, () -> string2);
    }

    private static /* synthetic */ String b(int n2, String string) {
        return "The number of active cluster nodes (" + n2 + ") has exceeded the number of licensed nodes (" + string + ").";
    }

    private static /* synthetic */ String l(String string) {
        return string;
    }

    static {
        j = new ConfigValue<String>(ConfigKey.LICENSEKEY){

            @Override
            protected void setValue(@Nullable String licensekey) throws IllegalArgumentException {
                super.setValue(licensekey);
                ConfigKeyParser.reset();
            }
        };
        k = new ConfigValue<Map<String, String>>(ConfigKey.LICENSETOKEN){

            @Override
            protected void setValue(@Nullable String licensekey) throws IllegalArgumentException {
                super.setValue(licensekey);
                ConfigKeyParser.reset();
            }
        };
        l = new ConfigValue<String>(ConfigKey.SERVER_URL){

            @Override
            protected void setValue(@Nullable String serverUrl) throws IllegalArgumentException {
                super.setValue(serverUrl);
                ConfigKeyParser.reset();
            }
        };
    }

    @JsonData
    private static class ExpiredNotificationGenerator
    extends PermissionNotificationGenerator
    implements TimedGenerator {
        private static final GUID ID = GUID.valueOf("c6m29up8toakqhm8ipaaph1cv");
        private static String lastExpired = "";
        private long[] times = new long[5];

        private ExpiredNotificationGenerator(long expired) {
            this.times[0] = expired - 1123200000L;
            this.times[1] = expired - 172800000L;
            this.times[2] = expired - 86400000L;
            this.times[3] = expired;
            this.times[4] = expired + 86400000L;
        }

        private static void handle(@Nullable String expiredStr) {
            if (Objects.equals(lastExpired, expiredStr)) {
                return;
            }
            lastExpired = expiredStr;
            if (expiredStr != null) {
                long l2 = Date.valueOf(expiredStr).getTime();
                NotificationManager.getInstance().registerGenerator(new ExpiredNotificationGenerator(l2));
            } else {
                NotificationManager.getInstance().unregisterGenerator(ID);
            }
        }

        @Override
        public GUID getId() {
            return ID;
        }

        @Override
        public Notification createNotification() {
            int n2 = 1 + (int)((this.times[4] - System.currentTimeMillis()) / 86400000L);
            Notification notification = new Notification(NotificationManager.I18N.getMsg("license.msg.title", new Object[0]), NotificationManager.I18N.getMsg("license.msg.willexpired", n2));
            notification.setTargetUrl("configmanager/dialog/category.license");
            if (n2 <= 3) {
                notification.setCritical(true);
            }
            return notification;
        }

        @Override
        public Times getNextTimes() {
            long l2 = System.currentTimeMillis();
            long l3 = 0L;
            for (long l4 : this.times) {
                if (l4 <= l2) continue;
                l3 = l4;
            }
            return new Times(this.times[0], l3);
        }
    }
}

