/*
 * Decompiled with CFR 0.152.
 */
package com.inet.usersandgroups.user.search;

import com.inet.search.SearchDataType;
import com.inet.search.SearchTag;
import com.inet.search.tokenizers.SearchTokenizer;
import com.inet.usersandgroups.api.user.LoginSettings;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nonnull;

public class SearchTagLoginSettings
extends SearchTag {
    public static final String KEY = "loginsettings";

    public SearchTagLoginSettings() {
        super(KEY, SearchDataType.ID, false, SearchTagLoginSettings.a(), 100);
    }

    @Nonnull
    public static String settingsAsToken(String loginSource, String loginID) {
        if ("system".equals(loginSource)) {
            loginID = loginID.replace('/', '\\');
        }
        return loginSource + "|" + loginID.toLowerCase();
    }

    private static SearchTokenizer a() {
        return (object, n2) -> {
            List list = (List)object;
            switch (list.size()) {
                case 0: {
                    return Collections.EMPTY_SET;
                }
                case 1: {
                    LoginSettings loginSettings = (LoginSettings)list.get(0);
                    return Collections.singleton(SearchTagLoginSettings.settingsAsToken(loginSettings.getLoginSource(), loginSettings.getLoginID()));
                }
            }
            HashSet<String> hashSet = new HashSet<String>();
            for (LoginSettings loginSettings : list) {
                hashSet.add(SearchTagLoginSettings.settingsAsToken(loginSettings.getLoginSource(), loginSettings.getLoginID()));
            }
            return hashSet;
        };
    }
}

