/*
 * Decompiled with CFR 0.152.
 */
package com.inet.usersandgroups.api.groups.persistence;

import com.inet.error.PersistenceException;
import com.inet.id.GUID;
import com.inet.lib.json.Json;
import com.inet.lib.json.JsonException;
import com.inet.permissions.Permission;
import com.inet.usersandgroups.UsersAndGroups;
import com.inet.usersandgroups.api.UserGroupField;
import com.inet.usersandgroups.api.groups.GroupTypeDef;
import com.inet.usersandgroups.api.groups.MemberToTypeCardinality;
import com.inet.usersandgroups.api.groups.MembershipType;
import com.inet.usersandgroups.api.groups.MutableUserGroupData;
import com.inet.usersandgroups.api.groups.UserGroupMembership;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public class UserGroupPersistenceUtils {
    public static boolean hasDifferencesBetweenValues(Map<String, String> persistedData, Map<String, String> updatedData) {
        for (String string : updatedData.keySet()) {
            String string2;
            String string3 = persistedData.get(string);
            if (Objects.equals(string3, string2 = updatedData.get(string))) continue;
            return true;
        }
        return false;
    }

    public static MutableUserGroupData convertToMutableUserGroupData(GUID groupID, List<UserGroupField<Object>> fieldsToInclude, HashMap<String, String> actualData) {
        HashMap<UserGroupField<Object>, Object> hashMap = new HashMap<UserGroupField<Object>, Object>();
        for (UserGroupField<Object> userGroupField : fieldsToInclude) {
            String string = userGroupField.getKey();
            if (!actualData.containsKey(string)) continue;
            String string2 = actualData.get(string);
            try {
                Object v = string2 == null || "null".equals(string2) ? null : (Object)new Json().fromJson(string2, userGroupField.getGenericType());
                hashMap.put(userGroupField, v);
            }
            catch (JsonException jsonException) {
                String string3 = String.format("Could not deserialize value of field \"%s\" defined for group with ID \"%s\". Default value will be used instead.", string, groupID);
                UsersAndGroups.LOGGER.warn(string3);
                UsersAndGroups.LOGGER.warn(jsonException);
            }
        }
        return MutableUserGroupData.createAndFillWithValidValues(groupID, fieldsToInclude, hashMap);
    }

    public static Set<Permission> convertKeysToPermissions(Set<String> permissionKeys) {
        HashSet<Permission> hashSet = new HashSet<Permission>();
        for (String string : permissionKeys) {
            hashSet.add(Permission.valueOfExistingOrCreate(string));
        }
        return hashSet;
    }

    public static UserGroupMembership convertToUserGroupMembershipOrThrowIfInvalid(GUID groupID, GroupTypeDef groupTypeDef, Map<GUID, Set<String>> membersMap) {
        Map<GUID, Set<MembershipType>> map = UserGroupPersistenceUtils.a(groupID, groupTypeDef, membersMap);
        UserGroupMembership userGroupMembership = new UserGroupMembership(groupTypeDef.getMembershipTypes(), groupTypeDef.getMemberToTypeCardinality(), map);
        Optional<String> optional = userGroupMembership.validate();
        if (optional.isPresent()) {
            throw new PersistenceException(new IllegalStateException(optional.get()));
        }
        return userGroupMembership;
    }

    private static Map<GUID, Set<MembershipType>> a(GUID gUID, GroupTypeDef groupTypeDef, Map<GUID, Set<String>> map) {
        HashMap<GUID, Set<MembershipType>> hashMap = new HashMap<GUID, Set<MembershipType>>();
        Map map2 = groupTypeDef.getMembershipTypes().stream().collect(Collectors.toMap(MembershipType::getKey, Function.identity()));
        for (GUID gUID2 : map.keySet()) {
            Set<String> set = map.get(gUID2);
            if (set.isEmpty()) {
                hashMap.put(gUID2, Collections.emptySet());
                continue;
            }
            HashSet<MembershipType> hashSet = new HashSet<MembershipType>();
            for (String string : set) {
                String string2 = string.toLowerCase();
                MembershipType membershipType = (MembershipType)map2.get(string2);
                if (membershipType == null) {
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("Found that invalid membership type is assigned to group member: ");
                    stringBuilder.append("UserAccountID=\"").append(gUID2).append("\", ");
                    stringBuilder.append("GroupID=\"").append(gUID).append("\", ");
                    stringBuilder.append("KeyOfInvalidMembershipType=\"").append(string2).append("\", ");
                    stringBuilder.append("KeysOfValidMembershipTypes=\"").append(map2.keySet()).append("\"");
                    UsersAndGroups.LOGGER.error(stringBuilder.toString());
                    continue;
                }
                hashSet.add(membershipType);
            }
            hashMap.put(gUID2, hashSet);
        }
        return hashMap;
    }

    public static void updateMembersMapAndThrowIfInvalid(GUID groupID, Map<GUID, Set<String>> membersMap, Map<GUID, Set<MembershipType>> membersToAdd, Map<GUID, Set<MembershipType>> membersToRemove, MemberToTypeCardinality cardinality) {
        UserGroupPersistenceUtils.a(membersMap, membersToAdd);
        boolean bl = !cardinality.isAcceptableNumberOfTypes(0);
        UserGroupPersistenceUtils.a(membersMap, membersToRemove, bl);
        HashSet<GUID> hashSet = new HashSet<GUID>(membersToAdd.keySet());
        hashSet.addAll(membersToRemove.keySet());
        for (GUID gUID : hashSet) {
            Set<String> set = membersMap.get(gUID);
            if (set == null || cardinality.isAcceptableNumberOfTypes(set.size())) continue;
            String string = String.format("membership data of group with ID %s can not be edited because number of membership types assigned to member with ID %s would be incorrect", groupID, gUID);
            throw new IllegalArgumentException(string);
        }
    }

    private static void a(Map<GUID, Set<String>> map, Map<GUID, Set<MembershipType>> map2) {
        for (GUID gUID : map2.keySet()) {
            if (!map.containsKey(gUID)) {
                map.put(gUID, new HashSet());
            }
            Set<String> set = map.get(gUID);
            map2.get(gUID).forEach(membershipType -> set.add(membershipType.getKey()));
        }
    }

    private static void a(Map<GUID, Set<String>> map, Map<GUID, Set<MembershipType>> map2, boolean bl) {
        for (GUID gUID : map2.keySet()) {
            if (!map.containsKey(gUID)) continue;
            Set<MembershipType> set = map2.get(gUID);
            if (set.isEmpty()) {
                map.remove(gUID);
                continue;
            }
            Set<String> set2 = map.get(gUID);
            set.forEach(membershipType -> set2.remove(membershipType.getKey()));
            if (!bl || !set2.isEmpty()) continue;
            map.remove(gUID);
        }
    }
}

