/*
 * Decompiled with CFR 0.152.
 */
package com.inet.usersandgroups.api.groups;

import com.inet.annotations.InternalApi;
import com.inet.id.GUID;
import com.inet.usersandgroups.api.groups.MemberToTypeCardinality;
import com.inet.usersandgroups.api.groups.MembershipType;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

@InternalApi
public class UserGroupMembership {
    private final Set<MembershipType> a;
    private final MemberToTypeCardinality b;
    protected final Map<GUID, Set<MembershipType>> members;

    public UserGroupMembership(Set<GUID> memberIDs) {
        this.a = Collections.emptySet();
        this.b = MemberToTypeCardinality.Zero;
        this.members = new HashMap<GUID, Set<MembershipType>>();
        memberIDs.forEach(gUID -> this.members.put((GUID)gUID, Collections.emptySet()));
    }

    public UserGroupMembership(Set<MembershipType> membershipTypes, MemberToTypeCardinality cardinality, Map<GUID, Set<MembershipType>> members) {
        this.a = membershipTypes == null ? null : Collections.unmodifiableSet(new HashSet<MembershipType>(membershipTypes));
        this.b = cardinality;
        if (members == null) {
            this.members = null;
        } else {
            HashMap<GUID, Set<MembershipType>> hashMap = new HashMap<GUID, Set<MembershipType>>();
            for (GUID gUID : members.keySet()) {
                Set<MembershipType> set = members.get(gUID);
                if (set == null) {
                    hashMap.put(gUID, set);
                    continue;
                }
                Set set2 = set.isEmpty() ? Collections.emptySet() : Collections.unmodifiableSet(new HashSet<MembershipType>(set));
                hashMap.put(gUID, set2);
            }
            this.members = Collections.unmodifiableMap(hashMap);
        }
    }

    public Optional<String> validate() {
        if (this.a == null) {
            return Optional.of("set of membership types must not be null");
        }
        if (this.a.contains(null)) {
            return Optional.of("set of membership types must not contain null");
        }
        if (this.b == null) {
            return Optional.of("cardinality must not be null");
        }
        if (this.members == null) {
            return Optional.of("membership data must not be null");
        }
        Function<Set, Set> function = set -> set.stream().map(MembershipType::getKey).collect(Collectors.toSet());
        for (Map.Entry<GUID, Set<MembershipType>> entry : this.members.entrySet()) {
            if (entry == null) {
                return Optional.of("map with membership data must not contain null as key which represents member ID");
            }
            GUID gUID = entry.getKey();
            Set<MembershipType> set2 = entry.getValue();
            if (set2 == null) {
                String string = String.format("set of membership types assigned to user with ID %s must not be null", gUID);
                return Optional.of(string);
            }
            if (set2.contains(null)) {
                String string = String.format("set of membership types assigned to user with ID %s must not contain null", gUID);
                return Optional.of(string);
            }
            if (set2.stream().anyMatch(membershipType -> !this.a.contains(membershipType))) {
                String string = "set of membership types assigned to user with ID %s contains invalid element(s): allowed=\"%s\", actual=\"%s\"";
                String string2 = String.format(string, gUID, function.apply(this.a), function.apply(set2));
                return Optional.of(string2);
            }
            if (this.b.isAcceptableNumberOfTypes(set2.size())) continue;
            String string = "set of membership types assigned to user with ID %s contains incorrect number of elements: cardinality=\"%s\", elements=\"%s\"";
            String string3 = String.format(string, gUID, this.b.name(), function.apply(set2));
            return Optional.of(string3);
        }
        return Optional.empty();
    }

    @Nonnull
    public Set<GUID> getMemberIDs() {
        return this.members.keySet();
    }

    public boolean contains(GUID userID) {
        return this.members.containsKey(userID);
    }

    public boolean isEmpty() {
        return this.members.isEmpty();
    }

    public Set<MembershipType> getAllMembershipTypes() {
        return this.a;
    }

    public MemberToTypeCardinality getMemberToTypeCardinality() {
        return this.b;
    }

    public Set<MembershipType> getMembershipTypes(GUID userID) {
        return this.members.get(userID);
    }

    public Set<GUID> getMemberIDs(MembershipType membershipType) {
        HashSet<GUID> hashSet = new HashSet<GUID>();
        for (GUID gUID : this.members.keySet()) {
            if (!this.members.get(gUID).contains(membershipType)) continue;
            hashSet.add(gUID);
        }
        return hashSet;
    }
}

