/*
 * Decompiled with CFR 0.152.
 */
package com.inet.thread.job.manager;

import com.inet.id.GUID;
import com.inet.lib.util.StringFunctions;
import com.inet.thread.BaseRunnableSession;
import com.inet.thread.EventDispatcher;
import com.inet.thread.RunnableSession;
import com.inet.thread.ThreadPool;
import com.inet.thread.ThreadPoolCompletableFuture;
import com.inet.thread.job.Job;
import com.inet.thread.job.JobDoneListener;
import com.inet.thread.job.JobInfo;
import com.inet.thread.job.ManageableJobState;
import com.inet.thread.job.TerminatedBy;
import com.inet.thread.job.manager.JobManager;
import com.inet.thread.job.manager.JobManagerCompleteCallback;
import com.inet.thread.job.manager.JobManagerEventLog;
import com.inet.thread.job.manager.JobStore;
import com.inet.usersandgroups.api.user.UserAccountScope;
import com.inet.usersandgroups.api.user.UserManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ManageableJob<RT, JT extends Job<RT>> {
    private static final int RUNNING_TO_IDLE_FACTOR = 10;
    private static final EventDispatcher b = new EventDispatcher();
    @Nonnull
    private final JT c;
    private final String d;
    private int e;
    private ManageableJobState f;
    private final long g;
    private long h = -1L;
    private GUID i;
    private final String j;
    private JobManagerCompleteCallback<RT> k;
    private ThreadState l = null;
    private ThreadState m = null;
    private RT n;
    private int o = -1;
    private TerminatedBy p;
    static final List<JobDoneListener> a = new CopyOnWriteArrayList<JobDoneListener>();
    private ManageableJob<?, ?> q;
    @Nonnull
    private a r;
    private List<ManageableJob<?, ?>> s = new ArrayList();
    private ThreadPool.Work<RT> t;
    private ThreadPool.Work<Object> u;
    private ThreadPool.Work<Object> v;

    ManageableJob(@Nonnull JT job, int defaultWeight) {
        this.f = ManageableJobState.READY;
        this.c = job;
        this.setWeight(defaultWeight);
        this.g = System.currentTimeMillis();
        this.d = GUID.generateNew().toString();
        this.r = new a(new ThreadPoolCompletableFuture(() -> job.getSession()));
        this.r.c.whenComplete((object, throwable) -> this.k.whenComplete(object, (Throwable)throwable));
        RunnableSession runnableSession = job.getSession();
        if (runnableSession instanceof BaseRunnableSession) {
            this.i = UserManager.getInstance().getCurrentUserAccountID((BaseRunnableSession)runnableSession);
        }
        this.j = job.clientAddress();
        JobStore.add(job);
    }

    public void setJobManagerInternal(JobManagerCompleteCallback<RT> jobManagerInternal) {
        this.k = jobManagerInternal;
    }

    public String uuid() {
        return this.d;
    }

    public long submitDate() {
        return this.g;
    }

    public Optional<Long> startTime() {
        return this.h == -1L ? Optional.empty() : Optional.of(this.h);
    }

    private void a() {
        this.h = System.currentTimeMillis();
    }

    public int weight() {
        return this.s.size() > 0 ? this.e / 10 : this.e;
    }

    public void setWeight(int weight) {
        if (weight < 0) {
            throw new IllegalArgumentException("weight must not be negative");
        }
        if (weight > 1000) {
            throw new IllegalArgumentException("weight must not be greater than 1000");
        }
        this.e = weight;
    }

    public void setTerminatedBy(TerminatedBy terminatedBy) {
        this.p = terminatedBy;
    }

    public TerminatedBy getTerminatedBy() {
        return this.p;
    }

    @Nonnull
    public ManageableJobState manageableJobState() {
        return this.f;
    }

    public boolean is(ManageableJobState manageableJobState) {
        return this.f.equals((Object)manageableJobState);
    }

    @Nonnull
    public JT job() {
        return this.c;
    }

    public void onStart() {
        this.a(ManageableJobState.STARTED);
        this.a();
        this.m = ThreadState.RUNNING;
        this.a(-1);
        JobManagerEventLog.JobStart.log(this, System.currentTimeMillis() - this.g);
    }

    public void onStarting(ThreadPool.Work<RT> threadPoolWork) {
        this.t = threadPoolWork;
        JobStore.get(this.c).getJobProgressUpdater().updateProgress(0);
        this.a(ManageableJobState.STARTING);
        this.a(-1);
        JobManagerEventLog.JobQueued.log(this, new Object[0]);
    }

    public void onFailed(Throwable exception) {
        this.a(ManageableJobState.FAILED);
        b.dispatchEvent(() -> this.r.completeExceptionally(exception));
        this.a(-1);
        this.a(exception);
        JobManagerEventLog.JobFailed.log(this, StringFunctions.getUserFriendlyErrorMessage(exception));
    }

    public void onPaused() {
        this.a(ManageableJobState.PAUSED);
        this.m = null;
        this.l = null;
        this.a(this.o);
        JobManagerEventLog.JobPaused.log(this, new Object[0]);
    }

    public void onPausing(ThreadPool.Work<Object> pauseWork) {
        this.v = pauseWork;
        this.a(ManageableJobState.PAUSING);
        this.l = ThreadState.RUNNING;
        this.a(-1);
    }

    private void a(ManageableJobState manageableJobState) {
        this.f = manageableJobState;
    }

    @Nonnull
    public CompletableFuture<RT> completableFuture() {
        return this.r;
    }

    public void onFinish(RT result) {
        this.a(ManageableJobState.FINISHED);
        b.dispatchEvent(() -> {
            if (this.i != null) {
                try (UserAccountScope userAccountScope = UserAccountScope.create(this.i);){
                    this.r.complete(result);
                }
            } else {
                this.r.complete(result);
            }
        });
        this.a(-1);
        this.b();
        JobManagerEventLog.JobFinished.log(this, System.currentTimeMillis() - this.h);
    }

    public void onTerminate() {
        this.a(ManageableJobState.TERMINATED);
        b.dispatchEvent(() -> this.r.b.cancel(false));
        this.a(-1);
        this.b();
    }

    public void onTerminating(ThreadPool.Work<Object> terminateWork) {
        this.u = terminateWork;
        this.a(ManageableJobState.TERMINATING);
        this.a(-1);
    }

    public int estimatedMemory() {
        int n2 = this.c.estimatedMemory();
        return this.s.size() > 0 ? n2 / 10 : n2;
    }

    public GUID userAccountID() {
        return this.i;
    }

    public String getClientIp() {
        return this.j;
    }

    public ThreadState stateOfCall() {
        return this.m;
    }

    public ThreadState stateOfPause() {
        return this.l;
    }

    public void callFinishedWith(ThreadState state) {
        if (state == ThreadState.ALREADY_FINISHED) {
            throw new IllegalArgumentException("Call cannot end with ALREADY_FINISHED");
        }
        if (state == ThreadState.RUNNING) {
            throw new IllegalArgumentException("RUNNING is not finished");
        }
        this.m = state;
    }

    public void pauseFinishedWith(ThreadState state) {
        if (state == ThreadState.TERMINATED_BY_PAUSING) {
            throw new IllegalArgumentException("Pause cannot end with TERMINATED_BY_PAUSE");
        }
        if (state == ThreadState.RUNNING) {
            throw new IllegalArgumentException("RUNNING is not finished");
        }
        this.l = state;
    }

    public RT getResultOfCallWhilePausing() {
        return this.n;
    }

    public void setResultOfCallWhilePausing(@Nullable RT resultOfCallWhilePausing) {
        this.n = resultOfCallWhilePausing;
    }

    public void sendStatusChangeIfWaitingPositionChanged(int indexInWaitingQueue) {
        if (indexInWaitingQueue != this.o) {
            this.a(indexInWaitingQueue);
        }
    }

    private void a(int n2) {
        this.o = n2;
        ManageableJobState manageableJobState = this.f;
        b.dispatchEvent(() -> {
            try {
                if (JobManager.LOGGER.isDebug()) {
                    JobManager.LOGGER.debug(String.format("State for %s is %s (%d)", this.c.name(), manageableJobState.toString(), n2 + 1));
                }
                this.c.jobStateChanged(manageableJobState, n2 + 1);
            }
            catch (Throwable throwable) {
                JobManager.LOGGER.error("Job StatusChangeListener threw exception:");
                JobManager.LOGGER.error(throwable);
            }
        });
    }

    private void b() {
        this.a((Throwable)null);
    }

    private void a(Throwable throwable) {
        JobInfo jobInfo = JobInfo.from(this, throwable);
        b.dispatchEvent(() -> {
            for (JobDoneListener jobDoneListener : a) {
                try {
                    jobDoneListener.jobDone(jobInfo);
                }
                catch (Throwable throwable) {
                    JobManager.LOGGER.error("JobDoneListener threw exception:");
                    JobManager.LOGGER.error(throwable);
                }
            }
        });
    }

    public ManageableJob<?, ?> getParentJob() {
        return this.q;
    }

    public void setParentJob(@Nonnull ManageableJob<?, ?> parentJob) {
        boolean bl = parentJob != this.q;
        this.q = parentJob;
        if (bl) {
            parentJob.a(this);
        }
    }

    private synchronized void a(@Nonnull ManageableJob<?, ?> manageableJob) {
        if (!this.s.contains(manageableJob)) {
            this.s.add(manageableJob);
        }
        manageableJob.setParentJob(this);
    }

    public synchronized void removeSubJob(@Nonnull ManageableJob<?, ?> job) {
        this.s.remove(job);
    }

    public boolean hasSubJobs() {
        return this.s.size() > 0;
    }

    @Nonnull
    public synchronized List<ManageableJob<?, ?>> getSubJobs() {
        return new ArrayList(this.s);
    }

    public void hardKill() {
        if (this.t != null && !this.t.cancel()) {
            JobManager.LOGGER.warn("[Hard Kill] Cannot stop Main-Thread of " + this.job().name());
        }
        if (this.v != null && !this.v.cancel()) {
            JobManager.LOGGER.warn("[Hard Kill] Cannot stop Pause-Thread of " + this.job().name());
        }
        if (this.u != null && !this.u.cancel()) {
            JobManager.LOGGER.warn("[Hard Kill] Cannot stop Terminate-Thread of " + this.job().name());
        }
    }

    public static final class ThreadState
    extends Enum<ThreadState> {
        public static final /* enum */ ThreadState RETURNED = new ThreadState();
        public static final /* enum */ ThreadState ALREADY_FINISHED = new ThreadState();
        public static final /* enum */ ThreadState THREW = new ThreadState();
        public static final /* enum */ ThreadState RUNNING = new ThreadState();
        public static final /* enum */ ThreadState TERMINATED_BY_PAUSING = new ThreadState();
        private static final /* synthetic */ ThreadState[] a;

        public static ThreadState[] values() {
            return (ThreadState[])a.clone();
        }

        public static ThreadState valueOf(String name) {
            return Enum.valueOf(ThreadState.class, name);
        }

        private static /* synthetic */ ThreadState[] a() {
            return new ThreadState[]{RETURNED, ALREADY_FINISHED, THREW, RUNNING, TERMINATED_BY_PAUSING};
        }

        static {
            a = ThreadState.a();
        }
    }

    private class a
    extends CompletableFuture<RT> {
        private CompletableFuture<RT> b = new CompletableFuture();
        private CompletableFuture<RT> c = new CompletableFuture();

        private a(CompletableFuture<RT> completableFuture) {
            this.b = completableFuture;
        }

        @Override
        public boolean isDone() {
            return this.b.isDone();
        }

        @Override
        public RT get() throws InterruptedException, ExecutionException {
            return this.b.get();
        }

        @Override
        public RT get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return this.b.get(timeout, unit);
        }

        @Override
        public RT join() {
            return this.b.join();
        }

        @Override
        public RT getNow(RT valueIfAbsent) {
            return this.b.getNow(valueIfAbsent);
        }

        @Override
        public boolean complete(RT value) {
            this.c.complete(value);
            return this.b.complete(value);
        }

        @Override
        public boolean completeExceptionally(Throwable ex) {
            this.c.completeExceptionally(ex);
            return this.b.completeExceptionally(ex);
        }

        @Override
        public <U> CompletableFuture<U> thenApply(Function<? super RT, ? extends U> fn) {
            return this.b.thenApply(fn);
        }

        @Override
        public <U> CompletableFuture<U> thenApplyAsync(Function<? super RT, ? extends U> fn) {
            return this.b.thenApplyAsync(fn);
        }

        @Override
        public <U> CompletableFuture<U> thenApplyAsync(Function<? super RT, ? extends U> fn, Executor executor) {
            return this.b.thenApplyAsync(fn, executor);
        }

        @Override
        public CompletableFuture<Void> thenAccept(Consumer<? super RT> action) {
            return this.b.thenAccept(action);
        }

        @Override
        public CompletableFuture<Void> thenAcceptAsync(Consumer<? super RT> action) {
            return this.b.thenAcceptAsync(action);
        }

        @Override
        public CompletableFuture<Void> thenAcceptAsync(Consumer<? super RT> action, Executor executor) {
            return this.b.thenAcceptAsync(action, executor);
        }

        @Override
        public CompletableFuture<Void> thenRun(Runnable action) {
            return this.b.thenRun(action);
        }

        @Override
        public CompletableFuture<Void> thenRunAsync(Runnable action) {
            return this.b.thenRunAsync(action);
        }

        @Override
        public CompletableFuture<Void> thenRunAsync(Runnable action, Executor executor) {
            return this.b.thenRunAsync(action, executor);
        }

        @Override
        public <U, V> CompletableFuture<V> thenCombine(CompletionStage<? extends U> other, BiFunction<? super RT, ? super U, ? extends V> fn) {
            return this.b.thenCombine((CompletionStage)other, fn);
        }

        @Override
        public <U, V> CompletableFuture<V> thenCombineAsync(CompletionStage<? extends U> other, BiFunction<? super RT, ? super U, ? extends V> fn) {
            return this.b.thenCombineAsync((CompletionStage)other, fn);
        }

        @Override
        public <U, V> CompletableFuture<V> thenCombineAsync(CompletionStage<? extends U> other, BiFunction<? super RT, ? super U, ? extends V> fn, Executor executor) {
            return this.b.thenCombineAsync((CompletionStage)other, fn, executor);
        }

        @Override
        public <U> CompletableFuture<Void> thenAcceptBoth(CompletionStage<? extends U> other, BiConsumer<? super RT, ? super U> action) {
            return this.b.thenAcceptBoth((CompletionStage)other, action);
        }

        @Override
        public <U> CompletableFuture<Void> thenAcceptBothAsync(CompletionStage<? extends U> other, BiConsumer<? super RT, ? super U> action) {
            return this.b.thenAcceptBothAsync((CompletionStage)other, action);
        }

        @Override
        public <U> CompletableFuture<Void> thenAcceptBothAsync(CompletionStage<? extends U> other, BiConsumer<? super RT, ? super U> action, Executor executor) {
            return this.b.thenAcceptBothAsync((CompletionStage)other, action, executor);
        }

        @Override
        public CompletableFuture<Void> runAfterBoth(CompletionStage<?> other, Runnable action) {
            return this.b.runAfterBoth((CompletionStage)other, action);
        }

        @Override
        public CompletableFuture<Void> runAfterBothAsync(CompletionStage<?> other, Runnable action) {
            return this.b.runAfterBothAsync((CompletionStage)other, action);
        }

        @Override
        public CompletableFuture<Void> runAfterBothAsync(CompletionStage<?> other, Runnable action, Executor executor) {
            return this.b.runAfterBothAsync((CompletionStage)other, action, executor);
        }

        @Override
        public <U> CompletableFuture<U> applyToEither(CompletionStage<? extends RT> other, Function<? super RT, U> fn) {
            return this.b.applyToEither(other, fn);
        }

        @Override
        public <U> CompletableFuture<U> applyToEitherAsync(CompletionStage<? extends RT> other, Function<? super RT, U> fn) {
            return this.b.applyToEitherAsync(other, fn);
        }

        @Override
        public <U> CompletableFuture<U> applyToEitherAsync(CompletionStage<? extends RT> other, Function<? super RT, U> fn, Executor executor) {
            return this.b.applyToEitherAsync(other, fn, executor);
        }

        @Override
        public CompletableFuture<Void> acceptEither(CompletionStage<? extends RT> other, Consumer<? super RT> action) {
            return this.b.acceptEither(other, action);
        }

        @Override
        public CompletableFuture<Void> acceptEitherAsync(CompletionStage<? extends RT> other, Consumer<? super RT> action) {
            return this.b.acceptEitherAsync(other, action);
        }

        @Override
        public CompletableFuture<Void> acceptEitherAsync(CompletionStage<? extends RT> other, Consumer<? super RT> action, Executor executor) {
            return this.b.acceptEitherAsync(other, action, executor);
        }

        @Override
        public CompletableFuture<Void> runAfterEither(CompletionStage<?> other, Runnable action) {
            return this.b.runAfterEither((CompletionStage)other, action);
        }

        @Override
        public CompletableFuture<Void> runAfterEitherAsync(CompletionStage<?> other, Runnable action) {
            return this.b.runAfterEitherAsync((CompletionStage)other, action);
        }

        @Override
        public CompletableFuture<Void> runAfterEitherAsync(CompletionStage<?> other, Runnable action, Executor executor) {
            return this.b.runAfterEitherAsync((CompletionStage)other, action, executor);
        }

        @Override
        public <U> CompletableFuture<U> thenCompose(Function<? super RT, ? extends CompletionStage<U>> fn) {
            return this.b.thenCompose(fn);
        }

        @Override
        public <U> CompletableFuture<U> thenComposeAsync(Function<? super RT, ? extends CompletionStage<U>> fn) {
            return this.b.thenComposeAsync(fn);
        }

        @Override
        public <U> CompletableFuture<U> thenComposeAsync(Function<? super RT, ? extends CompletionStage<U>> fn, Executor executor) {
            return this.b.thenComposeAsync(fn, executor);
        }

        @Override
        public CompletableFuture<RT> whenComplete(BiConsumer<? super RT, ? super Throwable> action) {
            return this.b.whenComplete(action);
        }

        @Override
        public CompletableFuture<RT> whenCompleteAsync(BiConsumer<? super RT, ? super Throwable> action) {
            return this.b.whenCompleteAsync(action);
        }

        @Override
        public CompletableFuture<RT> whenCompleteAsync(BiConsumer<? super RT, ? super Throwable> action, Executor executor) {
            return this.b.whenCompleteAsync(action, executor);
        }

        @Override
        public <U> CompletableFuture<U> handle(BiFunction<? super RT, Throwable, ? extends U> fn) {
            return this.b.handle(fn);
        }

        @Override
        public <U> CompletableFuture<U> handleAsync(BiFunction<? super RT, Throwable, ? extends U> fn) {
            return this.b.handleAsync(fn);
        }

        @Override
        public <U> CompletableFuture<U> handleAsync(BiFunction<? super RT, Throwable, ? extends U> fn, Executor executor) {
            return this.b.handleAsync(fn, executor);
        }

        @Override
        public CompletableFuture<RT> toCompletableFuture() {
            return this.b.toCompletableFuture();
        }

        @Override
        public CompletableFuture<RT> exceptionally(Function<Throwable, ? extends RT> fn) {
            return this.b.exceptionally(fn);
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            ManageableJob.this.r.c.cancel(true);
            return true;
        }

        @Override
        public boolean isCancelled() {
            return this.b.isCancelled();
        }

        @Override
        public boolean isCompletedExceptionally() {
            return this.b.isCompletedExceptionally();
        }

        @Override
        public void obtrudeValue(RT value) {
            this.b.obtrudeValue(value);
        }

        @Override
        public void obtrudeException(Throwable ex) {
            this.b.obtrudeException(ex);
        }

        @Override
        public int getNumberOfDependents() {
            return this.b.getNumberOfDependents();
        }

        @Override
        public String toString() {
            return "Wrapper of :" + this.b.toString();
        }
    }
}

