/*
 * Decompiled with CFR 0.152.
 */
package com.inet.thread;

import com.inet.annotations.InternalApi;
import com.inet.cache.CacheManager;
import com.inet.logging.LogID;
import com.inet.logging.LogManager;
import com.inet.thread.NamedTask;
import com.inet.thread.RunnableSession;
import com.inet.thread.SessionLocator;
import com.inet.thread.ThreadStackTrace;
import com.inet.thread.ThreadUtils;
import com.inet.thread.job.manager.JobManager;
import com.inet.thread.job.manager.JobManagerEventLog;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;

@InternalApi
public class ThreadPool {
    public static final ThreadPool DEFAULT = new ThreadPool();
    public static final RunnableSession FIND_AUTOMATICALLY = new RunnableSession(){

        @Override
        public void setThreadLocal() {
        }

        @Override
        public void resetThreadLocal() {
        }
    };
    private static int a;
    private final Object b = new Object();
    private final ArrayList<Work<Object>> c = new ArrayList();
    private final ArrayList<Work<Object>> d = new ArrayList();
    private final ArrayList<a> e = new ArrayList();
    private final AtomicInteger f = new AtomicInteger();
    private final AtomicInteger g = new AtomicInteger();
    private final AtomicInteger h = new AtomicInteger();
    private final Map<RunnableSession, List<Work<?>>> i = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        a[] aArray = this.b;
        synchronized (this.b) {
            this.c.clear();
            this.d.clear();
            this.b.notifyAll();
            a[] aArray2 = this.e.toArray(new a[this.e.size()]);
            this.e.clear();
            a[] aArray3 = aArray2;
            int n2 = aArray3.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                a a2 = aArray3[i2];
                a2.b = true;
            }
            // ** MonitorExit[var2_1] (shouldn't be in output)
            for (a a3 : aArray2) {
                ThreadUtils.stopThread(a3);
            }
            return;
        }
    }

    public Thread @Nonnull [] getWorkerThreads() {
        return this.e.toArray(new Thread[this.e.size()]);
    }

    public static void executeImmediate(Runnable runnable, RunnableSession session) throws IllegalArgumentException {
        ThreadPool.a(runnable, session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void a(Runnable runnable, RunnableSession runnableSession) throws IllegalArgumentException {
        long l2 = ThreadUtils.getCpuTime();
        String string = null;
        try {
            runnableSession.setThreadLocal();
            string = ThreadPool.a(runnable);
            runnable.run();
        }
        finally {
            runnableSession.resetThreadLocal();
            ThreadPool.a(string);
            runnableSession.addCpuTime(ThreadUtils.getCpuTime() - l2);
        }
    }

    private static String a(Object object) {
        if (object instanceof NamedTask) {
            String string = Thread.currentThread().getName();
            String string2 = ((NamedTask)object).getTaskName();
            String string3 = LogID.getID();
            if (string2 != null) {
                Thread.currentThread().setName((String)(string3 != null ? "Session " + string3 + ": " : "") + string2);
            }
            return string;
        }
        return null;
    }

    private static void a(String string) {
        if (string != null) {
            Thread.currentThread().setName(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> T a(Callable<T> callable, RunnableSession runnableSession) throws Exception {
        long l2 = ThreadUtils.getCpuTime();
        String string = null;
        try {
            runnableSession.setThreadLocal();
            string = ThreadPool.a(callable);
            T t = callable.call();
            return t;
        }
        finally {
            runnableSession.resetThreadLocal();
            ThreadPool.a(string);
            runnableSession.addCpuTime(ThreadUtils.getCpuTime() - l2);
        }
    }

    public static <T> T executeImmediate(Callable<T> callable, RunnableSession session) throws Exception {
        return ThreadPool.a(callable, session);
    }

    public <T> Work<T> startMainThread(Callable<T> callable, RunnableSession session) throws IllegalArgumentException {
        return this.startMainThread(callable, session, FIND_AUTOMATICALLY);
    }

    public <T> Work<T> startMainThread(Callable<T> callable, RunnableSession session, RunnableSession parentSession) throws IllegalArgumentException {
        return this.a(new Work<T>(callable, session, parentSession));
    }

    public <T> Work<T> startMainThread(Runnable runnable, RunnableSession session) throws IllegalArgumentException {
        return this.startMainThread(runnable, session, FIND_AUTOMATICALLY);
    }

    public <T> Work<T> startMainThread(Runnable runnable, RunnableSession session, RunnableSession parentSession) throws IllegalArgumentException {
        return this.a(new Work(runnable, session, parentSession));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> Work<T> a(Work<T> work) throws IllegalArgumentException {
        Object object = this.b;
        synchronized (object) {
            this.c.add(work);
            if (this.h.get() < this.c.size() && this.g.get() + this.h.get() < JobManager.THREAD_POOL_MAX_SIZE.get()) {
                this.b();
            }
            this.b.notifyAll();
        }
        return work;
    }

    public int getMainQueueSize() {
        return this.c.size();
    }

    public <T> Work<T> startSubThread(Callable<T> callable, RunnableSession session) throws IllegalArgumentException {
        return this.startSubThread(callable, session, FIND_AUTOMATICALLY);
    }

    public <T> Work<T> startSubThread(Callable<T> callable, RunnableSession session, RunnableSession parentSession) throws IllegalArgumentException {
        return this.b(new Work<T>(callable, session, parentSession));
    }

    public <T> Work<T> startSubThread(Runnable runnable, RunnableSession session) throws IllegalArgumentException {
        return this.startSubThread(runnable, session, FIND_AUTOMATICALLY);
    }

    public <T> Work<T> startSubThread(Runnable runnable, RunnableSession session, RunnableSession parentSession) throws IllegalArgumentException {
        return this.b(new Work(runnable, session, parentSession));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> Work<T> b(Work<T> work) throws IllegalArgumentException {
        Object object = this.b;
        synchronized (object) {
            this.d.add(work);
            if (this.h.get() < this.d.size()) {
                this.b();
            }
            this.b.notifyAll();
        }
        return work;
    }

    public boolean isPoolThread() {
        return Thread.currentThread().getClass() == a.class;
    }

    private Work<?> a() {
        if (!this.isPoolThread()) {
            return null;
        }
        a a2 = (a)Thread.currentThread();
        return a2.d;
    }

    public List<RunnableSession> getParentSessionsForCurrentThread() {
        if (!this.isPoolThread()) {
            if (SessionLocator.exists()) {
                ArrayList<RunnableSession> arrayList = new ArrayList<RunnableSession>();
                arrayList.add(SessionLocator.getCurrent());
                return arrayList;
            }
            return Collections.emptyList();
        }
        Work<?> work = ((a)Thread.currentThread()).d;
        ArrayList<RunnableSession> arrayList = new ArrayList<RunnableSession>();
        while (work != null) {
            arrayList.add(work.d);
            if (work.e != null) {
                arrayList.add(work.e);
                break;
            }
            work = work.f;
        }
        return arrayList;
    }

    private void b() {
        a a2 = new a();
        a2.start();
        this.f.getAndIncrement();
        this.h.getAndIncrement();
        this.e.add(a2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ThreadStackTrace> getStackTraces(RunnableSession session) {
        ArrayList arrayList = new ArrayList();
        ArrayList<ThreadStackTrace> arrayList2 = this.b;
        synchronized (arrayList2) {
            List<Work<?>> list = this.i.get(session);
            if (list != null) {
                arrayList.addAll(list);
            }
        }
        arrayList2 = new ArrayList<ThreadStackTrace>();
        for (Work work : arrayList) {
            a a2 = work.j;
            if (a2 == null) continue;
            ThreadStackTrace threadStackTrace = new ThreadStackTrace(a2.getName(), a2.getStackTrace());
            arrayList2.add(threadStackTrace);
        }
        return arrayList2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cancel(RunnableSession session) {
        boolean bl = true;
        ArrayList arrayList = new ArrayList();
        Iterator iterator = this.b;
        synchronized (iterator) {
            List<Work<?>> object2 = this.i.get(session);
            if (object2 != null) {
                arrayList.addAll(object2);
                for (Work<?> work : object2) {
                    this.c.remove(work);
                    this.d.remove(work);
                }
                object2.clear();
                this.i.remove(session);
            }
        }
        for (Work work : arrayList) {
            a a2 = work.j;
            if (a2 == null) continue;
            a2.c = true;
            bl &= ThreadUtils.stopThread(a2);
        }
        return bl;
    }

    private class a
    extends Thread {
        private boolean b;
        private boolean c;
        private Work<?> d;

        public a() {
            super("InetThreadPool-" + ++a);
            try {
                this.setDaemon(true);
                this.setPriority(5);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                while (true) {
                    List<Work<?>> list;
                    String string;
                    Work<Object> work;
                    Object object;
                    block48: {
                        boolean bl;
                        boolean bl2 = CacheManager.checkMemory();
                        object = ThreadPool.this.b;
                        synchronized (object) {
                            block47: {
                                if (!this.b) break block47;
                                return;
                            }
                            if (ThreadPool.this.d.size() > 0) {
                                work = ThreadPool.this.d.remove(0);
                                bl = false;
                            } else if (ThreadPool.this.c.size() > 0 && (ThreadPool.this.g.get() == 0 || bl2)) {
                                work = ThreadPool.this.c.remove(0);
                                bl = true;
                            } else {
                                if (ThreadPool.this.c.size() > 0) {
                                    JobManagerEventLog.MemoryExceeded.log(null, new Object[0]);
                                    ThreadPool.this.b.wait(5000L);
                                } else {
                                    ThreadPool.this.b.wait();
                                }
                                continue;
                            }
                            work.j = this;
                            this.d = work;
                            ThreadPool.this.h.getAndDecrement();
                        }
                        string = Thread.currentThread().getName();
                        try {
                            if (bl) {
                                ThreadPool.this.g.getAndIncrement();
                            }
                            if (work.b != null) {
                                ThreadPool.a(work.b, work.d);
                            } else {
                                work.h = ThreadPool.a(work.c, work.d);
                            }
                            if (!bl) break block48;
                            ThreadPool.this.g.getAndDecrement();
                        }
                        catch (Throwable throwable) {
                            block49: {
                                try {
                                    work.i = throwable;
                                    if (!bl) break block49;
                                    ThreadPool.this.g.getAndDecrement();
                                }
                                catch (Throwable throwable2) {
                                    if (bl) {
                                        ThreadPool.this.g.getAndDecrement();
                                    }
                                    Object object2 = ThreadPool.this.b;
                                    synchronized (object2) {
                                        this.d = null;
                                        ThreadPool.this.h.getAndIncrement();
                                        work.g = true;
                                        work.j = null;
                                        List<Work<?>> list2 = ThreadPool.this.i.get(work.d);
                                        if (list2 != null) {
                                            list2.remove(work);
                                            if (list2.size() == 0) {
                                                ThreadPool.this.i.remove(work.d);
                                            }
                                        }
                                        ThreadPool.this.b.notifyAll();
                                    }
                                    if (this.c) {
                                        ThreadPool.this.b();
                                        return;
                                    }
                                    try {
                                        Thread.currentThread().setName(string);
                                        throw throwable2;
                                    }
                                    catch (Error error) {
                                        LogManager.getApplicationLogger().error("Error in Thread '" + Thread.currentThread().getName() + "'");
                                        LogManager.getApplicationLogger().error(error);
                                        throw error;
                                    }
                                    catch (Throwable throwable3) {
                                        LogManager.getApplicationLogger().error("Error in Thread '" + Thread.currentThread().getName() + "'");
                                        LogManager.getApplicationLogger().error(throwable3);
                                        break;
                                    }
                                }
                            }
                            object = ThreadPool.this.b;
                            synchronized (object) {
                                this.d = null;
                                ThreadPool.this.h.getAndIncrement();
                                work.g = true;
                                work.j = null;
                                list = ThreadPool.this.i.get(work.d);
                                if (list != null) {
                                    list.remove(work);
                                    if (list.size() == 0) {
                                        ThreadPool.this.i.remove(work.d);
                                    }
                                }
                                ThreadPool.this.b.notifyAll();
                            }
                            if (this.c) {
                                ThreadPool.this.b();
                                return;
                            }
                            Thread.currentThread().setName(string);
                            continue;
                        }
                    }
                    object = ThreadPool.this.b;
                    synchronized (object) {
                        this.d = null;
                        ThreadPool.this.h.getAndIncrement();
                        work.g = true;
                        work.j = null;
                        list = ThreadPool.this.i.get(work.d);
                        if (list != null) {
                            list.remove(work);
                            if (list.size() == 0) {
                                ThreadPool.this.i.remove(work.d);
                            }
                        }
                        ThreadPool.this.b.notifyAll();
                    }
                    if (this.c) {
                        ThreadPool.this.b();
                        return;
                    }
                    Thread.currentThread().setName(string);
                    continue;
                    break;
                }
            }
            finally {
                ThreadPool.this.h.getAndDecrement();
                ThreadPool.this.f.getAndDecrement();
            }
        }
    }

    public class Work<T> {
        private final Runnable b;
        private final Callable<T> c;
        private final RunnableSession d;
        private final RunnableSession e;
        private final Work<?> f;
        private boolean g;
        private T h;
        private Throwable i;
        private a j;

        Work(Runnable runnable, RunnableSession session, RunnableSession parentSession) throws IllegalArgumentException {
            this(runnable, null, session, parentSession);
            if (runnable == null) {
                throw new IllegalArgumentException("Runnable is null");
            }
        }

        Work(Callable<T> callable, RunnableSession session, RunnableSession parentSession) throws IllegalArgumentException {
            this(null, callable, session, parentSession);
            if (callable == null) {
                throw new IllegalArgumentException("Callable is null");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Work(Runnable runnable, Callable<T> callable, RunnableSession session, RunnableSession parentSession) throws IllegalArgumentException {
            if (session == null) {
                throw new IllegalArgumentException("RunnableSession is null");
            }
            this.b = runnable;
            this.c = callable;
            this.d = session;
            if (parentSession == FIND_AUTOMATICALLY) {
                this.f = ThreadPool.this.a();
                this.e = null;
            } else {
                this.e = parentSession;
                this.f = null;
            }
            Object object = ThreadPool.this.b;
            synchronized (object) {
                List<Work<?>> list = ThreadPool.this.i.get(session);
                if (list == null) {
                    list = new ArrayList();
                    ThreadPool.this.i.put(session, list);
                }
                list.add(this);
            }
        }

        public boolean cancel() {
            return ThreadPool.this.cancel(this.d);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void join() throws InterruptedException {
            while (true) {
                Object object = ThreadPool.this.b;
                synchronized (object) {
                    if (this.g) {
                        return;
                    }
                    ThreadPool.this.b.wait();
                }
            }
        }

        public boolean isDown() {
            return this.g;
        }

        public T get() throws Exception {
            this.join();
            if (this.i != null) {
                if (this.i instanceof Error) {
                    throw (Error)this.i;
                }
                throw (Exception)this.i;
            }
            return this.h;
        }
    }
}

