/*
 * Decompiled with CFR 0.152.
 */
package com.inet.search.command;

import com.inet.annotations.InternalApi;
import com.inet.error.ErrorCode;
import com.inet.http.servlet.ClientLocale;
import com.inet.search.SearchTag;
import com.inet.search.command.AndSearchExpression;
import com.inet.search.command.SearchCondition;
import com.inet.search.command.SearchExpression;
import com.inet.search.command.SearchID;
import com.inet.search.command.TokenMatcher;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@InternalApi
public class SearchCommand
implements Cloneable {
    @Nonnull
    private Locale a;
    @Nonnull
    private AndSearchExpression b;
    private List<SearchExpression> c;
    private List<SearchExpression> d;
    @Nonnull
    private final Map<String, Integer> e;
    @Nullable
    private Set<SearchTag> f;
    private List<TokenMatcher<?>> g;
    private List<Predicate<?>> h;
    private int i = 500000;
    private SearchID j;

    public SearchCommand(@Nullable String leftOperand, @Nonnull SearchCondition.SearchTermOperator searchTermOperator, @Nullable Object rightOperand) {
        this(new SearchCondition(leftOperand, searchTermOperator, rightOperand));
    }

    public SearchCommand(@Nonnull Locale locale, @Nullable String leftOperand, @Nonnull SearchCondition.SearchTermOperator searchTermOperator, @Nonnull Object rightOperand) {
        this(locale, new SearchCondition(leftOperand, searchTermOperator, rightOperand));
    }

    public SearchCommand(SearchExpression ... searchExpressions) {
        this(ClientLocale.getThreadLocale(), searchExpressions);
    }

    public SearchCommand(@Nonnull Locale locale, SearchExpression ... searchExpressions) {
        this(locale, (SearchExpression)new AndSearchExpression(), Collections.emptyMap());
        for (SearchExpression searchExpression : searchExpressions) {
            this.b.add(searchExpression);
        }
    }

    public SearchCommand(@Nonnull SearchExpression searchExpression, @Nonnull Map<String, Integer> priorities) {
        this(ClientLocale.getThreadLocale(), searchExpression, priorities);
    }

    public SearchCommand(@Nonnull Locale locale, @Nonnull SearchExpression searchExpression, @Nonnull Map<String, Integer> priorities) {
        this(locale, searchExpression, priorities, null, null);
    }

    public SearchCommand(@Nonnull Locale locale, @Nonnull SearchExpression searchExpression, @Nonnull Map<String, Integer> priorities, @Nullable Set<SearchTag> tags, @Nullable List<TokenMatcher<?>> tokenMatcher) {
        if (searchExpression instanceof AndSearchExpression) {
            this.b = (AndSearchExpression)searchExpression;
        } else {
            this.b = new AndSearchExpression();
            this.b.add(searchExpression);
        }
        this.e = priorities;
        this.f = tags;
        this.g = tokenMatcher;
        this.a = Objects.requireNonNull(locale);
    }

    public void addFilter(Predicate<?> filter) {
        if (this.h == null) {
            this.h = new ArrayList();
        }
        this.h.add(filter);
    }

    public void addBoostingExpression(SearchExpression expression) {
        if (this.c == null) {
            this.c = new ArrayList<SearchExpression>();
        }
        this.c.add(expression);
    }

    void a(SearchExpression searchExpression) {
        if (this.d == null) {
            this.d = new ArrayList<SearchExpression>();
        }
        this.d.add(searchExpression);
    }

    public Locale getLocale() {
        return this.a;
    }

    @Nonnull
    public AndSearchExpression getSearchExpression() {
        return this.b;
    }

    @Nullable
    public List<SearchExpression> getBoostingExpressions() {
        return this.c;
    }

    @Nullable
    public List<SearchExpression> getVisibleBoostingExpressions() {
        return this.d;
    }

    @Nonnull
    public Map<String, Integer> getPriorities() {
        return this.e;
    }

    @Nullable
    public Set<SearchTag> getTags() {
        return this.f;
    }

    public void setTags(@Nullable Set<SearchTag> tags) {
        this.f = tags;
    }

    public <ID> void setTokenMatcher(@Nullable List<TokenMatcher<ID>> tokenMatcher) {
        this.g = tokenMatcher;
    }

    @Nullable
    public <ID> List<TokenMatcher<ID>> getTokenMatcher() {
        return this.g;
    }

    @Nullable
    public <ID> List<Predicate<ID>> getFilters() {
        return this.h;
    }

    public void setResultLimit(int resultLimit) {
        this.i = resultLimit;
    }

    public int getResultLimit() {
        return this.i;
    }

    public void setID(@Nullable SearchID ID) {
        this.j = ID;
    }

    @Nullable
    public SearchID getID() {
        return this.j;
    }

    @Nonnull
    public SearchCommand clone() {
        try {
            SearchCommand searchCommand = (SearchCommand)super.clone();
            searchCommand.b = (AndSearchExpression)this.b.clone();
            if (this.c != null) {
                searchCommand.c = new ArrayList<SearchExpression>(this.c);
            }
            if (this.d != null) {
                searchCommand.d = new ArrayList<SearchExpression>(this.d);
            }
            if (this.h != null) {
                searchCommand.h = new ArrayList(this.h);
            }
            return searchCommand;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw (RuntimeException)ErrorCode.throwAny(cloneNotSupportedException);
        }
    }
}

