/*
 * Decompiled with CFR 0.152.
 */
package com.inet.persistence.crypto.aes;

import com.inet.lib.io.FastByteArrayOutputStream;
import com.inet.lib.util.IOFunctions;
import com.inet.persistence.RandomAccessRead;
import com.inet.persistence.crypto.CryptoAlgorithm;
import com.inet.persistence.crypto.EncryptionData;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.util.Arrays;
import javax.annotation.SuppressFBWarnings;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;

public class AESAlgorithm
extends CryptoAlgorithm {
    private static final String TRANSFORMATION = "AES/GCM/NoPadding";
    private static final int TAG_LENGTH_BIT = 128;
    private static final int TAG_LENGTH_BYTE = 16;
    private static final int IV_LENGTH_BYTE = 12;
    private static final int AES_BLOCK_SIZE = 16;
    private GCMParameterSpec a;
    private IvParameterSpec b;
    private SecretKey c;
    private EncryptionData d;

    @SuppressFBWarnings(value={"STATIC_IV"}, justification="IV is not static, it's either random generated or part of the input data")
    AESAlgorithm(char[] password, byte[] salt, byte[] iv) throws GeneralSecurityException {
        this.c = AESAlgorithm.getAESKeyFromPassword(password, salt);
        if (iv == null) {
            iv = new byte[12];
            new SecureRandom().nextBytes(iv);
        }
        this.a = new GCMParameterSpec(128, iv);
        this.b = new IvParameterSpec(iv);
        this.a();
    }

    @Override
    public void reset() throws GeneralSecurityException {
        byte[] byArray = new byte[12];
        new SecureRandom().nextBytes(byArray);
        this.a = new GCMParameterSpec(128, byArray);
        this.b = new IvParameterSpec(byArray);
        this.a();
    }

    @SuppressFBWarnings(value={"CIPHER_INTEGRITY"}, justification="Cipher is only used for initialization verification and not activly used to decrypt")
    private void a() throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException {
        Cipher cipher = Cipher.getInstance("AES/CTR/NoPadding");
        cipher.init(2, (Key)this.c, AESAlgorithm.a(this.b, 0L));
        cipher = Cipher.getInstance(TRANSFORMATION);
        cipher.init(1, (Key)this.c, this.a);
        this.d = null;
    }

    public static SecretKey getAESKeyFromPassword(char[] password, byte[] salt) throws NoSuchAlgorithmException, InvalidKeySpecException {
        SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA256");
        PBEKeySpec pBEKeySpec = new PBEKeySpec(password, salt, 65536, 256);
        SecretKeySpec secretKeySpec = new SecretKeySpec(secretKeyFactory.generateSecret(pBEKeySpec).getEncoded(), "AES");
        return secretKeySpec;
    }

    @Override
    public OutputStream getEncryptingStream(OutputStream target) {
        try {
            return new b(target, this.c, this.a);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new IllegalStateException(generalSecurityException);
        }
    }

    @Override
    public RandomAccessRead getDecryptRA(RandomAccessRead soure) {
        try {
            return new AESRandomAccessRead(soure, this.c, this.b);
        }
        catch (IOException | GeneralSecurityException exception) {
            throw new IllegalStateException(exception);
        }
    }

    @Override
    @SuppressFBWarnings(value={"CIPHER_INTEGRITY"}, justification="Fallback implementation for certain access requirements, GCM tag authentication is an extra stap in that case.")
    public byte[] decryptBlock(long offset, byte[] data, boolean lastBlock) throws GeneralSecurityException {
        Cipher cipher = Cipher.getInstance("AES/CTR/NoPadding");
        cipher.init(2, (Key)this.c, AESAlgorithm.a(this.b, offset));
        int n2 = (int)(offset % 16L);
        if (n2 > 0) {
            byte[] byArray = new byte[n2];
            cipher.update(byArray);
        }
        if (lastBlock) {
            data = Arrays.copyOf(data, data.length - 16);
        }
        return cipher.doFinal(data);
    }

    @Override
    public InputStream getDecryptingStream(InputStream source) {
        try {
            return new a(source, this.c, this.b);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new IllegalStateException(generalSecurityException);
        }
    }

    @Override
    public EncryptionData getEncryptionData() {
        if (this.d == null) {
            this.d = EncryptionData.create(TRANSFORMATION, this.b.getIV());
        }
        return this.d;
    }

    @SuppressFBWarnings(value={"STATIC_IV"}, justification="IV is not static, it's generated by an external function")
    private static IvParameterSpec a(IvParameterSpec ivParameterSpec, long l2) {
        byte[] byArray = Arrays.copyOf(ivParameterSpec.getIV(), 16);
        int n2 = (int)(l2 / 16L + 2L);
        byArray[12] = (byte)(n2 >> 24);
        byArray[13] = (byte)(n2 >> 16);
        byArray[14] = (byte)(n2 >> 8);
        byArray[15] = (byte)n2;
        return new IvParameterSpec(byArray);
    }

    private static class b
    extends OutputStream {
        private OutputStream a;
        private Cipher b;
        private FastByteArrayOutputStream c;
        private int d;

        public b(OutputStream outputStream, SecretKey secretKey, AlgorithmParameterSpec algorithmParameterSpec) throws GeneralSecurityException {
            this.a = outputStream instanceof BufferedOutputStream ? outputStream : new BufferedOutputStream(outputStream);
            this.b = Cipher.getInstance(AESAlgorithm.TRANSFORMATION);
            this.b.init(1, (Key)secretKey, algorithmParameterSpec);
            this.d = this.b.getBlockSize();
            this.c = new FastByteArrayOutputStream(this.d);
        }

        @Override
        public void write(int b2) throws IOException {
            if (this.c == null) {
                throw new IOException("Stream already closed");
            }
            if (this.d == 0) {
                this.a.write(this.b.update(new byte[]{(byte)b2}));
            } else {
                this.c.write((byte)b2);
                if (this.c.size() == this.d) {
                    this.a.write(this.b.update(this.c.toByteArray()));
                    this.c.reset();
                }
            }
        }

        @Override
        public void write(byte[] b2, int off, int len) throws IOException {
            if (this.c == null) {
                throw new IOException("Stream already closed");
            }
            if (this.d == 0) {
                this.a.write(this.b.update(b2, off, len));
            } else {
                if (this.c.size() > 0 && this.c.size() < this.d) {
                    int n2 = Math.min(len, this.d - this.c.size());
                    this.c.write(b2, off, n2);
                    if (this.c.size() == this.d) {
                        this.a.write(this.b.update(this.c.toByteArray()));
                        this.c.reset();
                    }
                    off += n2;
                    len -= n2;
                }
                while (len >= this.d) {
                    this.a.write(this.b.update(b2, off, this.d));
                    len -= this.d;
                    off += this.d;
                }
                if (len > 0) {
                    this.c.write(b2, off, len);
                }
            }
        }

        @Override
        public void flush() throws IOException {
            this.a.flush();
        }

        @Override
        public void close() throws IOException {
            try {
                if (this.c != null) {
                    if (this.c.size() > 0) {
                        this.a.write(this.b.doFinal(this.c.toByteArray()));
                    } else {
                        this.a.write(this.b.doFinal());
                    }
                    this.c = null;
                    this.a.flush();
                }
                this.a.close();
            }
            catch (BadPaddingException | IllegalBlockSizeException generalSecurityException) {
                throw new IOException(generalSecurityException);
            }
        }
    }

    public static class AESRandomAccessRead
    extends RandomAccessRead {
        private RandomAccessRead a;
        private Cipher b;
        private byte[] c;
        private byte[] d;
        private int e = 0;
        private long f = 0L;
        private boolean g = false;
        private SecretKey h;
        private IvParameterSpec i;
        private long j;

        @SuppressFBWarnings(value={"CIPHER_INTEGRITY"}, justification="Fallback implementation for certain access requirements, GCM tag authentication is an extra stap in that case.")
        public AESRandomAccessRead(RandomAccessRead source, SecretKey fileEncryptionKey, IvParameterSpec parameter) throws GeneralSecurityException, IOException {
            this.a = source;
            this.h = fileEncryptionKey;
            this.i = parameter;
            this.b = Cipher.getInstance("AES/CTR/NoPadding");
            this.b.init(2, (Key)fileEncryptionKey, AESAlgorithm.a(this.i, 0L));
            this.d = new byte[this.b.getBlockSize()];
            this.j = source.length() - 16L;
        }

        @Override
        public void close() throws IOException {
            this.a.close();
        }

        @Override
        public long length() throws IOException {
            return this.a.length() - 16L;
        }

        @Override
        public int read(byte[] b2, int off, int len) throws IOException {
            int n2 = 0;
            if (this.f + (long)len > this.j && (len = (int)(this.j - this.f)) <= 0) {
                return -1;
            }
            while (n2 < len) {
                int n3;
                if (this.c == null || this.e == this.c.length) {
                    n3 = this.a.readCompletely(this.d);
                    if (n3 <= 0) {
                        return n2 == 0 ? -1 : n2;
                    }
                    if (n3 < this.d.length) {
                        try {
                            this.c = this.b.doFinal(this.d, 0, n3);
                        }
                        catch (BadPaddingException | IllegalBlockSizeException generalSecurityException) {
                            throw new IOException(generalSecurityException);
                        }
                    } else {
                        this.c = this.b.update(this.d, 0, n3);
                    }
                    int n4 = Math.min(this.c.length, len - n2);
                    System.arraycopy(this.c, 0, b2, off + n2, n4);
                    this.e = n4;
                    n2 += n4;
                    this.f += (long)n4;
                    continue;
                }
                n3 = Math.min(this.c.length - this.e, len - n2);
                System.arraycopy(this.c, this.e, b2, off + n2, n3);
                this.e += n3;
                n2 += n3;
                this.f += (long)n3;
            }
            return n2;
        }

        @Override
        public int read() throws IOException {
            if (this.f >= this.j) {
                return -1;
            }
            while (this.c == null || this.e == this.c.length) {
                if (this.g) {
                    return -1;
                }
                int n2 = this.a.readCompletely(this.d);
                if (n2 <= 0) {
                    try {
                        this.c = this.b.doFinal();
                        this.e = 0;
                        this.g = true;
                    }
                    catch (BadPaddingException | IllegalBlockSizeException generalSecurityException) {
                        throw new IOException(generalSecurityException);
                    }
                    if (this.c.length != 0) continue;
                    return -1;
                }
                this.c = this.b.update(this.d, 0, n2);
                this.e = 0;
            }
            ++this.f;
            return this.c[this.e++] & 0xFF;
        }

        @Override
        public void seek(long pos) throws IOException {
            if (pos < 0L) {
                throw new IllegalArgumentException("Invalid offset");
            }
            if (pos >= this.length() + 16L) {
                throw new IllegalArgumentException("Invalid offset");
            }
            int n2 = (int)(pos % 16L);
            if (this.c != null && pos / 16L == this.f / 16L && !this.g && this.c != null && this.e < this.c.length) {
                this.e = n2;
                this.f = pos;
                return;
            }
            this.e = n2;
            this.a.seek(pos);
            IvParameterSpec ivParameterSpec = AESAlgorithm.a(this.i, pos);
            try {
                this.b.init(2, (Key)this.h, ivParameterSpec);
                this.f = pos;
                this.c = null;
                if (n2 > 0) {
                    Arrays.fill(this.d, 0, n2, (byte)0);
                    this.a.readCompletely(this.d, n2, this.d.length - n2);
                    this.c = this.b.update(this.d);
                }
                this.g = false;
            }
            catch (InvalidAlgorithmParameterException | InvalidKeyException generalSecurityException) {
                throw new IllegalStateException(generalSecurityException);
            }
        }
    }

    private static class a
    extends InputStream {
        private Cipher a;
        private InputStream b;
        private int c;
        private byte[] d;
        private byte[] e;
        private int f = 0;
        private boolean g = false;
        private int h = 0;
        private boolean i = false;

        @SuppressFBWarnings(value={"CIPHER_INTEGRITY"}, justification="Fallback implementation for certain access requirements, GCM tag authentication is the default.")
        public a(InputStream inputStream, SecretKey secretKey, AlgorithmParameterSpec algorithmParameterSpec) throws GeneralSecurityException {
            this.b = inputStream;
            if (algorithmParameterSpec instanceof GCMParameterSpec) {
                this.a = Cipher.getInstance(AESAlgorithm.TRANSFORMATION);
                this.a.init(2, (Key)secretKey, algorithmParameterSpec);
            } else if (algorithmParameterSpec instanceof IvParameterSpec) {
                this.a = Cipher.getInstance("AES/CTR/NoPadding");
                this.a.init(2, (Key)secretKey, AESAlgorithm.a((IvParameterSpec)algorithmParameterSpec, 0L));
                this.g = true;
                this.h = 16;
            }
            this.c = this.a.getBlockSize();
            this.e = new byte[this.c + this.h];
        }

        @Override
        public int read() throws IOException {
            while (this.d == null || this.f == this.c) {
                if (this.i) {
                    return -1;
                }
                if (this.h > 0 && !this.g) {
                    System.arraycopy(this.e, this.c, this.e, 0, this.h);
                }
                int n2 = IOFunctions.readCompletely(this.b, this.e, this.g ? 0 : this.h, this.g ? this.e.length : this.c);
                this.g = false;
                if (n2 < this.c) {
                    try {
                        this.d = n2 > 0 ? this.a.doFinal(this.e, 0, n2) : this.a.doFinal();
                        this.c = this.d.length;
                        this.f = 0;
                        this.i = true;
                    }
                    catch (BadPaddingException | IllegalBlockSizeException generalSecurityException) {
                        throw new IOException(generalSecurityException);
                    }
                    if (this.d.length != 0) continue;
                    return -1;
                }
                this.d = this.a.update(this.e, 0, Math.min(n2, this.c));
                this.f = 0;
            }
            return this.d[this.f++] & 0xFF;
        }

        @Override
        public int read(byte[] b2, int off, int len) throws IOException {
            int n2 = 0;
            while (n2 < len) {
                int n3;
                if (this.d == null || this.f == this.c || this.f == this.d.length) {
                    if (this.h > 0 && !this.g) {
                        System.arraycopy(this.e, this.c, this.e, 0, this.h);
                    }
                    if ((n3 = IOFunctions.readCompletely(this.b, this.e, this.g ? 0 : this.h, this.g ? this.e.length : this.c)) <= 0) {
                        return n2 == 0 ? -1 : n2;
                    }
                    if (n3 < this.c) {
                        try {
                            this.d = this.a.doFinal(this.e, 0, n3);
                            this.c = this.d.length;
                        }
                        catch (BadPaddingException | IllegalBlockSizeException generalSecurityException) {
                            throw new IOException(generalSecurityException);
                        }
                    } else {
                        this.d = this.a.update(this.e, 0, Math.min(this.g ? n3 - this.c : n3, this.c));
                    }
                    this.g = false;
                    int n4 = Math.min(this.d.length, len - n2);
                    System.arraycopy(this.d, 0, b2, off + n2, n4);
                    this.f = n4;
                    n2 += n4;
                    continue;
                }
                n3 = Math.min(this.d.length - this.f, len - n2);
                System.arraycopy(this.d, this.f, b2, off + n2, n3);
                this.f += n3;
                n2 += n3;
            }
            return n2;
        }

        @Override
        public void close() throws IOException {
            this.b.close();
        }
    }
}

