/*
 * Decompiled with CFR 0.152.
 */
package com.inet.persistence.crypto;

import com.inet.error.ErrorCode;
import com.inet.lib.util.IOFunctions;
import com.inet.logging.LogManager;
import com.inet.persistence.PersistenceEntry;
import com.inet.persistence.RandomAccessRead;
import com.inet.persistence.crypto.Crypto;
import com.inet.persistence.crypto.CryptoAlgorithm;
import com.inet.persistence.crypto.EncryptionData;
import com.inet.persistence.crypto.RandomAccessReadInputStream;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class CryptoPersistenceEntry
extends PersistenceEntry {
    private PersistenceEntry a;
    private CryptoAlgorithm b;
    private boolean c = false;
    private char[] d;
    private byte[] e;

    public CryptoPersistenceEntry(PersistenceEntry wrapped, char[] password, byte[] salt) {
        this.a = wrapped;
        this.d = password;
        this.e = salt;
    }

    private void a(EncryptionData encryptionData) {
        try {
            this.b = Crypto.create(this.d, this.e, encryptionData);
            this.c = encryptionData != null && encryptionData.isEncrypted();
        }
        catch (GeneralSecurityException generalSecurityException) {
            ErrorCode.throwAny(generalSecurityException);
        }
        finally {
            this.d = null;
            this.e = null;
        }
    }

    @Override
    @Nonnull
    public String getPath() {
        return this.a.getPath();
    }

    @Override
    @Nonnull
    public PersistenceEntry resolve(@Nonnull String path) throws NullPointerException, IllegalArgumentException {
        return this.a.resolve(path);
    }

    @Override
    public PersistenceEntry getParent() {
        return this.a.getParent();
    }

    @Override
    public boolean exists() {
        return this.a.exists();
    }

    @Override
    @Nonnull
    public @Nonnull List<@Nonnull PersistenceEntry> getChildren() {
        return this.a.getChildren();
    }

    @Override
    public String getString() {
        byte[] byArray = this.getBytes();
        return byArray != null ? new String(byArray, StandardCharsets.UTF_8) : null;
    }

    @Override
    public void setString(@Nonnull String value) throws NullPointerException {
        this.setBytes(value.getBytes(StandardCharsets.UTF_8));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getBytes() {
        byte[] byArray = this.a.getBytes();
        if (byArray == null) {
            return null;
        }
        if (this.d != null) {
            EncryptionData encryptionData = null;
            try {
                try (ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);){
                    encryptionData = EncryptionData.get(byteArrayInputStream);
                }
                this.a(encryptionData);
            }
            catch (IOException iOException) {
                try {
                    ErrorCode.throwAny(iOException);
                    this.a(encryptionData);
                }
                catch (Throwable throwable) {
                    this.a(encryptionData);
                    throw throwable;
                }
            }
        }
        if (!this.c) {
            return byArray;
        }
        int n2 = this.b.getEncryptionData().getHeaderSize();
        try {
            return this.b.decryptBlock(0L, Arrays.copyOfRange(byArray, n2, byArray.length), true);
        }
        catch (GeneralSecurityException generalSecurityException) {
            LogManager.getConfigLogger().error(generalSecurityException);
            return null;
        }
    }

    @Override
    public RandomAccessRead getRandomAccessRead() {
        RandomAccessRead randomAccessRead = this.a.getRandomAccessRead();
        if (randomAccessRead == null) {
            return null;
        }
        if (this.d != null) {
            EncryptionData encryptionData = null;
            try (RandomAccessReadInputStream randomAccessReadInputStream = new RandomAccessReadInputStream(randomAccessRead, true);){
                encryptionData = EncryptionData.get(randomAccessReadInputStream);
            }
            catch (IOException iOException) {
                try {
                    randomAccessRead.close();
                }
                catch (IOException iOException2) {
                    // empty catch block
                }
                throw (RuntimeException)ErrorCode.throwAny(iOException);
            }
            this.a(encryptionData);
            try {
                randomAccessRead.seek(0L);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (!this.c) {
            return randomAccessRead;
        }
        return this.b.getDecryptRA(new a(randomAccessRead, this.b.getEncryptionData().getHeaderSize()));
    }

    @Override
    public void setBytes(byte @Nullable [] value) throws NullPointerException {
        if (value == null) {
            throw new NullPointerException();
        }
        try (OutputStream outputStream = this.getOutputStream();){
            outputStream.write(value);
        }
        catch (IOException iOException) {
            ErrorCode.throwAny(iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream getInputStream() {
        InputStream inputStream = this.a.getInputStream();
        if (inputStream == null) {
            return null;
        }
        boolean bl = true;
        if (this.d != null) {
            EncryptionData encryptionData = null;
            try {
                if (!inputStream.markSupported()) {
                    inputStream = new BufferedInputStream(inputStream);
                }
                encryptionData = EncryptionData.get(inputStream);
                bl = false;
                this.a(encryptionData);
            }
            catch (IOException iOException) {
                try {
                    ErrorCode.throwAny(iOException);
                    this.a(encryptionData);
                }
                catch (Throwable throwable) {
                    this.a(encryptionData);
                    throw throwable;
                }
            }
        }
        if (!this.c) {
            return inputStream;
        }
        if (bl) {
            try {
                int n2 = this.b.getEncryptionData().getHeaderSize();
                if (inputStream.skip(n2) < (long)n2) {
                    throw new IOException("Decryption error: Cannot skip header data");
                }
            }
            catch (IOException iOException) {
                ErrorCode.throwAny(iOException);
            }
        }
        return this.b.getDecryptingStream(inputStream);
    }

    @Override
    public void setInputStream(@Nonnull InputStream value) throws NullPointerException {
        try (OutputStream outputStream = this.getOutputStream();){
            IOFunctions.copyData(value, outputStream);
        }
        catch (IOException iOException) {
            ErrorCode.throwAny(iOException);
        }
    }

    @Override
    public OutputStream getOutputStream() {
        try {
            if (this.d != null) {
                this.a(null);
            } else {
                this.b.reset();
            }
            this.c = true;
            OutputStream outputStream = this.a.getOutputStream();
            outputStream.write(this.b.getEncryptionData().getFileHeader());
            return this.b.getEncryptingStream(outputStream);
        }
        catch (Exception exception) {
            ErrorCode.throwAny(exception);
            return null;
        }
    }

    @Override
    public long size() {
        if (this.a.exists() && this.c) {
            EncryptionData encryptionData = this.b.getEncryptionData();
            return this.a.size() - (long)(encryptionData.isEncrypted() ? encryptionData.getHeaderSize() : 0);
        }
        return this.a.size();
    }

    @Override
    public void deleteTree() {
        this.a.deleteTree();
    }

    @Override
    public void deleteValue() {
        this.a.deleteValue();
    }

    @Override
    public long lastModified() {
        return this.a.lastModified();
    }

    @Override
    public void moveTo(@Nonnull String newPath) throws IllegalStateException, IllegalArgumentException {
        this.a.moveTo(newPath);
    }

    private static class a
    extends RandomAccessRead {
        private RandomAccessRead a;
        private long b;

        public a(RandomAccessRead randomAccessRead, long l2) {
            this.a = randomAccessRead;
            this.b = l2;
            try {
                randomAccessRead.seek(l2);
            }
            catch (IOException iOException) {
                ErrorCode.throwAny(iOException);
            }
        }

        @Override
        public void close() throws IOException {
            this.a.close();
        }

        @Override
        public long length() throws IOException {
            return this.a.length() - this.b;
        }

        @Override
        public int read(byte[] b2, int off, int len) throws IOException {
            return this.a.read(b2, off, len);
        }

        @Override
        public int read() throws IOException {
            return this.a.read();
        }

        @Override
        public void seek(long pos) throws IOException {
            if (pos < 0L) {
                throw new IOException("Negative seek offset");
            }
            this.a.seek(pos + this.b);
        }
    }
}

