/*
 * Decompiled with CFR 0.152.
 */
package com.inet.permissions;

import com.inet.annotations.InternalApi;
import com.inet.config.ConfigKey;
import com.inet.config.ConfigValue;
import com.inet.error.ServiceUnavailableException;
import com.inet.id.GUID;
import com.inet.permissions.Permission;
import com.inet.permissions.PermissionCheckScope;
import com.inet.plugin.ServerPluginManager;
import com.inet.search.command.AndSearchExpression;
import com.inet.search.command.ApiSearchCommandBuilder;
import com.inet.search.command.OrSearchExpression;
import com.inet.search.command.PrefilteredSearchExpression;
import com.inet.search.command.SearchCommand;
import com.inet.search.command.SearchCondition;
import com.inet.search.index.IndexSearchEngine;
import com.inet.usersandgroups.UsersAndGroups;
import com.inet.usersandgroups.api.groups.UserGroupInfo;
import com.inet.usersandgroups.api.groups.UserGroupManager;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserAccountType;
import com.inet.usersandgroups.api.user.UserManager;
import com.inet.usersandgroups.user.search.SearchTagActive;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;

@InternalApi
public class SystemPermissionChecker {
    public static final ConfigValue<Boolean> SYSTEMPERMISSION_ENABLED = new ConfigValue(ConfigKey.SYSTEMPERMISSION_ENABLED);
    public static final ConfigValue<Boolean> GUEST_FULL_PERMISSIONS = new ConfigValue(ConfigKey.GUEST_FULL_PERMISSIONS);
    private static final ConcurrentHashMap<String, Permission[]> a = new ConcurrentHashMap();
    private static final boolean HAS_HOSTING = ServerPluginManager.getInstance().isPluginLoaded("hosting");

    private SystemPermissionChecker() {
    }

    public static boolean isAdministrator() {
        return SystemPermissionChecker.checkAccess(Permission.CONFIGURATION);
    }

    public static boolean checkAccess(Permission permission) {
        return SystemPermissionChecker.hasAnyPermission(new PermissionCheckScope(), permission);
    }

    public static boolean checkAccess(Permission ... permissions) {
        return SystemPermissionChecker.hasAnyPermission(new PermissionCheckScope(), permissions);
    }

    public static void registerSharedPermission(String sharedFeature, Permission permission) {
        Permission[] permissionArray = a.get(sharedFeature);
        permissionArray = permissionArray == null ? new Permission[1] : Arrays.copyOf(permissionArray, permissionArray.length + 1);
        permissionArray[permissionArray.length - 1] = permission;
        a.put(sharedFeature, permissionArray);
    }

    public static boolean checkSharedAccess(String sharedFeature) {
        return SystemPermissionChecker.hasAnyPermission(new PermissionCheckScope(), a.get(sharedFeature));
    }

    public static boolean hasAnyPermission(GUID accountID, Permission ... permissions) {
        return SystemPermissionChecker.hasAnyPermission(UserManager.getInstance().getUserAccount(accountID), permissions);
    }

    public static boolean hasAnyPermission(UserAccount userAccount, Permission ... permissions) {
        return SystemPermissionChecker.hasAnyPermission(new PermissionCheckScope(userAccount), permissions);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean hasAnyPermission(PermissionCheckScope scope, Permission ... permissions) {
        UserAccount userAccount;
        UserAccount userAccount2 = userAccount = scope != null ? scope.getUserAccount() : null;
        if (!SYSTEMPERMISSION_ENABLED.get().booleanValue()) {
            if (scope == null || permissions == null || permissions.length <= 0) return true;
            if (!SystemPermissionChecker.a(userAccount)) {
                if (!SystemPermissionChecker.b(userAccount) || GUEST_FULL_PERMISSIONS.get().booleanValue()) return true;
                for (Permission permission : permissions) {
                    if ("administration".equals(permission.getCategory().a())) continue;
                    return true;
                }
                return false;
            }
        } else if (scope == null || permissions == null || permissions.length == 0) {
            return false;
        }
        if (userAccount != null && userAccount.isActive() && userAccount.getAccountType().equals((Object)UserAccountType.Administrator)) {
            return true;
        }
        boolean bl = SystemPermissionChecker.a(userAccount);
        if (!bl) {
            try {
                UserGroupInfo userGroupInfo = scope.getAllUsersGroup();
                if (userGroupInfo != null && SystemPermissionChecker.a(userGroupInfo.getPermissions(), permissions)) {
                    return true;
                }
            }
            catch (ServiceUnavailableException serviceUnavailableException) {
                return false;
            }
        }
        if (userAccount == null || !userAccount.isActive()) {
            return false;
        }
        if (SystemPermissionChecker.a(userAccount.getPermissions(), permissions)) {
            return true;
        }
        for (UserGroupInfo userGroupInfo : scope.getUserGroups()) {
            if (!userGroupInfo.isActive() || bl && UsersAndGroups.GROUPID_ALLUSERS.equals(userGroupInfo.getID()) || !SystemPermissionChecker.a(userGroupInfo.getPermissions(), permissions) && !UsersAndGroups.GROUPTYPE_ADMIN.equals(userGroupInfo.getType())) continue;
            return true;
        }
        return false;
    }

    private static boolean a(@Nullable UserAccount userAccount) {
        return userAccount != null && userAccount.getAccountType() == UserAccountType.Temp;
    }

    private static boolean b(@Nullable UserAccount userAccount) {
        return userAccount != null && userAccount.getAccountType() == UserAccountType.Guest;
    }

    private static boolean a(Set<Permission> set, Permission ... permissionArray) {
        if (set.isEmpty()) {
            return false;
        }
        for (Permission permission : permissionArray) {
            if (!set.contains(permission)) continue;
            boolean bl = true;
            String string = permission.getParentKey();
            while (string != null) {
                Permission permission2 = Permission.valueOfExistingOrCreate(string);
                if (!set.contains(permission2)) {
                    bl = false;
                    break;
                }
                string = permission2.getParentKey();
            }
            if (!bl) continue;
            return true;
        }
        return false;
    }

    public static Set<GUID> getAllUsersWithAnyPermission(Permission ... permissions) {
        Object object2;
        HashSet<GUID> hashSet = new HashSet<GUID>();
        UserManager userManager = UserManager.getInstance();
        PermissionCheckScope permissionCheckScope = new PermissionCheckScope(userManager.getCurrentUserAccount());
        boolean bl = false;
        if (!SYSTEMPERMISSION_ENABLED.get().booleanValue()) {
            bl = true;
        } else {
            object2 = permissionCheckScope.getAllUsersGroup();
            if (object2 != null && SystemPermissionChecker.a(((UserGroupInfo)object2).getPermissions(), permissions)) {
                bl = true;
            }
        }
        object2 = userManager.getSearchEngine();
        if (bl) {
            Iterator iterator = ((IndexSearchEngine)object2).createIdsIterator(((IndexSearchEngine)object2).getTag("useraccountid"), bl);
            while (iterator.hasNext()) {
                hashSet.add((GUID)iterator.next());
            }
            SearchCondition searchCondition = new SearchCondition("active", SearchCondition.SearchTermOperator.Equals, SearchTagActive.valueAsString(false));
            Set set = ((IndexSearchEngine)object2).simpleSearch(new SearchCommand(searchCondition));
            hashSet.removeAll(set);
            set = ((IndexSearchEngine)object2).simpleSearch(SystemPermissionChecker.a());
            if (!set.isEmpty()) {
                AndSearchExpression andSearchExpression = SystemPermissionChecker.a(permissions);
                andSearchExpression.add(0, new PrefilteredSearchExpression(set));
                Set set2 = ((IndexSearchEngine)object2).simpleSearch(new SearchCommand(andSearchExpression));
                set.removeAll(set2);
                if (!set.isEmpty()) {
                    for (UserGroupInfo userGroupInfo : UserGroupManager.getInstance().getAllGroups()) {
                        if (set.isEmpty()) break;
                        if (!SystemPermissionChecker.a(userGroupInfo.getPermissions(), permissions) && !UsersAndGroups.GROUPTYPE_ADMIN.equals(userGroupInfo.getType())) continue;
                        set.removeAll(userGroupInfo.getMemberIDs());
                    }
                }
                hashSet.removeAll(set);
            }
            return hashSet;
        }
        HashSet<GUID> hashSet2 = new HashSet<GUID>();
        for (UserGroupInfo object3 : UserGroupManager.getInstance().getAllGroups()) {
            if (!SystemPermissionChecker.a(object3.getPermissions(), permissions) && !UsersAndGroups.GROUPTYPE_ADMIN.equals(object3.getType())) continue;
            hashSet2.addAll(object3.getMemberIDs());
        }
        AndSearchExpression andSearchExpression = new AndSearchExpression();
        andSearchExpression.add(new PrefilteredSearchExpression(hashSet2));
        andSearchExpression.add(new SearchCondition("active", SearchCondition.SearchTermOperator.Equals, SearchTagActive.valueAsString(false)));
        Set set = ((IndexSearchEngine)object2).simpleSearch(new SearchCommand(andSearchExpression));
        hashSet2.removeAll(set);
        hashSet.addAll(hashSet2);
        Set set3 = ((IndexSearchEngine)object2).simpleSearch(new SearchCommand(SystemPermissionChecker.a(permissions)));
        hashSet.addAll(set3);
        return hashSet;
    }

    private static SearchCommand a() {
        return new ApiSearchCommandBuilder().equals("useraccounttype", UserAccountType.Temp.name()).equals("active", String.valueOf(SearchTagActive.valueAsInt(true))).build();
    }

    private static AndSearchExpression a(Permission ... permissionArray) {
        OrSearchExpression orSearchExpression = new OrSearchExpression();
        for (Permission permission : permissionArray) {
            orSearchExpression.add(new SearchCondition("permissions", SearchCondition.SearchTermOperator.Equals, permission.getKey()));
        }
        orSearchExpression.add(new SearchCondition("useraccounttype", SearchCondition.SearchTermOperator.Equals, UserAccountType.Administrator.name()));
        AndSearchExpression andSearchExpression = new AndSearchExpression();
        andSearchExpression.add(orSearchExpression);
        andSearchExpression.add(new SearchCondition("active", SearchCondition.SearchTermOperator.Equals, String.valueOf(SearchTagActive.valueAsInt(true))));
        return andSearchExpression;
    }

    public static boolean isSystemPermissionsEnabled() {
        return SYSTEMPERMISSION_ENABLED.get();
    }

    public static boolean checkHostingAccess(Permission permission) {
        if (HAS_HOSTING) {
            UserAccount userAccount = UserManager.getInstance().getCurrentUserAccount();
            if (userAccount == null) {
                return false;
            }
            UserAccountType userAccountType = userAccount.getAccountType();
            return UserAccountType.Administrator.equals((Object)userAccountType);
        }
        return SystemPermissionChecker.checkAccess(permission);
    }
}

