/*
 * Decompiled with CFR 0.152.
 */
package com.inet.mdns;

import com.inet.lib.util.NetworkFunctions;
import com.inet.mdns.Message;
import com.inet.mdns.Question;
import com.inet.mdns.ServiceListener;
import com.inet.mdns.record.AAAARecord;
import com.inet.mdns.record.ARecord;
import com.inet.mdns.record.PtrRecord;
import com.inet.mdns.record.Record;
import com.inet.mdns.record.SrvRecord;
import com.inet.mdns.record.TxtRecord;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.SocketOption;
import java.net.StandardProtocolFamily;
import java.net.StandardSocketOptions;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public abstract class AbstractMulticastDNS
implements AutoCloseable {
    private static final int PORT = 5353;
    private static final InetAddress a;
    private static final InetAddress b;
    private static final InetSocketAddress c;
    private static final InetSocketAddress d;
    private Selector e;
    private List<DatagramChannel> f = new ArrayList<DatagramChannel>();
    private Thread g;
    private boolean h;
    private Inet4Address i;
    private Inet6Address j;
    private ConcurrentHashMap<String, List<Record>> k = new ConcurrentHashMap();
    private Map<String, Collection<ServiceListener>> l = new HashMap<String, Collection<ServiceListener>>();
    private Map<String, String> m = new HashMap<String, String>();
    private String n = NetworkFunctions.getLocalHostName();

    public AbstractMulticastDNS() throws IOException {
        this.e = Selector.open();
        Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
        while (enumeration.hasMoreElements()) {
            NetworkInterface networkInterface = enumeration.nextElement();
            Enumeration<InetAddress> enumeration2 = networkInterface.getInetAddresses();
            if (networkInterface.isLoopback() || !networkInterface.supportsMulticast() || networkInterface.isVirtual() || !networkInterface.isUp()) continue;
            while (enumeration2.hasMoreElements()) {
                InetAddress inetAddress = enumeration2.nextElement();
                try {
                    StandardProtocolFamily standardProtocolFamily;
                    InetAddress inetAddress2;
                    if (inetAddress instanceof Inet4Address) {
                        inetAddress2 = a;
                        standardProtocolFamily = StandardProtocolFamily.INET;
                        if (this.i == null) {
                            this.i = (Inet4Address)inetAddress;
                        }
                    } else {
                        inetAddress2 = b;
                        standardProtocolFamily = StandardProtocolFamily.INET6;
                        if (this.j == null) {
                            this.j = (Inet6Address)inetAddress;
                        }
                    }
                    DatagramChannel datagramChannel = DatagramChannel.open(standardProtocolFamily);
                    datagramChannel.setOption((SocketOption)StandardSocketOptions.SO_REUSEADDR, Boolean.TRUE);
                    datagramChannel.setOption((SocketOption)StandardSocketOptions.IP_MULTICAST_IF, networkInterface);
                    datagramChannel.setOption((SocketOption)StandardSocketOptions.IP_MULTICAST_TTL, (Object)255);
                    datagramChannel.configureBlocking(false);
                    datagramChannel.join(inetAddress2, networkInterface);
                    datagramChannel.bind(new InetSocketAddress(5353));
                    datagramChannel.register(this.e, 1);
                    this.f.add(datagramChannel);
                }
                catch (Exception exception) {
                    this.logError(new RuntimeException("No broadcast was send to address: " + String.valueOf(inetAddress) + " on network interface: " + String.valueOf(networkInterface), exception));
                }
            }
        }
        this.g = new Thread("MulticastDNS listening"){

            @Override
            public void run() {
                AbstractMulticastDNS.this.a();
            }
        };
        this.g.setDaemon(true);
        this.g.start();
    }

    protected abstract void logError(Throwable var1);

    private void a() {
        block11: {
            try {
                byte[] byArray = new byte[2048];
                ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
                ArrayList<Record> arrayList = new ArrayList<Record>();
                while (!this.h) {
                    this.e.select();
                    for (SelectionKey selectionKey : this.e.selectedKeys()) {
                        Record record;
                        Object object;
                        List<Record> list;
                        Object object2;
                        byteBuffer.clear();
                        ((DatagramChannel)selectionKey.channel()).receive(byteBuffer);
                        Message message = Message.fromByteArray(byArray, byteBuffer.position());
                        for (Question question : message.getQuestions()) {
                            object2 = AbstractMulticastDNS.b(question.getName().toLowerCase());
                            list = this.k.get(object2);
                            if (list == null) continue;
                            object = list.iterator();
                            while (object.hasNext()) {
                                record = object.next();
                                arrayList.add(record);
                            }
                        }
                        ArrayList arrayList2 = new ArrayList();
                        arrayList2.addAll(message.a());
                        arrayList2.addAll(message.b());
                        Iterator iterator = arrayList2.iterator();
                        while (iterator.hasNext()) {
                            object2 = (Record)iterator.next();
                            if (!(object2 instanceof PtrRecord)) continue;
                            this.m.put(((PtrRecord)object2).getServiceName(), AbstractMulticastDNS.b(((Record)object2).getName()));
                        }
                        Iterator iterator2 = arrayList2.iterator();
                        while (iterator2.hasNext()) {
                            ServiceListener serviceListener;
                            Iterator iterator3;
                            object2 = (Record)iterator2.next();
                            if (!(object2 instanceof SrvRecord) && !(object2 instanceof TxtRecord) || (list = this.m.get(((Record)object2).getName())) == null || (object = this.l.get(list)) == null) continue;
                            if (object2 instanceof SrvRecord) {
                                record = (SrvRecord)object2;
                                iterator3 = object.iterator();
                                while (iterator3.hasNext()) {
                                    serviceListener = (ServiceListener)iterator3.next();
                                    serviceListener.onServiceReceived(record.getName(), ((SrvRecord)record).getTarget(), ((SrvRecord)record).getPort());
                                }
                                continue;
                            }
                            record = (TxtRecord)object2;
                            iterator3 = object.iterator();
                            while (iterator3.hasNext()) {
                                serviceListener = (ServiceListener)iterator3.next();
                                serviceListener.onTextReceived(record.getName(), ((TxtRecord)record).getText());
                            }
                        }
                        if (arrayList.size() <= 0) continue;
                        Message message2 = new Message();
                        message2.setFlags(33792);
                        message2.addAnswers(arrayList);
                        this.a(message2);
                        arrayList.clear();
                    }
                }
            }
            catch (Throwable throwable) {
                if (this.h) break block11;
                this.logError(throwable);
            }
        }
    }

    private static String a(String string, String string2) {
        if (string.endsWith(string2)) {
            return string.substring(0, string.length() - string2.length());
        }
        return string;
    }

    private void a(Message message) throws IOException {
        byte[] byArray = message.toByteArray();
        for (DatagramChannel datagramChannel : this.f) {
            InetAddress inetAddress = ((InetSocketAddress)datagramChannel.getLocalAddress()).getAddress();
            InetSocketAddress inetSocketAddress = inetAddress instanceof Inet4Address ? c : d;
            try {
                datagramChannel.send(ByteBuffer.wrap(byArray), inetSocketAddress);
            }
            catch (IOException iOException) {
                this.logError(iOException);
            }
        }
    }

    public void publishService(String type, String name, int port, String txt) throws IOException {
        String string = AbstractMulticastDNS.a(type);
        name = AbstractMulticastDNS.a(name);
        ArrayList<Record> arrayList = new ArrayList<Record>();
        arrayList.add(new PtrRecord(string, name));
        arrayList.add(new PtrRecord("_services._dns-sd._udp", string));
        arrayList.add(new SrvRecord(name, 0, 0, port, this.n));
        arrayList.add(new TxtRecord(name, txt));
        if (this.i != null) {
            arrayList.add(new ARecord(this.n, this.i));
        }
        if (this.j != null) {
            arrayList.add(new AAAARecord(this.n, this.j));
        }
        this.k.put(type, arrayList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queryService(String serviceName, ServiceListener listener) throws IOException {
        Message message = new Message();
        message.getQuestions().add(new Question(AbstractMulticastDNS.a(serviceName), 255, 1));
        Map<String, Collection<ServiceListener>> map = this.l;
        synchronized (map) {
            Collection<ServiceListener> collection = this.l.get(serviceName);
            if (collection == null) {
                collection = new LinkedList<ServiceListener>();
                this.l.put(serviceName, collection);
            }
            collection.add(listener);
        }
        this.a(message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeServiceListener(String serviceName, ServiceListener listener) {
        Map<String, Collection<ServiceListener>> map = this.l;
        synchronized (map) {
            Collection<ServiceListener> collection = this.l.get(serviceName);
            collection.remove(listener);
        }
    }

    private static String a(String object) {
        if (!((String)object).endsWith(".")) {
            object = (String)object + ".";
        }
        if (!((String)object).endsWith(".local.")) {
            object = (String)object + "local.";
        }
        return object;
    }

    private static String b(String string) {
        return AbstractMulticastDNS.a(AbstractMulticastDNS.a(string, "."), ".local");
    }

    @Override
    public void close() {
        this.h = true;
        try {
            this.e.close();
            for (DatagramChannel datagramChannel : this.f) {
                datagramChannel.close();
            }
        }
        catch (IOException iOException) {
            this.logError(iOException);
        }
    }

    static {
        InetAddress inetAddress = null;
        InetAddress inetAddress2 = null;
        try {
            inetAddress = InetAddress.getByName("224.0.0.251");
            inetAddress2 = InetAddress.getByName("FF02::FB");
        }
        catch (Throwable throwable) {
            throwable.printStackTrace(System.err);
        }
        a = inetAddress;
        b = inetAddress2;
        c = new InetSocketAddress(a, 5353);
        d = new InetSocketAddress(b, 5353);
    }
}

