/*
 * Decompiled with CFR 0.152.
 */
package com.inet.lib.json;

import com.inet.annotations.InternalApi;
import com.inet.lib.json.DeclaredField;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@InternalApi
public interface JsonWriterFilter {
    public static final JsonWriterFilter EXCLUDE_NULL = new ExcludeNullJsonWriterFilter();

    default public boolean fieldShouldBeIgnored(@Nonnull DeclaredField declaredField, @Nullable Object value) {
        return value == null && declaredField.isExcludeNull();
    }

    @Nonnull
    default public String transformFieldName(DeclaredField declaredField) {
        return declaredField.getName();
    }

    @Nullable
    default public Object transformValue(@Nonnull DeclaredField declaredField, @Nullable Object value) {
        return value;
    }

    public static class ExcludeNullJsonWriterFilter
    implements JsonWriterFilter {
        @Override
        public boolean fieldShouldBeIgnored(@Nonnull DeclaredField declaredField, @Nullable Object value) {
            return value == null;
        }
    }
}

