/*
 * Decompiled with CFR 0.152.
 */
package com.inet.error;

import com.inet.annotations.InternalApi;
import com.inet.error.ErrorCode;
import com.inet.error.HasErrorCode;
import com.inet.lib.util.StringFunctions;
import java.text.MessageFormat;
import java.util.Arrays;
import javax.annotation.Nonnull;

@InternalApi
public class BaseException
extends Exception
implements HasErrorCode {
    private final int a;

    public BaseException(@Nonnull ErrorCode errorCode, Throwable cause, Object ... parameters) {
        super(BaseException.a(errorCode, parameters), cause);
        this.a = errorCode == null ? 0 : errorCode.getErrorCodeNumber();
    }

    public BaseException(int errorNumber, String msg, Throwable cause, Object ... parameters) {
        super(BaseException.a(errorNumber, msg, parameters), cause);
        this.a = errorNumber;
    }

    public BaseException(Throwable cause, ErrorCode defaultErrorCode) {
        super(cause instanceof HasErrorCode ? cause.getMessage() : defaultErrorCode.getMsg(StringFunctions.getUserFriendlyErrorMessage(cause)), cause);
        this.a = cause instanceof HasErrorCode ? ((HasErrorCode)((Object)cause)).getErrorCode() : defaultErrorCode.getErrorCodeNumber();
    }

    @Nonnull
    private static String a(ErrorCode errorCode, Object ... objectArray) {
        if (errorCode != null) {
            return errorCode.getMsg(objectArray);
        }
        return Arrays.toString(objectArray);
    }

    @Nonnull
    private static String a(int n2, String string, Object ... objectArray) {
        ErrorCode errorCode = ErrorCode.valueOf(n2);
        if (errorCode != null) {
            return errorCode.getMsg(objectArray);
        }
        try {
            string = MessageFormat.format(string, objectArray);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }

    @Override
    public int getErrorCode() {
        return this.a;
    }
}

