/*
 * Decompiled with CFR 0.152.
 */
package com.inet.config;

import com.inet.annotations.PublicApi;
import com.inet.config.ConfigKey;
import com.inet.lib.json.Json;
import java.util.Map;
import java.util.Properties;
import java.util.prefs.BackingStoreException;
import javax.annotation.Nonnull;

@PublicApi
public interface Configuration
extends Comparable {
    public static final int SCOPE_SYSTEM = 1;
    public static final int SCOPE_USER = 2;
    public static final int SCOPE_TEMP = 4;
    public static final String NAME_TEMP = "<temp copy>";

    public String getName();

    public int getScope();

    public String get(String var1);

    public String get(String var1, String var2);

    default public String get(ConfigKey key) {
        return this.get(key.getKey(), key.getDefault());
    }

    default public <T> T getValue(ConfigKey key) {
        return key.convert(this.get(key));
    }

    public void put(String var1, String var2);

    default public void put(@Nonnull ConfigKey key, String value) {
        this.put(key.getKey(), value);
    }

    default public void putValue(@Nonnull ConfigKey key, Object value) {
        if (value == null) {
            this.put(key, null);
            return;
        }
        key.getType().cast(value);
        this.put(key, new Json().toJson(value));
    }

    public Properties getProperties();

    public String toString();

    public void putAll(Map var1);

    @Deprecated
    public void putAll(Map var1, boolean var2);

    public String getDescription();

    public void setDescription(String var1);

    public boolean equals(Object var1);

    public int compareTo(Object var1);

    public void clear();

    public boolean isEmpty();

    public void flush() throws BackingStoreException;
}

