/*
 * Decompiled with CFR 0.152.
 */
package com.inet.cache.internal;

import com.inet.annotations.InternalApi;
import com.inet.cache.CacheManager;
import com.inet.cache.internal.ExternalData;
import com.inet.cache.internal.ExternalDataWriterFactory;
import com.inet.cache.internal.e;
import com.inet.cache.shutdown.ShutdownManager;
import java.io.File;
import java.security.AccessController;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nullable;
import javax.annotation.SuppressFBWarnings;

@InternalApi
public class HardDiskExternalDataWriterFactory<K, V>
extends ExternalDataWriterFactory<K, V> {
    public static final int SWAP_FILE_SIZE = 5000000;
    private static final Set<File> a = ConcurrentHashMap.newKeySet();
    private static File b;
    private final File c;
    @Nullable
    private e<K, V> d;
    private final ReentrantReadWriteLock e = new ReentrantReadWriteLock();

    public HardDiskExternalDataWriterFactory(@Nullable File directory) throws IllegalStateException {
        if (directory == null) {
            directory = HardDiskExternalDataWriterFactory.getDefaultDir();
        }
        this.c = directory;
        HardDiskExternalDataWriterFactory.a(directory);
    }

    private static void a(File file) throws IllegalStateException {
        if (a.add(file)) {
            File[] fileArray = file.listFiles();
            if (fileArray != null) {
                for (File file2 : fileArray) {
                    String string = file2.getName();
                    if (!string.startsWith("inet") || !string.endsWith(".data")) continue;
                    file2.delete();
                }
            }
            CacheManager.checkHardDiskSpace(file, 256, "hard disk cache");
        }
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="The default directory is determined using the java temporary directory, the user name and an internal prefix.")
    public static File getDefaultDir() {
        if (b == null) {
            b = AccessController.doPrivileged(() -> {
                String string = System.getProperty("java.io.tmpdir");
                String string2 = System.getProperty("user.name");
                File file = new File(new File(string), "com.inet.cache-" + string2);
                file.mkdirs();
                return file;
            });
        }
        return b;
    }

    public static long freeSpace(File file) {
        long l2 = 0L;
        while (file != null && (l2 = file.getFreeSpace()) == 0L) {
            file = file.getParentFile();
        }
        return l2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    ExternalData<K, V> a(K k2, V v) throws Exception {
        Object object;
        if (this.d == null) {
            this.e.writeLock().lock();
            try {
                if (this.d == null) {
                    this.d = new e(this.c);
                    ShutdownManager.add(this.d);
                }
            }
            finally {
                this.e.writeLock().unlock();
            }
        }
        if (this.d.b() > 5000000L && this.e.writeLock().tryLock()) {
            try {
                if (this.d.b() > 5000000L) {
                    object = this.d;
                    this.d = new e(this.c);
                    ShutdownManager.add(this.d);
                    ((e)object).a();
                }
            }
            finally {
                this.e.writeLock().unlock();
            }
        }
        this.e.readLock().lock();
        try {
            object = this.d.a(k2, v);
            return object;
        }
        finally {
            this.e.readLock().unlock();
        }
    }

    @Override
    void a() {
        e<K, V> e2 = this.d;
        if (e2 == null) {
            return;
        }
        this.e.writeLock().lock();
        try {
            e2.onShutdown();
        }
        finally {
            this.e.writeLock().unlock();
        }
        ShutdownManager.remove(e2);
    }
}

