/*
 * Decompiled with CFR 0.152.
 */
package com.inet.authentication;

import com.inet.annotations.InternalApi;
import com.inet.authentication.LoginProcessor;
import com.inet.classloader.BaseLocator;
import com.inet.classloader.LoaderUtils;
import com.inet.config.ConfigKey;
import com.inet.config.ConfigValue;
import com.inet.config.Configuration;
import com.inet.config.ConfigurationManager;
import com.inet.lib.io.UTF8StreamWriter;
import com.inet.lib.util.Encryption;
import com.inet.lib.util.IOFunctions;
import com.inet.plugin.fs.FileResourceFile;
import com.inet.plugin.fs.ResourceFile;
import com.inet.shared.servlet.ServletUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Base64;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.SuppressFBWarnings;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

@InternalApi
public class MasterLoginData
implements Serializable {
    private static final String FILENAME = "remotelogin.xml";
    private static final ConfigValue<byte[][]> a = new ConfigValue<byte[][]>(ConfigKey.MASTER_PASSWORD){

        @Override
        protected byte[][] convert(@Nonnull String strValue) throws IllegalArgumentException {
            return MasterLoginData.a(strValue);
        }
    };
    private static final long serialVersionUID = 1L;
    private byte[] b;
    private byte[] c;
    private byte[][] d;
    private final File e;
    @Nullable
    private final Configuration f;
    private static boolean g = true;

    MasterLoginData(URL passwordFileURL, File installDir, @Nullable Configuration config) {
        this.e = installDir;
        this.f = config;
        this.a(passwordFileURL);
        this.d = config == null ? a.get() : MasterLoginData.a(config.get(ConfigKey.MASTER_PASSWORD));
    }

    private static byte @Nullable [][] a(@Nullable String string) {
        if (string == null) {
            return null;
        }
        String[] stringArray = string.split(":", 2);
        if (stringArray.length == 2) {
            try {
                byte[][] byArrayArray = new byte[][]{Base64.getDecoder().decode(stringArray[0]), Base64.getDecoder().decode(stringArray[1])};
                return byArrayArray;
            }
            catch (Exception exception) {
                LoginProcessor.LOGGER.error(exception);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"XXE_DOCUMENT", "URLCONNECTION_SSRF_FD"}, justification="By same software created document will be parsed.")
    private void a(URL uRL) {
        if (uRL != null) {
            InputStream inputStream = null;
            try {
                NamedNodeMap namedNodeMap;
                DocumentBuilder documentBuilder = LoaderUtils.newDocumentBuilderFactory().newDocumentBuilder();
                inputStream = uRL.openStream();
                Document document = documentBuilder.parse(inputStream);
                Element element = document.getDocumentElement();
                NodeList nodeList = element.getElementsByTagName("password");
                Node node = nodeList.item(0);
                if (node != null && (namedNodeMap = node.getAttributes()) != null) {
                    for (int i2 = 0; i2 < namedNodeMap.getLength(); ++i2) {
                        Node node2 = namedNodeMap.item(i2);
                        if (node2.getNodeName().equalsIgnoreCase("encryptedvalue")) {
                            this.b = Base64.getDecoder().decode(node2.getNodeValue().trim());
                        }
                        if (node2.getNodeName().equalsIgnoreCase("encryptedsalt")) {
                            this.c = Base64.getDecoder().decode(node2.getNodeValue().trim());
                        }
                        if (!node2.getNodeName().equalsIgnoreCase("value")) continue;
                        String string = node2.getNodeValue().trim();
                        this.setPassword(Encryption.decrypt(string));
                    }
                }
            }
            catch (ParserConfigurationException parserConfigurationException) {
                LoginProcessor.LOGGER.error(parserConfigurationException);
            }
            catch (SAXException sAXException) {
                LoginProcessor.LOGGER.error(sAXException);
            }
            catch (IOException iOException) {
                LoginProcessor.LOGGER.error(iOException);
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    public boolean isPasswordSet() {
        if (this.d != null) {
            return true;
        }
        return this.b != null && this.b.length > 0 && this.c != null && this.c.length > 0;
    }

    public Exception setPassword(String password) {
        if (password == null || password.length() == 0) {
            this.c = null;
            this.b = null;
            new File(this.e, FILENAME).delete();
            Configuration configuration = this.f;
            if (configuration == null) {
                configuration = ConfigurationManager.getInstance().getCurrent();
            }
            configuration.put(ConfigKey.MASTER_PASSWORD.getKey(), null);
            return null;
        }
        SecureRandom secureRandom = new SecureRandom();
        byte[] byArray = new byte[20];
        secureRandom.nextBytes(byArray);
        MessageDigest messageDigest = null;
        try {
            messageDigest = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            LoginProcessor.LOGGER.error(noSuchAlgorithmException);
            return noSuchAlgorithmException;
        }
        messageDigest.reset();
        messageDigest.update(byArray);
        byte[] byArray2 = null;
        byArray2 = messageDigest.digest(password.getBytes(StandardCharsets.UTF_8));
        this.c = byArray;
        this.b = byArray2;
        g = true;
        return this.a();
    }

    public boolean isCorrectPassword(String enteredPassword) {
        byte[] byArray;
        MessageDigest messageDigest = null;
        try {
            messageDigest = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            LoginProcessor.LOGGER.error(noSuchAlgorithmException);
            return false;
        }
        if (this.d != null) {
            messageDigest.reset();
            messageDigest.update(this.d[1]);
            byArray = messageDigest.digest(enteredPassword.getBytes(StandardCharsets.UTF_8));
            if (Arrays.equals(byArray, this.d[0])) {
                return true;
            }
        }
        if (this.c == null || this.b == null) {
            return false;
        }
        messageDigest.reset();
        messageDigest.update(this.c);
        byArray = messageDigest.digest(enteredPassword.getBytes(StandardCharsets.UTF_8));
        return Arrays.equals(byArray, this.b);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Exception a() {
        File file = new File(this.e, FILENAME);
        File file2 = new File(this.e, "remotelogin.xml.backup");
        if (file.exists()) {
            if (!file.renameTo(file2)) {
                return new IOException("Creating backup failed");
            }
            file = new File(FILENAME);
        }
        if (LoginProcessor.LOGGER.isInfo()) {
            LoginProcessor.LOGGER.info("Saving remotelogin.xml at " + file.getAbsolutePath());
        }
        String string = Base64.getEncoder().encodeToString(this.b);
        String string2 = Base64.getEncoder().encodeToString(this.c);
        Configuration configuration = this.f == null ? ConfigurationManager.getInstance().getCurrent() : this.f;
        PrintWriter printWriter = null;
        boolean bl = false;
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            UTF8StreamWriter uTF8StreamWriter = new UTF8StreamWriter(fileOutputStream);
            printWriter = new PrintWriter((Writer)uTF8StreamWriter, true);
            printWriter.print("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
            printWriter.print("<remoteinterface>\n");
            printWriter.print("\t<password");
            printWriter.print(" encryptedvalue=\"");
            printWriter.print(string);
            printWriter.print("\" encryptedsalt=\"");
            printWriter.print(string2);
            printWriter.print("\" ");
            printWriter.print("/>\n");
            printWriter.print("</remoteinterface>");
            printWriter.close();
        }
        catch (Exception exception) {
            bl = true;
            LoginProcessor.LOGGER.error(exception);
            Exception exception2 = exception;
            return exception2;
        }
        finally {
            configuration.put(ConfigKey.MASTER_PASSWORD.getKey(), string + ":" + string2);
            if (printWriter != null) {
                printWriter.close();
            }
            if (bl) {
                if (file.exists()) {
                    file.delete();
                }
                if (file2.exists()) {
                    file2.renameTo(file);
                }
            }
        }
        if (file2.exists()) {
            file2.delete();
        }
        return null;
    }

    public static MasterLoginData getLoginData() {
        return MasterLoginData.getLoginData(null);
    }

    public static MasterLoginData getLoginData(@Nullable Configuration config) {
        URL uRL = null;
        try {
            uRL = MasterLoginData.b();
            if (g) {
                g = false;
                if (LoginProcessor.LOGGER.isInfo()) {
                    if (uRL == null) {
                        LoginProcessor.LOGGER.info("No remotelogin.xml found.");
                    } else {
                        LoginProcessor.LOGGER.info("Reading remotelogin.xml from: " + uRL.toExternalForm());
                    }
                }
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        File file = null;
        try {
            if (uRL != null) {
                file = IOFunctions.getFile(uRL).getParentFile();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new MasterLoginData(uRL, file, config);
    }

    private static URL b() throws MalformedURLException {
        File file = new File(FILENAME);
        boolean bl = false;
        try {
            bl = file.exists();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!bl) {
            ResourceFile resourceFile = BaseLocator.getBaseDirectory();
            File file2 = resourceFile instanceof FileResourceFile ? ((FileResourceFile)resourceFile).getFile() : null;
            file = new File(file2, FILENAME);
            if (g && LoginProcessor.LOGGER.isInfo()) {
                LoginProcessor.LOGGER.info("baseDirectory: " + (file2 == null ? "null" : file2.getAbsolutePath()));
            }
            try {
                bl = file.exists();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!bl) {
            if (ServletUtils.getServletContext() != null) {
                return ServletUtils.getServletContext().getResource("/remotelogin.xml");
            }
            return null;
        }
        return file.toURI().toURL();
    }
}

