/*
 * Decompiled with CFR 0.152.
 */
package com.inet.usersandgroups.api.user.search;

import com.inet.annotations.InternalApi;
import com.inet.error.ErrorCode;
import com.inet.field.Field;
import com.inet.id.GUID;
import com.inet.permissions.Permission;
import com.inet.plugin.DynamicExtensionListener;
import com.inet.plugin.DynamicExtensionManager;
import com.inet.plugin.ServerPluginManager;
import com.inet.search.AbstractSearchDataCache;
import com.inet.search.SearchDataCacheChangeListener;
import com.inet.search.SearchTag;
import com.inet.usersandgroups.api.UserField;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import com.inet.usersandgroups.api.user.persistence.UserPersistence;
import com.inet.usersandgroups.api.user.search.a;
import com.inet.usersandgroups.user.search.SearchTagActive;
import com.inet.usersandgroups.user.search.SearchTagAuthGroupName;
import com.inet.usersandgroups.user.search.SearchTagLastAccess;
import com.inet.usersandgroups.user.search.SearchTagLocked;
import com.inet.usersandgroups.user.search.SearchTagLoginId;
import com.inet.usersandgroups.user.search.SearchTagLoginSettings;
import com.inet.usersandgroups.user.search.SearchTagUserAccountDisplayName;
import com.inet.usersandgroups.user.search.SearchTagUserAccountId;
import com.inet.usersandgroups.user.search.SearchTagUserAccountType;
import com.inet.usersandgroups.user.search.SearchTagUserPermissions;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

@InternalApi
public class UserSearchDataCache
extends AbstractSearchDataCache<GUID> {
    private UserPersistence a;
    private List<SearchTag> b;
    private static Map<String, UserField> c;

    public UserSearchDataCache(UserPersistence persistence) {
        if (persistence == null) {
            throw new IllegalArgumentException("persistence must not be null");
        }
        this.a = persistence;
    }

    List<SearchTag> a() {
        while (this.b == null && !ServerPluginManager.getInstance().isInitFinish()) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {
                throw (RuntimeException)ErrorCode.throwAny(interruptedException);
            }
        }
        if (this.b == null) {
            List list = c.values().stream().filter(userField -> userField.getSearchTag() != null).map(Field::getSearchTag).collect(Collectors.toList());
            list.add(new SearchTagUserAccountId());
            list.add(new SearchTagActive());
            list.add(new SearchTagLocked());
            list.add(new SearchTagLoginSettings());
            list.add(new SearchTagLoginId());
            list.add(new SearchTagAuthGroupName());
            list.add(new SearchTagUserAccountType());
            list.add(new SearchTagUserPermissions());
            list.add(new SearchTagLastAccess());
            list.add(new SearchTagUserAccountDisplayName());
            this.b = Collections.unmodifiableList(list);
        }
        return this.b;
    }

    @Override
    public Map<String, Object> getCacheEntry(@Nonnull GUID accountID) {
        UserAccount userAccount = this.a.load(accountID);
        if (userAccount == null) {
            return null;
        }
        return this.toMap(userAccount, true);
    }

    @Override
    public Iterator<GUID> iterator() {
        return this.a.getUserAccountIdIterator();
    }

    public void userCreated(UserAccount userAccount) {
        SearchDataCacheChangeListener<ID>[] searchDataCacheChangeListenerArray;
        GUID gUID = userAccount.getID();
        Map<String, Object> map = this.toMap(userAccount, false);
        for (SearchDataCacheChangeListener<GUID> searchDataCacheChangeListener : searchDataCacheChangeListenerArray = this.getListeners()) {
            searchDataCacheChangeListener.entryAdded(gUID, map);
        }
    }

    public void userDeleted(UserAccount userAccount, Set<String> authGroupNames) {
        SearchDataCacheChangeListener<ID>[] searchDataCacheChangeListenerArray;
        GUID gUID = userAccount.getID();
        a a2 = new a(userAccount, c, authGroupNames);
        for (SearchDataCacheChangeListener<GUID> searchDataCacheChangeListener : searchDataCacheChangeListenerArray = this.getListeners()) {
            searchDataCacheChangeListener.entryRemoved(gUID, a2);
        }
    }

    public void userUpdated(UserAccount oldUserAccount, UserAccount newUserAccount) {
        SearchDataCacheChangeListener<ID>[] searchDataCacheChangeListenerArray;
        GUID gUID = oldUserAccount.getID();
        Map<String, Object> map = this.toMap(oldUserAccount, false);
        Map<String, Object> map2 = this.toMap(newUserAccount, false);
        for (SearchDataCacheChangeListener<GUID> searchDataCacheChangeListener : searchDataCacheChangeListenerArray = this.getListeners()) {
            searchDataCacheChangeListener.entryChanged(gUID, map, map2);
        }
    }

    public void userAuthGroupNamesUpdated(GUID accountID, Set<String> oldAuthGroupNames, Set<String> newAuthGroupNames) {
        SearchDataCacheChangeListener<ID>[] searchDataCacheChangeListenerArray;
        Map<String, Object> map = Collections.singletonMap("authgroupname", oldAuthGroupNames);
        Map<String, Object> map2 = Collections.singletonMap("authgroupname", newAuthGroupNames);
        for (SearchDataCacheChangeListener<GUID> searchDataCacheChangeListener : searchDataCacheChangeListenerArray = this.getListeners()) {
            searchDataCacheChangeListener.entryChanged(accountID, map, map2);
        }
    }

    public void userAccountLastAccessUpdated(GUID accountID, long oldValue, long newValue) {
        SearchDataCacheChangeListener<ID>[] searchDataCacheChangeListenerArray;
        Map<String, Object> map = Collections.singletonMap("lastaccess", oldValue);
        Map<String, Object> map2 = Collections.singletonMap("lastaccess", newValue);
        for (SearchDataCacheChangeListener<GUID> searchDataCacheChangeListener : searchDataCacheChangeListenerArray = this.getListeners()) {
            searchDataCacheChangeListener.entryChanged(accountID, map, map2);
        }
    }

    @Nonnull
    protected Map<String, Object> toMap(UserAccount userAccount, boolean hasAuthGroupNames) {
        return new a(userAccount, c, hasAuthGroupNames ? this.a : null);
    }

    public void indexAllPermissionsForMasterUser() {
        SearchDataCacheChangeListener<ID>[] searchDataCacheChangeListenerArray;
        Map<String, Object> map = Collections.emptyMap();
        HashSet<Permission> hashSet = new HashSet<Permission>(Arrays.asList(Permission.values()));
        Map<String, Object> map2 = Collections.singletonMap("permissions", hashSet);
        for (SearchDataCacheChangeListener<GUID> searchDataCacheChangeListener : searchDataCacheChangeListenerArray = this.getListeners()) {
            searchDataCacheChangeListener.entryChanged(UserManager.MASTER_ACCOUNT_ID, map, map2);
        }
    }

    static {
        DynamicExtensionManager dynamicExtensionManager = DynamicExtensionManager.getInstance();
        DynamicExtensionListener<UserField> dynamicExtensionListener = new DynamicExtensionListener<UserField>(){

            @Override
            public void valuesChanged(@Nonnull List<UserField> userFields) {
                HashMap<String, UserField> hashMap = new HashMap<String, UserField>();
                for (UserField userField : userFields) {
                    hashMap.put(userField.getKey(), userField);
                }
                c = hashMap;
            }
        };
        dynamicExtensionManager.registerListener(UserField.class, dynamicExtensionListener);
        dynamicExtensionListener.valuesChanged(dynamicExtensionManager.get(UserField.class));
    }
}

