/*
 * Decompiled with CFR 0.152.
 */
package com.inet.usersandgroups.api.ui.fields.group;

import com.inet.lib.json.Json;
import com.inet.usersandgroups.api.groups.UserGroupInfo;
import com.inet.usersandgroups.api.groups.UserGroupManager;
import com.inet.usersandgroups.api.ui.fields.group.GroupFieldDefinition;
import com.inet.usersandgroups.api.ui.fields.values.FieldValue;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;

public abstract class StringListGroupFieldDefinition
extends GroupFieldDefinition<List<String>> {
    public StringListGroupFieldDefinition(String groupKey, String fieldKey, int prio) {
        super(groupKey, fieldKey, "fieldtype_string_list", prio);
    }

    public StringListGroupFieldDefinition(String groupKey, String fieldKey, String displayType, int prio) {
        super(groupKey, fieldKey, displayType, prio);
    }

    @Override
    public FieldValue getFieldValue(UserGroupInfo userGroup) {
        String string = "";
        if (userGroup != null) {
            string = (String)userGroup.getValue(UserGroupManager.getRecoveryEnabledInstance().getField(this.getFieldKey()));
        }
        Object object = this.convertFromString(string);
        FieldValue fieldValue = new FieldValue(new Json().toJson(object));
        fieldValue.setVisibleInPreview(object != null && object.size() > 0);
        return fieldValue;
    }

    @Override
    public List<String> convertFromString(String value) {
        return new Json().fromJson(value, ArrayList.class, new Type[]{String.class});
    }
}

