/*
 * Decompiled with CFR 0.152.
 */
package com.inet.usersandgroups.api.ui.fields.group;

import com.inet.lib.json.Json;
import com.inet.usersandgroups.UsersAndGroups;
import com.inet.usersandgroups.api.groups.UserGroupInfo;
import com.inet.usersandgroups.api.groups.UserGroupManager;
import com.inet.usersandgroups.api.ui.fields.group.GroupFieldDefinition;
import com.inet.usersandgroups.api.ui.fields.values.FieldValue;
import java.util.ArrayList;
import java.util.List;

public abstract class IntegerListGroupFieldDefinition
extends GroupFieldDefinition<List<Integer>> {
    public IntegerListGroupFieldDefinition(String groupKey, String fieldKey, int prio) {
        super(groupKey, fieldKey, "fieldtype_integer_list", prio);
    }

    public IntegerListGroupFieldDefinition(String groupKey, String fieldKey, String displayType, int prio) {
        super(groupKey, fieldKey, displayType, prio);
    }

    @Override
    public FieldValue getFieldValue(UserGroupInfo groupInfo) {
        String string = "";
        if (groupInfo != null) {
            string = (String)groupInfo.getValue(UserGroupManager.getRecoveryEnabledInstance().getField(this.getFieldKey()));
        }
        Object object = this.convertFromString(string);
        FieldValue fieldValue = new FieldValue(new Json().toJson(object));
        fieldValue.setVisibleInPreview(object != null && object.size() > 0);
        return fieldValue;
    }

    @Override
    public List<Integer> convertFromString(String value) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        if (value != null && !value.isEmpty()) {
            String[] stringArray;
            for (String string : stringArray = value.replace(',', ';').split(";")) {
                try {
                    arrayList.add(Integer.valueOf(string));
                }
                catch (NumberFormatException numberFormatException) {
                    UsersAndGroups.LOGGER.error(numberFormatException);
                }
            }
        }
        return arrayList;
    }
}

