/*
 * Decompiled with CFR 0.152.
 */
package com.inet.usersandgroups.api.takeout;

import com.inet.annotations.InternalApi;
import com.inet.authentication.AuthenticationDescription;
import com.inet.authentication.SystemAuthenticationProvider;
import com.inet.authentication.base.LoginManager;
import com.inet.usersandgroups.UsersAndGroups;
import com.inet.usersandgroups.api.takeout.TakeoutData;
import com.inet.usersandgroups.api.takeout.TakeoutDataEntry;
import com.inet.usersandgroups.api.takeout.TakeoutDataProvider;
import com.inet.usersandgroups.api.takeout.TextTakeoutDataEntry;
import com.inet.usersandgroups.api.user.LoginSettings;
import com.inet.usersandgroups.api.user.UserAccount;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;

@InternalApi
public class LoginsTakeoutDataProvider
implements TakeoutDataProvider {
    @Override
    public List<TakeoutData> getTakeoutData(@Nonnull UserAccount userAccount) {
        List<LoginSettings> list = userAccount.getLoginSettings();
        ArrayList<TakeoutDataEntry> arrayList = new ArrayList<TakeoutDataEntry>();
        for (LoginSettings loginSettings : list) {
            String string = loginSettings.getLoginSource();
            String string2 = null;
            List<AuthenticationDescription> list2 = LoginManager.getAllAuthenticationDescriptions();
            for (AuthenticationDescription authenticationDescription : list2) {
                if ("system".equals(string) && authenticationDescription.getProvider() instanceof SystemAuthenticationProvider) {
                    string2 = authenticationDescription.getDisplayName();
                    break;
                }
                if (!Objects.equals(string, authenticationDescription.getName())) continue;
                string2 = authenticationDescription.getDisplayName();
                break;
            }
            if (string2 == null) continue;
            String string3 = loginSettings.getLoginID();
            arrayList.add(new TextTakeoutDataEntry(string2, string3));
        }
        return Collections.singletonList(new TakeoutData(UsersAndGroups.MSG.getMsg("usersandgroupsmanager.fieldPanelDefinition.logins.name", new Object[0]), null, arrayList, 41));
    }

    @Override
    public int getPriority() {
        return 41;
    }
}

