/*
 * Decompiled with CFR 0.152.
 */
package com.inet.usersandgroups.api.takeout;

import com.inet.annotations.InternalApi;
import com.inet.lib.util.StringFunctions;
import com.inet.usersandgroups.api.takeout.TakeoutDataRenderer;
import com.inet.usersandgroups.api.ui.fields.values.CurrencyFieldValue;
import com.inet.usersandgroups.api.ui.fields.values.FieldValue;
import java.text.DecimalFormat;

@InternalApi
public class CurrencyTakeoutDataRenderer
implements TakeoutDataRenderer {
    @Override
    public String getExtensionName() {
        return "fieldtype_currency";
    }

    @Override
    public String render(FieldValue fieldValue) {
        CurrencyFieldValue currencyFieldValue = (CurrencyFieldValue)fieldValue;
        try {
            if (StringFunctions.isEmpty(currencyFieldValue.getValue())) {
                return null;
            }
            double d2 = Double.parseDouble(currencyFieldValue.getValue());
            DecimalFormat decimalFormat = new DecimalFormat("0.00");
            return decimalFormat.format(d2) + " " + currencyFieldValue.getCurrencysymbol();
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }
}

