/*
 * Decompiled with CFR 0.152.
 */
package com.inet.usersandgroups.api;

import com.inet.config.ConfigurationManager;
import com.inet.error.ErrorCode;
import com.inet.logging.LogManager;
import com.inet.persistence.Persistence;
import com.inet.plugin.ServerPluginManager;
import com.inet.search.veto.SearchIndexVeto;
import com.inet.usersandgroups.api.UserGroupField;
import com.inet.usersandgroups.api.UserGroupManagerFactory;
import com.inet.usersandgroups.api.groups.BaseUserGroupManager;
import com.inet.usersandgroups.api.groups.GroupTypeDef;
import com.inet.usersandgroups.api.groups.PredefinedUserGroup;
import com.inet.usersandgroups.api.groups.UserGroupEventListener;
import com.inet.usersandgroups.api.groups.UserGroupManager;
import com.inet.usersandgroups.api.groups.persistence.FileSystemUserGroupPersistence;
import com.inet.usersandgroups.api.groups.search.UserGroupSearchEngine;
import com.inet.usersandgroups.api.user.UserManager;
import java.util.List;

public class BaseUserGroupManagerFactory
implements UserGroupManagerFactory {
    @Override
    public UserGroupManager createManager(boolean useOriginalInRecoveryMode, SearchIndexVeto searchIndexVeto) {
        Persistence persistence = useOriginalInRecoveryMode ? Persistence.getRecoveryEnabledInstance() : Persistence.getInstance();
        FileSystemUserGroupPersistence fileSystemUserGroupPersistence = new FileSystemUserGroupPersistence(persistence);
        UserGroupSearchEngine userGroupSearchEngine = new UserGroupSearchEngine(useOriginalInRecoveryMode);
        userGroupSearchEngine.setSearchIndexVeto(searchIndexVeto);
        UserManager userManager = useOriginalInRecoveryMode ? UserManager.getRecoveryEnabledInstance() : UserManager.getInstance();
        BaseUserGroupManager baseUserGroupManager = new BaseUserGroupManager(fileSystemUserGroupPersistence, userGroupSearchEngine, userManager);
        ServerPluginManager serverPluginManager = ServerPluginManager.getInstance();
        List<GroupTypeDef> list = serverPluginManager.get(GroupTypeDef.class);
        List<UserGroupField<Object>> list2 = serverPluginManager.get(UserGroupField.class);
        List<PredefinedUserGroup> list3 = serverPluginManager.get(PredefinedUserGroup.class);
        try {
            baseUserGroupManager.init(list, list2, list3);
        }
        catch (Exception exception) {
            LogManager.getConfigLogger().fatal(exception);
            ErrorCode.throwAny(exception);
        }
        if ((ConfigurationManager.isHelpCenterMode() || ConfigurationManager.isRecoveryMode()) && !useOriginalInRecoveryMode) {
            baseUserGroupManager.disableLoggingEvents();
            return baseUserGroupManager;
        }
        serverPluginManager.get(UserGroupEventListener.class).forEach(userGroupEventListener -> baseUserGroupManager.registerListener((UserGroupEventListener)userGroupEventListener));
        return baseUserGroupManager;
    }
}

