/*
 * Decompiled with CFR 0.152.
 */
package com.inet.usersandgroups;

import com.inet.id.GUID;
import com.inet.lib.json.Json;
import com.inet.logging.EventLog;
import com.inet.logging.LogManager;
import com.inet.usersandgroups.UsersAndGroups;
import com.inet.usersandgroups.api.groups.UserGroupInfo;
import com.inet.usersandgroups.api.groups.UserGroupManager;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import java.util.Locale;
import java.util.Properties;

public final class UsersAndGroupsEventLog
extends Enum<UsersAndGroupsEventLog> {
    public static final /* enum */ UsersAndGroupsEventLog UserCreated = new UsersAndGroupsEventLog();
    public static final /* enum */ UsersAndGroupsEventLog UserDeleted = new UsersAndGroupsEventLog();
    public static final /* enum */ UsersAndGroupsEventLog UserDeactivated = new UsersAndGroupsEventLog();
    public static final /* enum */ UsersAndGroupsEventLog UserReactivated = new UsersAndGroupsEventLog();
    public static final /* enum */ UsersAndGroupsEventLog UserPermissionsAdded = new UsersAndGroupsEventLog();
    public static final /* enum */ UsersAndGroupsEventLog UserPermissionsRemoved = new UsersAndGroupsEventLog();
    public static final /* enum */ UsersAndGroupsEventLog UserLoginAdded = new UsersAndGroupsEventLog();
    public static final /* enum */ UsersAndGroupsEventLog UserLoginRemoved = new UsersAndGroupsEventLog();
    public static final /* enum */ UsersAndGroupsEventLog UserDataChanged = new UsersAndGroupsEventLog();
    public static final /* enum */ UsersAndGroupsEventLog UserDataTakeOut = new UsersAndGroupsEventLog();
    public static final /* enum */ UsersAndGroupsEventLog UserGroupAdded = new UsersAndGroupsEventLog();
    public static final /* enum */ UsersAndGroupsEventLog UserGroupRemoved = new UsersAndGroupsEventLog();
    public static final /* enum */ UsersAndGroupsEventLog UserLocked = new UsersAndGroupsEventLog();
    public static final /* enum */ UsersAndGroupsEventLog UserUnlocked = new UsersAndGroupsEventLog();
    public static final /* enum */ UsersAndGroupsEventLog UserBlockingNoticeSet = new UsersAndGroupsEventLog();
    public static final /* enum */ UsersAndGroupsEventLog UserBlockingNoticeRemoved = new UsersAndGroupsEventLog();
    public static final /* enum */ UsersAndGroupsEventLog GroupCreated = new UsersAndGroupsEventLog();
    public static final /* enum */ UsersAndGroupsEventLog GroupDeactivated = new UsersAndGroupsEventLog();
    public static final /* enum */ UsersAndGroupsEventLog GroupDeleted = new UsersAndGroupsEventLog();
    public static final /* enum */ UsersAndGroupsEventLog GroupMemberAdded = new UsersAndGroupsEventLog();
    public static final /* enum */ UsersAndGroupsEventLog GroupMemberRemoved = new UsersAndGroupsEventLog();
    public static final /* enum */ UsersAndGroupsEventLog GroupPermissionsAdded = new UsersAndGroupsEventLog();
    public static final /* enum */ UsersAndGroupsEventLog GroupPermissionsRemoved = new UsersAndGroupsEventLog();
    public static final /* enum */ UsersAndGroupsEventLog GroupDataChanged = new UsersAndGroupsEventLog();
    public static final /* enum */ UsersAndGroupsEventLog DataRestoredFromBackup = new UsersAndGroupsEventLog();
    private static final EventLog<UsersAndGroupsEventLog> a;
    private static final /* synthetic */ UsersAndGroupsEventLog[] b;

    public static UsersAndGroupsEventLog[] values() {
        return (UsersAndGroupsEventLog[])b.clone();
    }

    public static UsersAndGroupsEventLog valueOf(String name) {
        return Enum.valueOf(UsersAndGroupsEventLog.class, name);
    }

    public void log(GUID id, String displayname, Object ... extraParams) {
        Object object;
        Object object2;
        Object[] objectArray;
        String string;
        Properties properties = new Properties();
        String string2 = string = id == null ? null : id.toString();
        if (string != null) {
            properties.setProperty("id", string);
        }
        switch (this) {
            case UserPermissionsAdded: 
            case UserPermissionsRemoved: 
            case GroupPermissionsAdded: 
            case GroupPermissionsRemoved: {
                properties.setProperty("permissions", extraParams[0].toString());
                break;
            }
            case UserDataChanged: 
            case GroupDataChanged: {
                properties.setProperty("field", extraParams[0].toString());
                if (extraParams.length > 1) {
                    properties.setProperty("new", String.valueOf(extraParams[1]));
                }
                if (extraParams.length <= 2) break;
                properties.setProperty("old", String.valueOf(extraParams[2]));
                break;
            }
            case UserLoginAdded: 
            case UserLoginRemoved: {
                properties.setProperty("login", extraParams[0].toString());
                break;
            }
            case GroupCreated: 
            case GroupDeactivated: 
            case GroupDeleted: {
                properties.setProperty("name", extraParams[0].toString());
                properties.setProperty("type", extraParams[1].toString());
                break;
            }
            case GroupMemberAdded: 
            case GroupMemberRemoved: {
                properties.setProperty("account", extraParams[0].toString());
                try {
                    objectArray = GUID.valueOf(extraParams[0].toString());
                    object2 = UserManager.getRecoveryEnabledInstance().getUserAccount((GUID)objectArray);
                    object = object2 != null ? ((UserAccount)object2).getDisplayName() : objectArray.toString();
                    extraParams[0] = object;
                    (this == GroupMemberAdded ? UserGroupAdded : UserGroupRemoved).log((GUID)objectArray, (String)object, string);
                }
                catch (Throwable throwable) {
                    LogManager.getConfigLogger().error(throwable);
                }
                break;
            }
            case UserGroupAdded: 
            case UserGroupRemoved: {
                properties.setProperty("group", extraParams[0].toString());
                try {
                    objectArray = GUID.valueOf(extraParams[0].toString());
                    object = UserGroupManager.getRecoveryEnabledInstance().getGroup((GUID)objectArray);
                    extraParams[0] = object != null ? ((UserGroupInfo)object).getDisplayName() : objectArray.toString();
                }
                catch (Throwable throwable) {
                    LogManager.getConfigLogger().error(throwable);
                }
                break;
            }
        }
        if (extraParams == null || extraParams.length == 0) {
            objectArray = new Object[1];
        } else {
            objectArray = new Object[extraParams.length + 1];
            System.arraycopy(extraParams, 0, objectArray, 1, extraParams.length);
        }
        objectArray[0] = displayname == null ? id : displayname;
        object = UsersAndGroups.MSG.getMsg(Locale.getDefault(), "eventlog." + this.name(), objectArray);
        object2 = new Json().toJson(properties);
        a.log(this, (String)object, (String)object2, id, displayname);
    }

    private static /* synthetic */ UsersAndGroupsEventLog[] a() {
        return new UsersAndGroupsEventLog[]{UserCreated, UserDeleted, UserDeactivated, UserReactivated, UserPermissionsAdded, UserPermissionsRemoved, UserLoginAdded, UserLoginRemoved, UserDataChanged, UserDataTakeOut, UserGroupAdded, UserGroupRemoved, UserLocked, UserUnlocked, UserBlockingNoticeSet, UserBlockingNoticeRemoved, GroupCreated, GroupDeactivated, GroupDeleted, GroupMemberAdded, GroupMemberRemoved, GroupPermissionsAdded, GroupPermissionsRemoved, GroupDataChanged, DataRestoredFromBackup};
    }

    static {
        b = UsersAndGroupsEventLog.a();
        a = EventLog.register("usersandgroups");
    }
}

