/*
 * Decompiled with CFR 0.152.
 */
package com.inet.thread.job.manager;

import com.inet.config.ConfigKey;
import com.inet.config.ConfigValue;
import com.inet.error.ErrorCodeObject;
import com.inet.logging.LogManager;
import com.inet.logging.Logger;
import com.inet.plugin.ApplicationDescription;
import com.inet.plugin.ServerPluginManager;
import com.inet.thread.NamedTask;
import com.inet.thread.RunnableSession;
import com.inet.thread.SessionLocator;
import com.inet.thread.ThreadPool;
import com.inet.thread.ThreadStackTrace;
import com.inet.thread.job.AlreadyFinishedException;
import com.inet.thread.job.Job;
import com.inet.thread.job.JobDoneListener;
import com.inet.thread.job.JobInfo;
import com.inet.thread.job.ManageableJobState;
import com.inet.thread.job.PausableJob;
import com.inet.thread.job.TerminatedBy;
import com.inet.thread.job.TerminatedByPausing;
import com.inet.thread.job.manager.JobManagerCompleteCallback;
import com.inet.thread.job.manager.JobObserver;
import com.inet.thread.job.manager.ManageableJob;
import com.inet.thread.job.manager.MemoryObsFinalizer;
import com.inet.thread.job.manager.MemoryObserverListener;
import com.inet.thread.job.manager.PausableManageableJob;
import com.inet.thread.job.manager.queue.ManageableJobQueue;
import com.inet.thread.job.manager.queue.TakeOnePerUserQueue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class JobManager {
    public static final Logger LOGGER = LogManager.getLogger("JobManager");
    static final ConfigValue<Integer> a = new ConfigValue<Integer>(ConfigKey.JOB_TIME_UNTIL_NEXT_JOB_PAUSED){

        public Integer a() {
            Integer n2 = (Integer)super.get();
            if (n2 < 0) {
                return 5000;
            }
            return n2;
        }

        @Override
        public /* synthetic */ Object get() {
            return this.a();
        }
    };
    public static final ConfigValue<Integer> THREAD_POOL_MAX_SIZE = new ConfigValue<Integer>(ConfigKey.JOB_CONCURRENT_TASKS){

        public Integer a() {
            Integer n2 = (Integer)super.get();
            if (n2 < 1) {
                ServerPluginManager serverPluginManager = ServerPluginManager.getInstance();
                if (serverPluginManager.getState() == ServerPluginManager.ServerPluginManagerState.INIT) {
                    n2 = ApplicationDescription.get().getDefaultNumberOfJobs();
                    if (n2 < 1) {
                        n2 = 1;
                    }
                    super.setValue(n2.toString());
                } else {
                    n2 = 1;
                }
            }
            return n2;
        }

        @Override
        public /* synthetic */ Object get() {
            return this.a();
        }
    };
    public static final int MAX_WEIGHT = 1000;
    @Nonnull
    private final @Nonnull List<@Nonnull ManageableJob<?, ?>> b = new ArrayList(5);
    private List<@Nonnull ManageableJob<?, ?>> c = new ArrayList();
    private ManageableJobQueue d = new TakeOnePerUserQueue(Collections.unmodifiableList(this.b));
    private ThreadPool e = ThreadPool.DEFAULT;
    private long f = 0L;
    private MemoryObsFinalizer g;
    private boolean h;
    private static JobManager i;
    private static JobObserver j;

    JobManager() {
        MemoryObserverListener memoryObserverListener = new MemoryObserverListener(){

            @Override
            public void onLowMemory() {
                JobManager.this.a(MemoryObsFinalizer.MemoryState.LOW);
                JobManager.this.d();
            }

            @Override
            public void onGoodMemory() {
                JobManager.this.a(MemoryObsFinalizer.MemoryState.GOOD);
                JobManager.this.d(null);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public long memoryUsedByCache() {
                ArrayList arrayList;
                JobManager jobManager = JobManager.this;
                synchronized (jobManager) {
                    arrayList = new ArrayList(JobManager.this.b);
                }
                long l2 = 0L;
                for (ManageableJob manageableJob : arrayList) {
                    l2 += manageableJob.job().memorySize();
                }
                return l2;
            }
        };
        this.g = this.a(memoryObserverListener);
    }

    private void a(MemoryObsFinalizer.MemoryState memoryState) {
        if (LOGGER.isInfo()) {
            LOGGER.debug("Memory State is " + String.valueOf((Object)memoryState));
            LOGGER.info(String.format("Running jobs %d, waiting=%d", this.b.size(), this.d.size()));
        }
    }

    private void b() {
        if (this.h) {
            throw new IllegalStateException("This JobManager was stopped.");
        }
    }

    @Nonnull
    public synchronized <RT> CompletableFuture<RT> submitJob(@Nonnull Job<RT> job) {
        this.b();
        return this.a(this.a(job)).getFuture();
    }

    @Nonnull
    public synchronized <RT> JobSubmitData<RT> submitManagedJob(@Nonnull Job<RT> job) {
        this.b();
        return this.a(this.a(job));
    }

    @Nonnull
    private <RT> ManageableJob<RT, ?> a(@Nonnull Job<RT> job) {
        ManageableJob manageableJob = job instanceof PausableJob ? new PausableManageableJob((PausableJob)job, this.a(THREAD_POOL_MAX_SIZE.get())) : new ManageableJob(job, this.a(THREAD_POOL_MAX_SIZE.get()));
        return manageableJob;
    }

    public synchronized void terminateJob(String jobUUID) {
        this.b();
        this.a(jobUUID, TerminatedBy.byAdmin());
    }

    synchronized void a(String string, TerminatedBy terminatedBy) {
        this.a(string).ifPresent(manageableJob -> this.a((ManageableJob)manageableJob, (Object)terminatedBy));
    }

    @Nonnull
    private synchronized <RT> JobSubmitData<RT> a(final @Nonnull ManageableJob<RT, ?> manageableJob) {
        LOGGER.debug("Submitted job " + manageableJob.job().name());
        manageableJob.setJobManagerInternal(new JobManagerCompleteCallback<RT>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void whenComplete(RT result, Throwable throwable) {
                JobManager jobManager = JobManager.this;
                synchronized (jobManager) {
                    if (throwable instanceof CancellationException) {
                        switch (manageableJob.manageableJobState()) {
                            case FAILED: 
                            case FINISHED: 
                            case TERMINATED: 
                            case TERMINATING: {
                                break;
                            }
                            case READY: 
                            case WAITING: 
                            case STARTED: 
                            case STARTING: 
                            case PAUSED: 
                            case PAUSING: {
                                JobManager.this.a(manageableJob, TerminatedBy.byClient());
                            }
                        }
                        return;
                    }
                    if (throwable != null && !manageableJob.is(ManageableJobState.FAILED)) {
                        LOGGER.warn(String.format("Job %s was completedExceptionally from outside JobManager. JobManager will count the Job as FAILED.", manageableJob.job().name()));
                        JobManager.this.a(manageableJob, throwable);
                    }
                    if (result != null && !manageableJob.is(ManageableJobState.FINISHED)) {
                        LOGGER.warn(String.format("Job %s was completed from outside JobManager. JobManager will count the job as FINISHED", manageableJob.job().name()));
                        JobManager.this.a(manageableJob, result);
                    }
                }
            }
        });
        this.d.add(manageableJob);
        this.b(manageableJob);
        this.d(null);
        this.a(false);
        return new JobSubmitData<RT>(manageableJob.uuid(), manageableJob.completableFuture());
    }

    private synchronized void b(ManageableJob<?, ?> manageableJob2) {
        LOGGER.debug("[Sub] Job Session is " + String.valueOf(manageableJob2.job().getSession()));
        if (!SessionLocator.exists()) {
            LOGGER.debug("[Sub] has no Session");
            return;
        }
        List<RunnableSession> list = this.e.getParentSessionsForCurrentThread();
        for (RunnableSession runnableSession : list) {
            Optional<ManageableJob> optional = this.b.stream().filter(manageableJob -> manageableJob.job().getSession() == runnableSession).findFirst();
            if (!optional.isPresent()) continue;
            manageableJob2.setParentJob(optional.get());
            break;
        }
        if (manageableJob2.getParentJob() != null) {
            if (this.c(manageableJob2)) {
                LOGGER.debug(String.format("Start Job %s now because is a sub job of %s", manageableJob2.job().name(), manageableJob2.getParentJob().job().name()));
                this.f(manageableJob2);
            }
        } else {
            LOGGER.debug("[Sub] does not match a running job's session");
        }
    }

    private synchronized boolean c(@Nonnull ManageableJob<?, ?> manageableJob) {
        if (manageableJob.getParentJob() == null) {
            LOGGER.debug("[Sub] [Start] has no parent job");
            return false;
        }
        List<ManageableJob<?, ?>> list = manageableJob.getParentJob().getSubJobs();
        if (list.isEmpty()) {
            LOGGER.warn("Inconsistent job hierarchy: " + String.valueOf(manageableJob) + " is a child process of " + String.valueOf(manageableJob.getParentJob()) + " but is not registered a in it's list of children");
            return true;
        }
        ManageableJob<?, ?> manageableJob2 = list.get(0);
        if (manageableJob2 == manageableJob) {
            LOGGER.debug("[Sub] [Start] is first job");
            return true;
        }
        for (ManageableJob<?, ?> manageableJob3 : list) {
            if (!this.b.contains(manageableJob3)) continue;
            LOGGER.debug("[Sub] [Start] already running");
            return false;
        }
        return true;
    }

    private synchronized void d(ManageableJob<?, ?> manageableJob) {
        try {
            if (manageableJob != null && manageableJob.getParentJob() != null) {
                ManageableJob<?, ?> manageableJob2 = manageableJob.getParentJob();
                manageableJob2.removeSubJob(manageableJob);
                List<ManageableJob<?, ?>> list = manageableJob2.getSubJobs();
                if (!list.isEmpty()) {
                    boolean bl = false;
                    for (ManageableJob<?, ?> manageableJob3 : list) {
                        if (!this.b.contains(manageableJob3)) continue;
                        bl = true;
                    }
                    if (!bl) {
                        this.f(list.get(0));
                    }
                }
            }
            if (this.g.memoryState() != MemoryObsFinalizer.MemoryState.GOOD && !this.b.isEmpty()) {
                System.gc();
            } else {
                ManageableJob<?, ?> manageableJob4;
                long l2 = this.g.freeMemory();
                while ((manageableJob4 = this.c()) != null) {
                    if (this.a(manageableJob4, l2)) {
                        this.f(manageableJob4);
                        l2 -= (long)manageableJob4.estimatedMemory();
                        continue;
                    }
                    return;
                }
            }
        }
        catch (Throwable throwable) {
            LOGGER.fatal("Cannot Start new Jobs");
            LOGGER.fatal(throwable);
        }
    }

    private synchronized ManageableJob<?, ?> c() {
        if (!this.c.isEmpty()) {
            return this.c.get(0);
        }
        return this.d.getNextWaitingJobToExecute();
    }

    private synchronized void a(boolean bl) {
        int n2 = -1;
        for (ManageableJob manageableJob : this.d) {
            if (bl && ++n2 == 0) continue;
            manageableJob.sendStatusChangeIfWaitingPositionChanged(n2);
        }
    }

    private synchronized boolean a(ManageableJob<?, ?> manageableJob2, long l2) {
        int n2;
        if (this.b.size() >= THREAD_POOL_MAX_SIZE.get() && this.b.stream().filter(manageableJob -> this.e((ManageableJob<?, ?>)manageableJob)).count() >= (long)THREAD_POOL_MAX_SIZE.get().intValue()) {
            return false;
        }
        LOGGER.debug("Check if can START: " + manageableJob2.job().name());
        if (manageableJob2.manageableJobState() == ManageableJobState.PAUSING) {
            LOGGER.debug("Cannot START: Job's State is Pausing");
            return false;
        }
        if (this.b.isEmpty()) {
            return true;
        }
        if (this.g.memoryState() != MemoryObsFinalizer.MemoryState.GOOD) {
            LOGGER.debug("Cannot START: State is not GOOD");
            return false;
        }
        int n3 = this.b.stream().mapToInt(ManageableJob::weight).sum();
        if (1000 - n3 < (n2 = manageableJob2.weight())) {
            LOGGER.debug(String.format("Cannot START: job has weight %d, which is too much", n2));
            return false;
        }
        if (l2 - MemoryObsFinalizer.MEM_LOW_THRESHOLD < (long)manageableJob2.estimatedMemory()) {
            LOGGER.debug(String.format("Cannot START: job requires %d MB", manageableJob2.estimatedMemory()));
            return false;
        }
        long l3 = this.b.stream().mapToInt(ManageableJob::estimatedMemory).sum();
        if (this.g.maxMemory() - MemoryObsFinalizer.MEM_LOW_THRESHOLD - l3 < (long)manageableJob2.estimatedMemory()) {
            LOGGER.debug(String.format("Cannot START: job requires %d MB, which we do not have considering estimations of running jobs", manageableJob2.estimatedMemory()));
            return false;
        }
        return true;
    }

    private synchronized boolean e(@Nonnull ManageableJob<?, ?> manageableJob) {
        if (!this.b.contains(manageableJob)) {
            return false;
        }
        List<ManageableJob<?, ?>> list = manageableJob.getSubJobs();
        if (list.isEmpty()) {
            return true;
        }
        for (ManageableJob<?, ?> manageableJob2 : list) {
            if (!this.b.contains(manageableJob2)) continue;
            return false;
        }
        return true;
    }

    private synchronized <RT> void f(ManageableJob<RT, ?> manageableJob) {
        LOGGER.info(String.format("Starting job %s.", manageableJob.job().name()));
        RunnableSession runnableSession = manageableJob.job().getSession();
        ThreadPool.Work<RT> work = manageableJob.getParentJob() != null ? this.e.startSubThread(new a<RT>(manageableJob), runnableSession, manageableJob.getParentJob().job().getSession()) : this.e.startMainThread(new a<RT>(manageableJob), runnableSession, null);
        this.b.add(manageableJob);
        this.d.remove(manageableJob);
        this.c.remove(manageableJob);
        this.a(false);
        manageableJob.onStarting(work);
    }

    private synchronized void a(ManageableJob<?, ?> manageableJob, TerminatedBy terminatedBy) {
        LOGGER.info("Terminate the job " + manageableJob.job().name() + " by " + String.valueOf((Object)terminatedBy.getType()));
        if (!this.b.contains(manageableJob)) {
            this.d.remove(manageableJob);
            this.c.remove(manageableJob);
            this.b.add(manageableJob);
            this.a(false);
        }
        manageableJob.setTerminatedBy(terminatedBy);
        ThreadPool.Work work = null;
        switch (manageableJob.manageableJobState()) {
            case FAILED: 
            case FINISHED: 
            case TERMINATED: 
            case TERMINATING: {
                return;
            }
            case READY: 
            case WAITING: 
            case STARTED: 
            case PAUSED: 
            case PAUSING: {
                if (manageableJob.manageableJobState() != ManageableJobState.PAUSING || manageableJob.stateOfPause() != ManageableJob.ThreadState.RUNNING) {
                    work = ThreadPool.DEFAULT.startSubThread(() -> {
                        Thread.currentThread().setName("Terminate Thread for " + manageableJob.job().name());
                        this.g(manageableJob);
                        this.d(manageableJob);
                    }, manageableJob.job().getSession());
                }
            }
            case STARTING: {
                manageableJob.onTerminating(work);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void g(ManageableJob<?, ?> manageableJob) {
        try {
            manageableJob.job().terminate(manageableJob.getTerminatedBy());
        }
        finally {
            JobManager jobManager = this;
            synchronized (jobManager) {
                this.b.remove(manageableJob);
                LOGGER.info("Job terminated " + manageableJob.job().name());
                manageableJob.onTerminate();
            }
        }
    }

    private int a(int n2) {
        return 1000 / n2;
    }

    private synchronized <RT> void a(ManageableJob<RT, ?> manageableJob, RT RT) {
        LOGGER.info("Job finished " + manageableJob.job().name());
        this.b.remove(manageableJob);
        this.d.remove(manageableJob);
        this.c.remove(manageableJob);
        manageableJob.onFinish(RT);
        this.d(manageableJob);
        this.a(false);
    }

    private synchronized void a(ManageableJob<?, ?> manageableJob, Throwable throwable) {
        LOGGER.error(ErrorCodeObject.create(String.format("Job failed %s: %s : %s", manageableJob.job().name(), throwable.getClass().getName(), throwable.getMessage()), throwable));
        LOGGER.error(throwable);
        this.b.remove(manageableJob);
        this.d.remove(manageableJob);
        this.c.remove(manageableJob);
        manageableJob.onFailed(throwable);
        this.d(manageableJob);
        this.a(false);
    }

    private synchronized void d() {
        boolean bl;
        long l2 = System.currentTimeMillis();
        boolean bl2 = bl = l2 - this.f >= (long)a.get().intValue();
        if (bl && this.b.size() > 1) {
            for (int i2 = this.b.size() - 1; i2 >= 0; --i2) {
                ManageableJob<?, ?> manageableJob2 = this.b.get(i2);
                if (!(manageableJob2 instanceof PausableManageableJob) || manageableJob2.getParentJob() != null) continue;
                if (manageableJob2.is(ManageableJobState.STARTING)) {
                    LOGGER.debug("Pause the job later because is still starting: " + manageableJob2.job().name());
                    break;
                }
                if (manageableJob2.is(ManageableJobState.TERMINATING)) {
                    LOGGER.debug("Pause the job later because is already terminating: " + manageableJob2.job().name());
                    break;
                }
                int n2 = this.a(this.b.size() - 1);
                this.b.stream().forEach(manageableJob -> manageableJob.setWeight(n2));
                this.a((PausableManageableJob)manageableJob2);
                this.f = l2;
                break;
            }
        }
    }

    private synchronized <RT> void a(final PausableManageableJob<RT> pausableManageableJob) {
        LOGGER.info("Pause the job " + ((PausableJob)pausableManageableJob.job()).name());
        ThreadPool.Work<Object> work = ThreadPool.DEFAULT.startSubThread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                JobManager jobManager;
                Thread.currentThread().setName("Pauser Thread for " + ((PausableJob)pausableManageableJob.job()).name());
                try {
                    ((PausableJob)pausableManageableJob.job()).pause();
                    JobManager jobManager2 = JobManager.this;
                    synchronized (jobManager2) {
                        pausableManageableJob.pauseFinishedWith(ManageableJob.ThreadState.RETURNED);
                        if (!pausableManageableJob.is(ManageableJobState.TERMINATING) || !pausableManageableJob.is(ManageableJobState.TERMINATING)) {
                            if (pausableManageableJob.stateOfCall() != ManageableJob.ThreadState.RUNNING) {
                                JobManager.this.h(pausableManageableJob);
                            }
                            JobManager.this.d(null);
                        }
                    }
                }
                catch (AlreadyFinishedException alreadyFinishedException) {
                    jobManager = JobManager.this;
                    synchronized (jobManager) {
                        pausableManageableJob.pauseFinishedWith(ManageableJob.ThreadState.ALREADY_FINISHED);
                        if (!pausableManageableJob.is(ManageableJobState.TERMINATED)) {
                            if (pausableManageableJob.stateOfCall() == ManageableJob.ThreadState.TERMINATED_BY_PAUSING) {
                                JobManager.this.a((ManageableJob<?, ?>)pausableManageableJob, new IllegalStateException("Pause cannot end with ALREADY_FINISHED when call() ended with TERMINATED_BY_PAUSING.", alreadyFinishedException));
                            }
                            if (pausableManageableJob.stateOfCall() == ManageableJob.ThreadState.THREW) {
                                JobManager.this.a((ManageableJob<?, ?>)pausableManageableJob, new IllegalStateException("Pause cannot end with ALREADY_FINISHED when call() threw an exception.", alreadyFinishedException));
                            }
                            if (pausableManageableJob.stateOfCall() == ManageableJob.ThreadState.RETURNED) {
                                LOGGER.debug("Job threw AlreadyFinished " + ((PausableJob)pausableManageableJob.job()).name());
                                JobManager.this.a(pausableManageableJob, pausableManageableJob.getResultOfCallWhilePausing());
                            }
                        }
                    }
                }
                catch (Throwable throwable) {
                    JobManager jobManager3 = JobManager.this;
                    synchronized (jobManager3) {
                        pausableManageableJob.pauseFinishedWith(ManageableJob.ThreadState.THREW);
                        if (!pausableManageableJob.is(ManageableJobState.TERMINATED) && !pausableManageableJob.is(ManageableJobState.TERMINATING)) {
                            JobManager.this.a((ManageableJob<?, ?>)pausableManageableJob, throwable);
                        }
                    }
                }
                finally {
                    boolean bl = false;
                    jobManager = JobManager.this;
                    synchronized (jobManager) {
                        pausableManageableJob.setResultOfCallWhilePausing(null);
                        if (pausableManageableJob.is(ManageableJobState.TERMINATING)) {
                            bl = true;
                        }
                    }
                    if (bl) {
                        LOGGER.debug("Terminate the job now because terminate() was called while pausing " + ((PausableJob)pausableManageableJob.job()).name());
                        JobManager.this.g(pausableManageableJob);
                    }
                }
            }
        }, ((PausableJob)pausableManageableJob.job()).getSession());
        this.b.remove(pausableManageableJob);
        this.c.add(0, pausableManageableJob);
        pausableManageableJob.onPausing(work);
    }

    public static synchronized JobManager instance() {
        if (i == null) {
            i = new JobManager();
            j = new JobObserver(i);
        }
        return i;
    }

    public static synchronized void stop() {
        if (j != null) {
            j.shutdown();
        }
        if (i != null) {
            i.informationAboutJobs().stream().forEach(jobInfo -> i.terminateJob(jobInfo.getUuid()));
            JobManager.i.h = true;
        }
        i = null;
    }

    public void addJobDoneListener(@Nonnull JobDoneListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("I said NOT NULL!");
        }
        ManageableJob.a.add(listener);
    }

    public void removeJobDoneListener(@Nonnull JobDoneListener listener) {
        ManageableJob.a.remove(listener);
    }

    MemoryObsFinalizer a(MemoryObserverListener memoryObserverListener) {
        return new MemoryObsFinalizer(memoryObserverListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<JobInfo> informationAboutJobs() {
        this.b();
        ArrayList<JobInfo> arrayList = new ArrayList<JobInfo>();
        ArrayList<ManageableJob> arrayList2 = new ArrayList<ManageableJob>();
        int n2 = 1;
        JobManager jobManager = this;
        synchronized (jobManager) {
            this.b.stream().forEach(manageableJob -> arrayList2.add((ManageableJob)manageableJob));
            this.c.stream().forEach(manageableJob -> arrayList2.add((ManageableJob)manageableJob));
            n2 -= this.b.size();
            for (ManageableJob manageableJob2 : this.d) {
                arrayList2.add(manageableJob2);
            }
        }
        for (ManageableJob manageableJob3 : arrayList2) {
            arrayList.add(this.a(manageableJob3, n2++));
        }
        return arrayList;
    }

    private JobInfo a(ManageableJob<?, ?> manageableJob, int n2) {
        List<ThreadStackTrace> list = this.e.getStackTraces(manageableJob.job().getSession());
        return JobInfo.from(manageableJob, list, n2 < 1 ? 0 : n2);
    }

    private Optional<ManageableJob<?, ?>> a(String string) {
        for (ManageableJob<Object, Object> manageableJob : this.b) {
            if (!manageableJob.uuid().equals(string)) continue;
            return Optional.of(manageableJob);
        }
        for (ManageableJob<Object, Object> manageableJob : this.d) {
            if (!manageableJob.uuid().equals(string)) continue;
            return Optional.of(manageableJob);
        }
        for (ManageableJob<Object, Object> manageableJob : this.c) {
            if (!manageableJob.uuid().equals(string)) continue;
            return Optional.of(manageableJob);
        }
        return Optional.empty();
    }

    synchronized List<ManageableJob<?, ?>> a() {
        return new ArrayList(this.b);
    }

    private synchronized void h(ManageableJob<?, ?> manageableJob) {
        LOGGER.debug("Job PAUSED " + manageableJob.job().name());
        manageableJob.onPaused();
    }

    public class JobSubmitData<RT> {
        private String b;
        @Nonnull
        private CompletableFuture<RT> c;

        private JobSubmitData(@Nonnull String uuid, CompletableFuture<RT> future) {
            this.b = uuid;
            this.c = future;
        }

        public String getUuid() {
            return this.b;
        }

        @Nonnull
        public CompletableFuture<RT> getFuture() {
            return this.c;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        public JobInfo getJobInfo() {
            JobManager.this.b();
            ManageableJob<Object, Object> manageableJob = null;
            int n2 = 0;
            JobManager jobManager = JobManager.this;
            synchronized (jobManager) {
                for (ManageableJob<Object, Object> manageableJob2 : JobManager.this.b) {
                    if (!manageableJob2.uuid().equals(this.b)) continue;
                    manageableJob = manageableJob2;
                }
                if (manageableJob == null) {
                    for (ManageableJob<Object, Object> manageableJob2 : JobManager.this.c) {
                        if (!manageableJob2.uuid().equals(this.b)) continue;
                        manageableJob = manageableJob2;
                    }
                }
                if (manageableJob == null) {
                    for (ManageableJob<Object, Object> manageableJob2 : JobManager.this.d) {
                        ++n2;
                        if (!manageableJob2.uuid().equals(this.b)) continue;
                        manageableJob = manageableJob2;
                    }
                }
            }
            if (manageableJob != null) {
                return JobManager.this.a(manageableJob, n2);
            }
            return null;
        }
    }

    private class a<RT>
    implements NamedTask,
    Callable<RT> {
        private ManageableJob<RT, ?> b;

        private a(ManageableJob<RT, ?> manageableJob) {
            this.b = manageableJob;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Nullable
        public RT call() throws Exception {
            LOGGER.debug("Job call started for " + this.b.job().name());
            try {
                JobManager jobManager;
                Throwable throwable = null;
                try {
                    this.b.job().prepare();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    LOGGER.debug("Job prepare done for " + this.b.job().name());
                    boolean bl = false;
                    jobManager = JobManager.this;
                    synchronized (jobManager) {
                        if (this.b.is(ManageableJobState.TERMINATING)) {
                            bl = true;
                        } else if (throwable == null) {
                            this.b.onStart();
                        }
                    }
                    if (bl) {
                        LOGGER.debug("Terminate the job now because terminate() was called while starting " + this.b.job().name());
                        JobManager.this.g(this.b);
                        JobManager.this.d(this.b);
                        return null;
                    }
                }
                LOGGER.debug(String.format("Started job %s, it requires %d MB.", this.b.job().name(), this.b.estimatedMemory()));
                Object v = this.b.job().call();
                jobManager = JobManager.this;
                synchronized (jobManager) {
                    this.b.callFinishedWith(ManageableJob.ThreadState.RETURNED);
                    if (this.b.is(ManageableJobState.STARTED)) {
                        JobManager.this.a(this.b, v);
                    }
                    if (this.b.is(ManageableJobState.PAUSING)) {
                        switch (this.b.stateOfPause()) {
                            case ALREADY_FINISHED: {
                                LOGGER.debug("Job already finished " + this.b.job().name());
                                JobManager.this.a(this.b, v);
                                break;
                            }
                            case RETURNED: {
                                JobManager.this.h(this.b);
                                break;
                            }
                            case RUNNING: {
                                LOGGER.debug("Job call returned with result " + this.b.job().name());
                                this.b.setResultOfCallWhilePausing(v);
                                break;
                            }
                            default: {
                                throw new IllegalStateException(this.b.stateOfPause().toString());
                            }
                        }
                    }
                    JobManager.this.d(this.b);
                }
                LOGGER.debug("Job call ended " + this.b.job().name());
                return (RT)v;
            }
            catch (TerminatedByPausing terminatedByPausing) {
                JobManager jobManager = JobManager.this;
                synchronized (jobManager) {
                    this.b.callFinishedWith(ManageableJob.ThreadState.TERMINATED_BY_PAUSING);
                    if (this.b.is(ManageableJobState.STARTED)) {
                        JobManager.this.a((ManageableJob<?, ?>)this.b, new IllegalStateException("Call() cannot end with TERMINATED_BY_PAUSING if no pausing was triggered", terminatedByPausing));
                    }
                    if (this.b.is(ManageableJobState.PAUSING)) {
                        switch (this.b.stateOfPause()) {
                            case ALREADY_FINISHED: {
                                JobManager.this.a((ManageableJob<?, ?>)this.b, new IllegalStateException("Call() cannot end with TERMINATED_BY_PAUSING if pause ended with ALREADY_FINISHED"));
                                break;
                            }
                            case RETURNED: {
                                JobManager.this.h(this.b);
                                break;
                            }
                            case RUNNING: {
                                break;
                            }
                        }
                    }
                }
                LOGGER.debug("Job call ended by pausing " + this.b.job().name());
                throw terminatedByPausing;
            }
            catch (Throwable throwable) {
                JobManager jobManager = JobManager.this;
                synchronized (jobManager) {
                    this.b.callFinishedWith(ManageableJob.ThreadState.THREW);
                    if (this.b.is(ManageableJobState.STARTED) || this.b.is(ManageableJobState.STARTING)) {
                        JobManager.this.a(this.b, throwable);
                    } else if (this.b.is(ManageableJobState.PAUSING)) {
                        switch (this.b.stateOfPause()) {
                            case ALREADY_FINISHED: {
                                JobManager.this.a(this.b, throwable);
                                break;
                            }
                            case RETURNED: {
                                JobManager.this.h(this.b);
                                break;
                            }
                            case RUNNING: {
                                break;
                            }
                        }
                    }
                }
                LOGGER.debug("Job call got exception: " + this.b.job().name());
                LOGGER.debug(throwable);
                throw throwable;
            }
        }

        @Override
        public String getTaskName() {
            if (this.b.job() instanceof NamedTask) {
                return ((NamedTask)this.b.job()).getTaskName();
            }
            return this.b.job().name();
        }
    }
}

